/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.customizer.AddFrameworkPanel;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class CustomizerFrameworks
extends JPanel
implements HelpCtx.Provider,
ListSelectionListener {
    private final ProjectCustomizer.Category category;
    private WebProject project;
    private WebProjectProperties uiProperties;
    private List<WebModuleExtender> newExtenders = new LinkedList<WebModuleExtender>();
    private List<WebFrameworkProvider> usedFrameworks = new LinkedList<WebFrameworkProvider>();
    private List<String> addedFrameworks = new LinkedList<String>();
    private Map<WebFrameworkProvider, WebModuleExtender> extenders = new IdentityHashMap<WebFrameworkProvider, WebModuleExtender>();
    private ExtenderController controller = ExtenderController.create();
    private boolean initialized = false;
    private JButton jButtonAdd;
    private JLabel jLabelConfig;
    private JLabel jLabelFrameworks;
    private JList jListFrameworks;
    private JPanel jPanelConfig;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public CustomizerFrameworks(ProjectCustomizer.Category category, WebProjectProperties uiProperties) {
        this.category = category;
        this.uiProperties = uiProperties;
        this.initComponents();
        this.project = uiProperties.getProject();
        this.jListFrameworks.setModel(new DefaultListModel());
        ((DefaultListModel)this.jListFrameworks.getModel()).addElement(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_CustomizerFrameworks_Loading"));
        uiProperties.getLoadingFrameworksTask().addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CustomizerFrameworks.this.initFrameworksList(CustomizerFrameworks.this.project.getAPIWebModule());
                    }
                });
            }
        });
        if (uiProperties.getLoadingFrameworksTask().isFinished()) {
            this.initFrameworksList(this.project.getAPIWebModule());
        }
    }

    private void initFrameworksList(WebModule webModule) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Profile j2eeProfile = Profile.fromPropertiesString((String)this.uiProperties.getProject().evaluator().getProperty("j2ee.platform"));
        if (j2eeProfile == null) {
            j2eeProfile = Profile.JAVA_EE_6_WEB;
        }
        String serverInstanceID = this.uiProperties.getProject().evaluator().getProperty("j2ee.server.instance");
        ExtenderController.Properties properties = this.controller.getProperties();
        properties.setProperty("j2eeLevel", (Object)j2eeProfile.toPropertiesString());
        properties.setProperty("serverInstanceID", (Object)serverInstanceID);
        this.jListFrameworks.setModel(new DefaultListModel());
        LinkedList<WebModuleExtender> usedExtenders = new LinkedList<WebModuleExtender>();
        if (this.uiProperties.getCurrentFrameworks() != null) {
            for (WebFrameworkProvider framework : this.uiProperties.getCurrentFrameworks()) {
                this.usedFrameworks.add(framework);
                ((DefaultListModel)this.jListFrameworks.getModel()).addElement(framework.getName());
                WebModuleExtender extender = framework.createWebModuleExtender(webModule, this.controller);
                this.extenders.put(framework, extender);
                usedExtenders.add(extender);
                extender.addChangeListener((ChangeListener)new ExtenderListener(extender));
            }
        }
        this.jListFrameworks.getSelectionModel().setSelectionMode(0);
        this.jListFrameworks.addListSelectionListener(this);
        if (this.usedFrameworks.size() > 0) {
            this.jListFrameworks.setSelectedIndex(0);
        }
        if (WebFrameworks.getFrameworks().size() == this.jListFrameworks.getModel().getSize()) {
            this.jButtonAdd.setEnabled(false);
        }
        this.uiProperties.setExistingExtenders(usedExtenders);
    }

    private void initComponents() {
        this.jLabelFrameworks = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListFrameworks = new JList();
        this.jButtonAdd = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanelConfig = new JPanel();
        this.jLabelConfig = new JLabel();
        this.jLabelFrameworks.setDisplayedMnemonic(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_CustomizerFrameworks_ListMnemonic").charAt(0));
        this.jLabelFrameworks.setLabelFor(this.jListFrameworks);
        this.jLabelFrameworks.setText(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_UsedFrameworks"));
        this.jScrollPane1.setViewportView(this.jListFrameworks);
        this.jListFrameworks.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerFrameworks.class, (String)"ACS_Frameworks_FrameworksList_A11YDesc"));
        this.jButtonAdd.setMnemonic(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_CustomizerFrameworks_AddButton_LabelMnemonic").charAt(0));
        this.jButtonAdd.setText(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_AddFramework"));
        this.jButtonAdd.setActionCommand("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerFrameworks.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jPanelConfig.setLayout(new GridBagLayout());
        this.jLabelConfig.setLabelFor(this.jPanelConfig);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 373, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd)).addComponent(this.jSeparator1, -1, 456, Short.MAX_VALUE).addComponent(this.jPanelConfig, -1, 456, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelFrameworks).addComponent(this.jLabelConfig)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelFrameworks).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonAdd).addComponent(this.jScrollPane1, -2, 131, -2)).addGap(9, 9, 9).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelConfig).addGap(18, 18, 18).addComponent(this.jPanelConfig, -1, 171, Short.MAX_VALUE)));
        this.jButtonAdd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerFrameworks.class, (String)"ACS_Frameworks_AddButton_A11YDesc"));
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        AddFrameworkPanel panel = new AddFrameworkPanel(this.usedFrameworks);
        JPanel inner = new JPanel();
        inner.setLayout(new GridBagLayout());
        inner.getAccessibleContext().setAccessibleDescription(panel.getAccessibleContext().getAccessibleDescription());
        inner.getAccessibleContext().setAccessibleName(panel.getAccessibleContext().getAccessibleName());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        inner.add((Component)panel, gridBagConstraints);
        DialogDescriptor desc = new DialogDescriptor((Object)inner, NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_SelectWebExtension_DialogTitle"));
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (res.equals(NotifyDescriptor.YES_OPTION)) {
            List<WebFrameworkProvider> newFrameworks = panel.getSelectedFrameworks();
            WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
            for (int i = 0; i < newFrameworks.size(); ++i) {
                WebModuleExtender extender;
                WebFrameworkProvider framework = newFrameworks.get(i);
                if (!((DefaultListModel)this.jListFrameworks.getModel()).contains(framework.getName())) {
                    ((DefaultListModel)this.jListFrameworks.getModel()).addElement(framework.getName());
                }
                boolean added = false;
                if (this.usedFrameworks.size() == 0) {
                    this.usedFrameworks.add(framework);
                    added = true;
                } else {
                    for (int j = 0; j < this.usedFrameworks.size(); ++j) {
                        if (this.usedFrameworks.get(j).getName().equals(framework.getName())) continue;
                        this.usedFrameworks.add(framework);
                        added = true;
                        break;
                    }
                }
                if (added && (extender = framework.createWebModuleExtender(wm, this.controller)) != null) {
                    this.extenders.put(framework, extender);
                    this.newExtenders.add(extender);
                    extender.addChangeListener((ChangeListener)new ExtenderListener(extender));
                    this.addedFrameworks.add(framework.getName());
                }
                this.jListFrameworks.setSelectedValue(framework.getName(), true);
            }
            this.uiProperties.setNewExtenders(this.newExtenders);
            this.uiProperties.setNewFrameworksNames(this.addedFrameworks);
        }
        if (WebFrameworks.getFrameworks().size() == this.jListFrameworks.getModel().getSize()) {
            this.jButtonAdd.setEnabled(false);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerFrameworks.class);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String frameworkName = (String)this.jListFrameworks.getSelectedValue();
        int selectedIndex = this.jListFrameworks.getSelectedIndex();
        if (selectedIndex != -1 && selectedIndex < this.usedFrameworks.size()) {
            WebFrameworkProvider framework = this.usedFrameworks.get(selectedIndex);
            if (framework.getName().equals(frameworkName)) {
                WebModuleExtender extender = this.extenders.get(framework);
                if (extender != null) {
                    String message = MessageFormat.format(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_FrameworkConfiguration"), frameworkName);
                    this.jLabelConfig.setText(message);
                    this.jPanelConfig.removeAll();
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.gridheight = 0;
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    this.jPanelConfig.add((Component)extender.getComponent(), gridBagConstraints);
                    this.jPanelConfig.repaint();
                    this.jPanelConfig.revalidate();
                } else {
                    this.hideConfigPanel();
                }
            }
        } else {
            this.hideConfigPanel();
        }
    }

    private void hideConfigPanel() {
        this.jLabelConfig.setText("");
        this.jPanelConfig.removeAll();
        this.jPanelConfig.repaint();
        this.jPanelConfig.revalidate();
    }

    private final class ExtenderListener
    implements ChangeListener {
        private final WebModuleExtender extender;

        public ExtenderListener(WebModuleExtender extender) {
            this.extender = extender;
            extender.update();
            this.stateChanged(new ChangeEvent(this));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            CustomizerFrameworks.this.controller.setErrorMessage(null);
            if (this.extender.isValid()) {
                if (!CustomizerFrameworks.this.category.isValid()) {
                    CustomizerFrameworks.this.category.setValid(true);
                    CustomizerFrameworks.this.category.setErrorMessage(null);
                }
            } else {
                CustomizerFrameworks.this.category.setValid(false);
                CustomizerFrameworks.this.category.setErrorMessage(CustomizerFrameworks.this.controller.getErrorMessage());
            }
        }
    }
}

