/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class ParentConstructorCallHint
extends HintRule {
    private static final String HINT_ID = "Parent.Constructor.Call.Hint";
    private List<Hint> hints;
    private BaseDocument baseDocument;
    private FileObject fileObject;

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        this.hints = hints;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        this.baseDocument = context.doc;
        if (phpParseResult.getProgram() != null) {
            this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
            if (this.fileObject != null) {
                this.checkHints(phpParseResult, this.fileObject);
            }
        }
    }

    private void checkHints(PHPParseResult phpParseResult, FileObject fileObject) {
        Collection<? extends ClassScope> declaredClasses = ModelUtils.getDeclaredClasses(phpParseResult.getModel().getFileScope());
        for (ClassScope classScope : declaredClasses) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            MethodScope constructor = this.extractConstructor(classScope);
            MethodScope overriddenConstructor = this.extractOverriddenConstructor(classScope);
            if (constructor == null || overriddenConstructor == null) continue;
            ParametersDescriptor parametersDescriptor = new ParametersDescriptor(overriddenConstructor.getParameters());
            CheckVisitor checkVisitor = new CheckVisitor(constructor.getOffset());
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.createHint(checkVisitor.getConstructorCallDescriptor(), parametersDescriptor, constructor.getNameRange());
        }
    }

    private void createHint(ConstructorCallDescriptor constructorCallDescriptor, ParametersDescriptor parametersDescriptor, OffsetRange offsetRange) {
        if (constructorCallDescriptor.shouldBeHinted(parametersDescriptor) && this.showHint(offsetRange, this.baseDocument)) {
            this.hints.add(new Hint((Rule)this, constructorCallDescriptor.createMessage(parametersDescriptor), this.fileObject, offsetRange, null, 500));
        }
    }

    private MethodScope extractOverriddenConstructor(ClassScope classScope) {
        MethodScope result = null;
        HashSet<ClassScope> recursionDetection = new HashSet<ClassScope>();
        while (classScope != null && result == null && recursionDetection.add(classScope)) {
            ClassScope superClass = ModelUtils.getFirst(classScope.getSuperClasses());
            result = this.extractConstructor(superClass);
            classScope = superClass;
        }
        return result;
    }

    private MethodScope extractConstructor(ClassScope classScope) {
        MethodScope result = null;
        if (classScope != null) {
            result = ModelUtils.getFirst(classScope.getDeclaredConstructors());
        }
        return result;
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.ParentConstructorCallHintDesc();
    }

    public String getDisplayName() {
        return Bundle.ParentConstructorCallHintDisp();
    }

    private static final class ParametersDescriptor {
        private final List<? extends ParameterElement> parameters;
        private boolean processed = false;
        private int mandatoryCount = 0;
        private int optionalCount = 0;

        public ParametersDescriptor(List<? extends ParameterElement> parameters) {
            this.parameters = parameters;
        }

        public int getMandatoryCount() {
            if (!this.processed) {
                this.processParameters();
            }
            return this.mandatoryCount;
        }

        public int getOptionalCount() {
            if (!this.processed) {
                this.processParameters();
            }
            return this.optionalCount;
        }

        private void processParameters() {
            for (ParameterElement parameterElement : this.parameters) {
                if (parameterElement.isMandatory()) {
                    ++this.mandatoryCount;
                    continue;
                }
                ++this.optionalCount;
            }
            this.processed = true;
        }

        public boolean allows(int numberOfUsedParameters) {
            OffsetRange offsetRange = new OffsetRange(this.getMandatoryCount(), this.getMandatoryCount() + this.getOptionalCount());
            return offsetRange.containsInclusive(numberOfUsedParameters);
        }
    }

    private static final class ConstructorCallDescriptor {
        private final Description description;
        private final int parametersCount;

        public ConstructorCallDescriptor(Description description, int parametersCount) {
            this.description = description;
            this.parametersCount = parametersCount;
        }

        public boolean shouldBeHinted(ParametersDescriptor parametersDescriptor) {
            return this.description.shouldBeHinted(this.parametersCount, parametersDescriptor);
        }

        public String createMessage(ParametersDescriptor parametersDescriptor) {
            return this.description.createMessage(this.parametersCount, parametersDescriptor);
        }

        private static enum Description {
            IS_CALLED{

                @Override
                protected String createMessage(int parametersCount, ParametersDescriptor parametersDescriptor) {
                    return Bundle.ParentConstructorCallHintIsCalledText(parametersCount, parametersDescriptor.getMandatoryCount(), parametersDescriptor.getOptionalCount());
                }

                @Override
                protected boolean shouldBeHinted(int parametersCount, ParametersDescriptor parametersDescriptor) {
                    return !parametersDescriptor.allows(parametersCount);
                }
            }
            ,
            NOT_CALLED{

                @Override
                protected String createMessage(int parametersCount, ParametersDescriptor parametersDescriptor) {
                    return Bundle.ParentConstructorCallHintNotCalledText(parametersDescriptor.getMandatoryCount(), parametersDescriptor.getOptionalCount());
                }

                @Override
                protected boolean shouldBeHinted(int parametersCount, ParametersDescriptor parametersDescriptor) {
                    return true;
                }
            };


            protected abstract String createMessage(int var1, ParametersDescriptor var2);

            protected abstract boolean shouldBeHinted(int var1, ParametersDescriptor var2);
        }
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final int constructorOffset;
        private boolean inConstructor;
        private ConstructorCallDescriptor constructorCallDescriptor = new ConstructorCallDescriptor(ConstructorCallDescriptor.Description.NOT_CALLED, 0);

        public CheckVisitor(int constructorOffset) {
            this.constructorOffset = constructorOffset;
        }

        public ConstructorCallDescriptor getConstructorCallDescriptor() {
            return this.constructorCallDescriptor;
        }

        @Override
        public void visit(MethodDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.getStartOffset() <= this.constructorOffset && node.getEndOffset() >= this.constructorOffset) {
                this.inConstructor = true;
                super.visit(node);
                this.inConstructor = false;
            }
        }

        @Override
        public void visit(StaticMethodInvocation node) {
            String functionName;
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.inConstructor && (functionName = CodeUtils.extractFunctionName(node.getMethod())).equals("__construct")) {
                this.constructorCallDescriptor = new ConstructorCallDescriptor(ConstructorCallDescriptor.Description.IS_CALLED, node.getMethod().getParameters().size());
            }
        }
    }
}

