/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;

public class PHPDocMethodTag
extends PHPDocTypeTag {
    private final List<PHPDocVarTypeTag> params;
    private final PHPDocNode name;
    private final boolean isStatic;

    public PHPDocMethodTag(int start, int end, AnnotationParsedLine kind, List<PHPDocTypeNode> returnTypes, PHPDocNode methodName, List<PHPDocVarTypeTag> parameters, String documentation) {
        this(start, end, kind, returnTypes, methodName, parameters, documentation, false);
    }

    public PHPDocMethodTag(int start, int end, AnnotationParsedLine kind, List<PHPDocTypeNode> returnTypes, PHPDocNode methodName, List<PHPDocVarTypeTag> parameters, String documentation, boolean isStatic) {
        super(start, end, kind, documentation, returnTypes);
        this.params = parameters;
        this.name = methodName;
        this.isStatic = isStatic;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public PHPDocNode getMethodName() {
        return this.name;
    }

    public List<PHPDocVarTypeTag> getParameters() {
        return this.params;
    }

    @Override
    public String getDocumentation() {
        String retval = this.documentation;
        if (retval == null) {
            CommentExtractor commentExtractor = CommentExtractorImpl.create(this.name.getValue());
            retval = commentExtractor.extract(this.getValue());
        }
        return retval;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    private static interface CommentExtractor {
        public String extract(String var1);
    }

    private static class CommentExtractorImpl
    implements CommentExtractor {
        private final String methodName;
        private String originalDescription;
        private String currentDescription;
        private String comment = "";
        private int bracketBalance = 0;
        private boolean unexpectedCharacter = false;
        private boolean commentMatched = false;

        public static CommentExtractor create(String methodName) {
            return new CommentExtractorImpl(methodName);
        }

        private CommentExtractorImpl(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public String extract(String description) {
            int index;
            this.originalDescription = description;
            this.currentDescription = description;
            while ((index = this.currentDescription.lastIndexOf(40)) > -1) {
                this.findComment(index);
                if (!this.commentMatched) continue;
                break;
            }
            return this.comment;
        }

        private void findComment(int index) {
            String preDesc = this.currentDescription.substring(0, index);
            String postDesc = this.originalDescription.substring(index);
            int matchingBraceIndex = this.getMatchingBraceIndex(postDesc);
            if (preDesc.trim().endsWith(this.methodName) && matchingBraceIndex != 0) {
                this.comment = postDesc.substring(matchingBraceIndex + 1).trim();
                this.commentMatched = true;
            } else {
                this.currentDescription = preDesc;
            }
        }

        private int getMatchingBraceIndex(String subDescription) {
            int retval = 0;
            for (int i = 0; i < subDescription.length(); ++i) {
                this.countBracketBalance(subDescription.charAt(i));
                if (this.bracketBalance == 0 && !this.unexpectedCharacter) {
                    retval = i;
                    break;
                }
                if (this.unexpectedCharacter) break;
            }
            return retval;
        }

        private void countBracketBalance(char ch) {
            if (Character.isWhitespace(ch)) {
                return;
            }
            if (ch == '(') {
                ++this.bracketBalance;
            } else if (ch == ')') {
                --this.bracketBalance;
            } else {
                this.checkUnexpectedCharacter();
            }
        }

        private void checkUnexpectedCharacter() {
            if (this.bracketBalance == 0) {
                this.unexpectedCharacter = true;
            }
        }
    }
}

