/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.FormalParameterInfo;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.UnionType;
import org.openide.util.Pair;

public class FunctionDeclarationInfo
extends ASTNodeInfo<FunctionDeclaration> {
    private final Map<String, List<Pair<QualifiedName, Boolean>>> paramDocTypes;

    protected FunctionDeclarationInfo(Program program, FunctionDeclaration node) {
        super(node);
        this.paramDocTypes = program != null ? VariousUtils.getParamTypesFromPHPDoc(program, node) : Collections.emptyMap();
    }

    public static FunctionDeclarationInfo create(FunctionDeclaration functionDeclaration) {
        return new FunctionDeclarationInfo(null, functionDeclaration);
    }

    public static FunctionDeclarationInfo create(Program program, FunctionDeclaration functionDeclaration) {
        return new FunctionDeclarationInfo(program, functionDeclaration);
    }

    @Override
    public ASTNodeInfo.Kind getKind() {
        return ASTNodeInfo.Kind.FUNCTION;
    }

    @Override
    public String getName() {
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)this.getOriginalNode();
        return functionDeclaration.getFunctionName().getName();
    }

    @Override
    public QualifiedName getQualifiedName() {
        return QualifiedName.createUnqualifiedName(this.getName());
    }

    @Override
    public OffsetRange getRange() {
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)this.getOriginalNode();
        Identifier name = functionDeclaration.getFunctionName();
        return new OffsetRange(name.getStartOffset(), name.getEndOffset());
    }

    public List<ParameterElement> getParameters() {
        ArrayList<ParameterElement> retval = new ArrayList<ParameterElement>();
        List<FormalParameter> formalParameters = ((FunctionDeclaration)this.getOriginalNode()).getFormalParameters();
        for (FormalParameter formalParameter : formalParameters) {
            FormalParameterInfo parameterInfo = FormalParameterInfo.create(formalParameter, this.paramDocTypes);
            retval.add(parameterInfo.toParameter());
        }
        return retval;
    }

    public List<QualifiedName> getReturnTypes() {
        Expression returnType = ((FunctionDeclaration)this.getOriginalNode()).getReturnType();
        if (returnType == null) {
            return Collections.emptyList();
        }
        if (returnType instanceof UnionType) {
            return QualifiedName.create((UnionType)returnType);
        }
        return Collections.singletonList(QualifiedName.create(returnType));
    }
}

