/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.api;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ConstantElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.EnumCaseElement;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.NamespaceElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.api.elements.VariableElement;

public class AbstractElementQuery
implements ElementQuery {
    private final LinkedList<PhpElement> elements = new LinkedList();
    final ElementQuery.QueryScope queryScope;

    public AbstractElementQuery(ElementQuery.QueryScope queryScope) {
        this.queryScope = queryScope;
    }

    @Override
    public final Set<ClassElement> getClasses() {
        return this.getElements(ClassElement.class);
    }

    @Override
    public final Set<ClassElement> getClasses(NameKind query) {
        return this.getElements(ClassElement.class, query);
    }

    @Override
    public final Set<ConstantElement> getConstants() {
        return this.getElements(ConstantElement.class);
    }

    @Override
    public final Set<ConstantElement> getConstants(NameKind query) {
        return this.getElements(ConstantElement.class, query);
    }

    @Override
    public final Set<MethodElement> getConstructors(NameKind typeQuery) {
        ElementFilter forName = ElementFilter.forName(NameKind.exact("__construct"));
        return forName.filter(this.getElements(MethodElement.class, typeQuery));
    }

    @Override
    public final Set<FieldElement> getFields(NameKind.Exact classQuery, NameKind fieldQuery) {
        return this.getElements(FieldElement.class, classQuery, fieldQuery);
    }

    @Override
    public final Set<FieldElement> getFields(NameKind fieldQuery) {
        return this.getElements(FieldElement.class, fieldQuery);
    }

    @Override
    public final Set<FunctionElement> getFunctions() {
        return this.getElements(FunctionElement.class);
    }

    @Override
    public final Set<FunctionElement> getFunctions(NameKind query) {
        return this.getElements(FunctionElement.class, query);
    }

    @Override
    public final Set<InterfaceElement> getInterfaces() {
        return this.getElements(InterfaceElement.class);
    }

    @Override
    public final Set<InterfaceElement> getInterfaces(NameKind query) {
        return this.getElements(InterfaceElement.class, query);
    }

    @Override
    public final Set<MethodElement> getMethods(NameKind.Exact typeQuery, NameKind methodQuery) {
        return this.getElements(MethodElement.class, typeQuery, methodQuery);
    }

    @Override
    public final Set<MethodElement> getMethods(NameKind methodQuery) {
        return this.getElements(MethodElement.class, methodQuery);
    }

    @Override
    public final Set<NamespaceElement> getNamespaces(NameKind query) {
        return this.getElements(NamespaceElement.class, query);
    }

    @Override
    public final Set<TypeConstantElement> getTypeConstants(NameKind.Exact typeQuery, NameKind constantQuery) {
        return this.getElements(TypeConstantElement.class, typeQuery, constantQuery);
    }

    @Override
    public final Set<TypeConstantElement> getTypeConstants(NameKind constantQuery) {
        return this.getElements(TypeConstantElement.class, constantQuery);
    }

    @Override
    public Set<EnumCaseElement> getEnumCases(NameKind.Exact typeQuery, NameKind enumCaseQuery) {
        return this.getElements(EnumCaseElement.class, typeQuery, enumCaseQuery);
    }

    @Override
    public Set<EnumCaseElement> getEnumCases(NameKind enumCaseQuery) {
        return this.getElements(EnumCaseElement.class, enumCaseQuery);
    }

    @Override
    public final Set<TypeMemberElement> getTypeMembers(NameKind.Exact typeQuery, NameKind memberQuery) {
        return this.getElements(TypeMemberElement.class, memberQuery);
    }

    @Override
    public final Set<TypeElement> getTypes(NameKind query) {
        return this.getElements(TypeElement.class, query);
    }

    @Override
    public Set<VariableElement> getTopLevelVariables(NameKind query) {
        return this.getElements(VariableElement.class, query);
    }

    @Override
    public ElementQuery.QueryScope getQueryScope() {
        return this.queryScope;
    }

    public final synchronized <T extends PhpElement> Set<T> getElements(Class<T> clz) {
        HashSet<PhpElement> retval = new HashSet<PhpElement>();
        ElementFilter clsFilter = ElementFilter.forInstanceOf(clz);
        for (PhpElement phpElement : this.getElements()) {
            if (!clsFilter.isAccepted(phpElement)) continue;
            retval.add(phpElement);
        }
        return retval;
    }

    public final <T extends PhpElement> Set<T> getElements(Class<T> clz, NameKind query) {
        return ElementFilter.forName(query).filter(this.getElements(clz));
    }

    public final <T extends TypeMemberElement> Set<T> getElements(Class<T> clz, NameKind.Exact typeQuery, NameKind memberQuery) {
        return ElementFilter.allOf(ElementFilter.forName(memberQuery), ElementFilter.forMembersOfTypeName(typeQuery)).filter(this.getElements(clz));
    }

    public final synchronized void addElement(PhpElement retval) {
        this.getElements().add(retval);
    }

    public final synchronized void addElements(Set<? extends PhpElement> retval) {
        this.getElements().addAll(retval);
    }

    public final synchronized <T extends PhpElement> T getLast(Class<T> clz) {
        ElementFilter clsFilter = ElementFilter.forInstanceOf(clz);
        Iterator<PhpElement> it = this.elements.descendingIterator();
        while (it.hasNext()) {
            PhpElement phpElement = it.next();
            if (!clsFilter.isAccepted(phpElement)) continue;
            return (T)phpElement;
        }
        return null;
    }

    public final synchronized PhpElement getAnyLast(Class ... classes) {
        HashSet<ElementFilter> filters = new HashSet<ElementFilter>();
        for (Class clz : classes) {
            filters.add(ElementFilter.forInstanceOf(clz));
        }
        ElementFilter mergeFilter = ElementFilter.anyOf(filters);
        Iterator<PhpElement> it = this.elements.descendingIterator();
        while (it.hasNext()) {
            PhpElement phpElement = it.next();
            if (!mergeFilter.isAccepted(phpElement)) continue;
            return phpElement;
        }
        return null;
    }

    public LinkedList<PhpElement> getElements() {
        return this.elements;
    }
}

