/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.openide.WizardDescriptor;

public class UninstallUnitWizardModel
extends OperationWizardModel {
    private OperationWizardModel.OperationType operationType;
    private OperationContainer container;
    private OperationContainer<InstallSupport> installContainer;
    private OperationContainer<OperationSupport> customContainer;
    private InstallUnitWizardModel nestedInstall;

    public UninstallUnitWizardModel(OperationWizardModel.OperationType doOperation) {
        this.operationType = doOperation;
        this.customContainer = Containers.forCustomUninstall();
        switch (this.operationType) {
            case UNINSTALL: {
                this.container = Containers.forUninstall();
                break;
            }
            case ENABLE: {
                this.container = Containers.forEnable();
                this.installContainer = Containers.forAvailable();
                break;
            }
            case DISABLE: {
                this.container = Containers.forDisable();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        assert (this.container != null);
    }

    @Override
    public void recognizeButtons(WizardDescriptor wd) {
        super.recognizeButtons(wd);
        if (this.nestedInstall != null) {
            this.nestedInstall.recognizeButtons(wd);
        }
    }

    public InstallUnitWizardModel createInstallModel() {
        if (this.nestedInstall == null) {
            this.nestedInstall = new InstallUnitWizardModel(OperationWizardModel.OperationType.INSTALL, this.getInstallContainer()){

                @Override
                public void modifyOptionsForEndInstall(WizardDescriptor wd) {
                    this.modifyOptionsForContinue(wd, false);
                    this.modifyOptionsContinueWithCancel(wd);
                }

                @Override
                protected void performRefresh() {
                    UninstallUnitWizardModel.this.performRefresh();
                }
            };
        }
        return this.nestedInstall;
    }

    @Override
    public OperationWizardModel.OperationType getOperation() {
        return this.operationType;
    }

    @Override
    public OperationContainer getBaseContainer() {
        return this.container;
    }

    public OperationContainer<InstallSupport> getInstallContainer() {
        return this.installContainer;
    }

    @Override
    public OperationContainer<OperationSupport> getCustomHandledContainer() {
        return this.customContainer;
    }

    @Override
    protected void refresh(OperationContainer c) {
        if (this.container != c) {
            this.container = c;
        }
        if (this.installContainer != null) {
            this.installContainer.removeAll();
        }
    }
}

