/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.utils;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.core.network.utils.IpAddressUtils;

class IpAddressUtilsFilter {
    private static final boolean JDK_PREFER_IPV6_ADDRESS = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("java.net.preferIPv6Addresses");
        }
    });

    private IpAddressUtilsFilter() {
    }

    protected static InetAddress pickInetAddress(Iterable<InetAddress> sortedList, IpAddressUtils.IpTypePreference ipTypePref) {
        IpAddressUtils.IpTypePreference pref = IpAddressUtilsFilter.getIpTypePreferenceResolved(ipTypePref);
        for (InetAddress ipAddress : sortedList) {
            if (pref == IpAddressUtils.IpTypePreference.ANY_IPV4_PREF || pref == IpAddressUtils.IpTypePreference.ANY_IPV6_PREF) {
                return ipAddress;
            }
            if (ipAddress instanceof Inet4Address && pref == IpAddressUtils.IpTypePreference.IPV4_ONLY) {
                return ipAddress;
            }
            if (!(ipAddress instanceof Inet6Address) || pref != IpAddressUtils.IpTypePreference.IPV6_ONLY) continue;
            return ipAddress;
        }
        return null;
    }

    @NonNull
    protected static List<InetAddress> filterInetAddresses(Iterable<InetAddress> list, IpAddressUtils.IpTypePreference ipTypePref) {
        IpAddressUtils.IpTypePreference pref = IpAddressUtilsFilter.getIpTypePreferenceResolved(ipTypePref);
        ArrayList<InetAddress> newList = new ArrayList<InetAddress>();
        if (list != null) {
            for (InetAddress ipAddress : list) {
                if (pref == IpAddressUtils.IpTypePreference.ANY_IPV4_PREF || pref == IpAddressUtils.IpTypePreference.ANY_IPV6_PREF) {
                    newList.add(ipAddress);
                    continue;
                }
                if (ipAddress instanceof Inet4Address && pref == IpAddressUtils.IpTypePreference.IPV4_ONLY) {
                    newList.add(ipAddress);
                }
                if (!(ipAddress instanceof Inet6Address) || pref != IpAddressUtils.IpTypePreference.IPV6_ONLY) continue;
                newList.add(ipAddress);
            }
        }
        if (pref == IpAddressUtils.IpTypePreference.ANY_IPV4_PREF) {
            IpAddressUtils.sortIpAddressesShallow(newList, true);
        }
        if (pref == IpAddressUtils.IpTypePreference.ANY_IPV6_PREF) {
            IpAddressUtils.sortIpAddressesShallow(newList, false);
        }
        return newList;
    }

    private static IpAddressUtils.IpTypePreference getIpTypePreferenceResolved(IpAddressUtils.IpTypePreference ipTypePref) {
        if (ipTypePref == IpAddressUtils.IpTypePreference.ANY_JDK_PREF) {
            if (JDK_PREFER_IPV6_ADDRESS) {
                return IpAddressUtils.IpTypePreference.ANY_IPV6_PREF;
            }
            return IpAddressUtils.IpTypePreference.ANY_IPV4_PREF;
        }
        return ipTypePref;
    }
}

