/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.TreeElementDecl;
import org.netbeans.tax.TreeName;
import org.netbeans.tax.UnicodeClasses;
import org.netbeans.tax.Util;
import org.netbeans.tax.spec.AttlistDecl;
import org.netbeans.tax.spec.Attribute;
import org.netbeans.tax.spec.CDATASection;
import org.netbeans.tax.spec.CharacterReference;
import org.netbeans.tax.spec.Comment;
import org.netbeans.tax.spec.ConditionalSection;
import org.netbeans.tax.spec.DTD;
import org.netbeans.tax.spec.Document;
import org.netbeans.tax.spec.DocumentFragment;
import org.netbeans.tax.spec.DocumentType;
import org.netbeans.tax.spec.Element;
import org.netbeans.tax.spec.ElementDecl;
import org.netbeans.tax.spec.EntityDecl;
import org.netbeans.tax.spec.GeneralEntityReference;
import org.netbeans.tax.spec.NotationDecl;
import org.netbeans.tax.spec.ParameterEntityReference;
import org.netbeans.tax.spec.ProcessingInstruction;
import org.netbeans.tax.spec.Text;

public final class TreeUtilities {
    private static Constraints constraints = new Constraints();

    public static final void checkAttributeName(TreeName treeName) throws InvalidArgumentException {
        constraints.checkAttributeName(treeName);
    }

    public static final boolean isValidAttributeName(TreeName treeName) {
        return constraints.isValidAttributeName(treeName);
    }

    public static final void checkElementTagName(TreeName elementTreeName) throws InvalidArgumentException {
        constraints.checkElementTagName(elementTreeName);
    }

    public static final boolean isValidElementTagName(TreeName elementTreeName) {
        return constraints.isValidElementTagName(elementTreeName);
    }

    public static final void checkNotationDeclSystemId(String systemId) throws InvalidArgumentException {
        constraints.checkNotationDeclSystemId(systemId);
    }

    public static final boolean isValidNotationDeclSystemId(String systemId) {
        return constraints.isValidNotationDeclSystemId(systemId);
    }

    public static final void checkDocumentEncoding(String encoding) throws InvalidArgumentException {
        constraints.checkDocumentEncoding(encoding);
    }

    public static final boolean isValidDocumentEncoding(String encoding) {
        return constraints.isValidDocumentEncoding(encoding);
    }

    public static final void checkDTDEncoding(String encoding) throws InvalidArgumentException {
        constraints.checkDTDEncoding(encoding);
    }

    public static final boolean isValidDTDEncoding(String encoding) {
        return constraints.isValidDTDEncoding(encoding);
    }

    public static final void checkCharacterReferenceName(String name) throws InvalidArgumentException {
        constraints.checkCharacterReferenceName(name);
    }

    public static final boolean isValidCharacterReferenceName(String name) {
        return constraints.isValidCharacterReferenceName(name);
    }

    public static final void checkEntityDeclInternalText(String internalText) throws InvalidArgumentException {
        constraints.checkEntityDeclInternalText(internalText);
    }

    public static final boolean isValidEntityDeclInternalText(String internalText) {
        return constraints.isValidEntityDeclInternalText(internalText);
    }

    public static final void checkAttlistDeclElementName(String elementName) throws InvalidArgumentException {
        constraints.checkAttlistDeclElementName(elementName);
    }

    public static final boolean isValidAttlistDeclElementName(String elementName) {
        return constraints.isValidAttlistDeclElementName(elementName);
    }

    public static final void checkDTDVersion(String version) throws InvalidArgumentException {
        constraints.checkDTDVersion(version);
    }

    public static final boolean isValidDTDVersion(String version) {
        return constraints.isValidDTDVersion(version);
    }

    public static final void checkDocumentTypeSystemId(String systemId) throws InvalidArgumentException {
        constraints.checkDocumentTypeSystemId(systemId);
    }

    public static final boolean isValidDocumentTypeSystemId(String systemId) {
        return constraints.isValidDocumentTypeSystemId(systemId);
    }

    public static final void checkDocumentTypeElementName(String elementName) throws InvalidArgumentException {
        constraints.checkDocumentTypeElementName(elementName);
    }

    public static final boolean isValidDocumentTypeElementName(String elementName) {
        return constraints.isValidDocumentTypeElementName(elementName);
    }

    public static final void checkDocumentStandalone(String standalone) throws InvalidArgumentException {
        constraints.checkDocumentStandalone(standalone);
    }

    public static final boolean isValidDocumentStandalone(String standalone) {
        return constraints.isValidDocumentStandalone(standalone);
    }

    public static final void checkEntityDeclName(String name) throws InvalidArgumentException {
        constraints.checkEntityDeclName(name);
    }

    public static final boolean isValidEntityDeclName(String name) {
        return constraints.isValidEntityDeclName(name);
    }

    public static final void checkAttlistDeclAttributeEnumeratedType(String[] enumeratedType) throws InvalidArgumentException {
        constraints.checkAttlistDeclAttributeEnumeratedType(enumeratedType);
    }

    public static final boolean isValidAttlistDeclAttributeEnumeratedType(String[] enumeratedType) {
        return constraints.isValidAttlistDeclAttributeEnumeratedType(enumeratedType);
    }

    public static final void checkProcessingInstructionData(String data) throws InvalidArgumentException {
        constraints.checkProcessingInstructionData(data);
    }

    public static final boolean isValidProcessingInstructionData(String data) {
        return constraints.isValidProcessingInstructionData(data);
    }

    public static final void checkEntityDeclNotationName(String notationName) throws InvalidArgumentException {
        constraints.checkEntityDeclNotationName(notationName);
    }

    public static final boolean isValidEntityDeclNotationName(String notationName) {
        return constraints.isValidEntityDeclNotationName(notationName);
    }

    public static final void checkElementDeclName(String name) throws InvalidArgumentException {
        constraints.checkElementDeclName(name);
    }

    public static final boolean isValidElementDeclName(String name) {
        return constraints.isValidElementDeclName(name);
    }

    public static final void checkGeneralEntityReferenceName(String name) throws InvalidArgumentException {
        constraints.checkGeneralEntityReferenceName(name);
    }

    public static final boolean isValidGeneralEntityReferenceName(String name) {
        return constraints.isValidGeneralEntityReferenceName(name);
    }

    public static final void checkEntityDeclSystemId(String systemId) throws InvalidArgumentException {
        constraints.checkEntityDeclSystemId(systemId);
    }

    public static final boolean isValidEntityDeclSystemId(String systemId) {
        return constraints.isValidEntityDeclSystemId(systemId);
    }

    public static final void checkProcessingInstructionTarget(String target) throws InvalidArgumentException {
        constraints.checkProcessingInstructionTarget(target);
    }

    public static final boolean isValidProcessingInstructionTarget(String target) {
        return constraints.isValidProcessingInstructionTarget(target);
    }

    public static final void checkEntityDeclPublicId(String publicId) throws InvalidArgumentException {
        constraints.checkEntityDeclPublicId(publicId);
    }

    public static final boolean isValidEntityDeclPublicId(String publicId) {
        return constraints.isValidEntityDeclPublicId(publicId);
    }

    public static final void checkAttlistDeclAttributeDefaultValue(String defaultValue) throws InvalidArgumentException {
        constraints.checkAttlistDeclAttributeDefaultValue(defaultValue);
    }

    public static final boolean isValidAttlistDeclAttributeDefaultValue(String defaultValue) {
        return constraints.isValidAttlistDeclAttributeDefaultValue(defaultValue);
    }

    public static final void checkDocumentFragmentVersion(String version) throws InvalidArgumentException {
        constraints.checkDocumentFragmentVersion(version);
    }

    public static final boolean isValidDocumentFragmentVersion(String version) {
        return constraints.isValidDocumentFragmentVersion(version);
    }

    public static final void checkNotationDeclName(String name) throws InvalidArgumentException {
        constraints.checkNotationDeclName(name);
    }

    public static final boolean isValidNotationDeclName(String name) {
        return constraints.isValidNotationDeclName(name);
    }

    public static final void checkAttributeValue(String value) throws InvalidArgumentException {
        constraints.checkAttributeValue(value);
    }

    public static final boolean isValidAttributeValue(String value) {
        return constraints.isValidAttributeValue(value);
    }

    public static final void checkParameterEntityReferenceName(String name) throws InvalidArgumentException {
        constraints.checkParameterEntityReferenceName(name);
    }

    public static final boolean isValidParameterEntityReferenceName(String name) {
        return constraints.isValidParameterEntityReferenceName(name);
    }

    public static final void checkDocumentFragmentEncoding(String encoding) throws InvalidArgumentException {
        constraints.checkDocumentFragmentEncoding(encoding);
    }

    public static final boolean isValidDocumentFragmentEncoding(String encoding) {
        return constraints.isValidDocumentFragmentEncoding(encoding);
    }

    public static final void checkTextData(String data) throws InvalidArgumentException {
        constraints.checkTextData(data);
    }

    public static final boolean isValidTextData(String data) {
        return constraints.isValidTextData(data);
    }

    public static final void checkDocumentTypePublicId(String publicId) throws InvalidArgumentException {
        constraints.checkDocumentTypePublicId(publicId);
    }

    public static final boolean isValidDocumentTypePublicId(String publicId) {
        return constraints.isValidDocumentTypePublicId(publicId);
    }

    public static final void checkElementDeclContentType(TreeElementDecl.ContentType contentType) throws InvalidArgumentException {
        constraints.checkElementDeclContentType(contentType);
    }

    public static final boolean isValidElementDeclContentType(TreeElementDecl.ContentType contentType) {
        return constraints.isValidElementDeclContentType(contentType);
    }

    public static final void checkDocumentVersion(String version) throws InvalidArgumentException {
        constraints.checkDocumentVersion(version);
    }

    public static final boolean isValidDocumentVersion(String version) {
        return constraints.isValidDocumentVersion(version);
    }

    public static final void checkCDATASectionData(String data) throws InvalidArgumentException {
        constraints.checkCDATASectionData(data);
    }

    public static final boolean isValidCDATASectionData(String data) {
        return constraints.isValidCDATASectionData(data);
    }

    public static final void checkNotationDeclPublicId(String publicId) throws InvalidArgumentException {
        constraints.checkNotationDeclPublicId(publicId);
    }

    public static final boolean isValidNotationDeclPublicId(String publicId) {
        return constraints.isValidNotationDeclPublicId(publicId);
    }

    public static final void checkAttlistDeclAttributeName(String attributeName) throws InvalidArgumentException {
        constraints.checkAttlistDeclAttributeName(attributeName);
    }

    public static final boolean isValidAttlistDeclAttributeName(String attributeName) {
        return constraints.isValidAttlistDeclAttributeName(attributeName);
    }

    public static final void checkCommentData(String data) throws InvalidArgumentException {
        constraints.checkCommentData(data);
    }

    public static final boolean isValidCommentData(String data) {
        return constraints.isValidCommentData(data);
    }

    public static final void checkAttlistDeclAttributeType(short type) throws InvalidArgumentException {
        constraints.checkAttlistDeclAttributeType(type);
    }

    public static final boolean isValidAttlistDeclAttributeType(short type) {
        return constraints.isValidAttlistDeclAttributeType(type);
    }

    public static final void checkAttlistDeclAttributeDefaultType(short defaultType) throws InvalidArgumentException {
        constraints.checkAttlistDeclAttributeDefaultType(defaultType);
    }

    public static final boolean isValidAttlistDeclAttributeDefaultType(short defaultType) {
        return constraints.isValidAttlistDeclAttributeDefaultType(defaultType);
    }

    public static final Collection getSupportedEncodings() {
        return EncodingUtil.getIANA2JavaMap().keySet();
    }

    public static final String iana2java(String iana) {
        String java = (String)EncodingUtil.getIANA2JavaMap().get(iana.toUpperCase());
        return java == null ? iana : java;
    }

    static class EncodingUtil {
        protected static final Map encodingIANA2JavaMap = new TreeMap();
        protected static final Map encodingIANADescriptionMap = new TreeMap();
        protected static final Map encodingIANAAliasesMap = new TreeMap();

        EncodingUtil() {
        }

        public static Map getIANA2JavaMap() {
            return encodingIANA2JavaMap;
        }

        static {
            encodingIANA2JavaMap.put("BIG5", "Big5");
            encodingIANADescriptionMap.put("BIG5", Util.THIS.getString("NAME_BIG5"));
            encodingIANAAliasesMap.put("BIG5", "BIG5");
            encodingIANA2JavaMap.put("IBM037", "CP037");
            encodingIANADescriptionMap.put("IBM037", Util.THIS.getString("NAME_IBM037"));
            encodingIANAAliasesMap.put("IBM037", "IBM037");
            encodingIANAAliasesMap.put("EBCDIC-CP-US", "IBM037");
            encodingIANAAliasesMap.put("EBCDIC-CP-CA", "IBM037");
            encodingIANAAliasesMap.put("EBCDIC-CP-NL", "IBM037");
            encodingIANAAliasesMap.put("EBCDIC-CP-WT", "IBM037");
            encodingIANA2JavaMap.put("IBM277", "CP277");
            encodingIANADescriptionMap.put("IBM277", Util.THIS.getString("NAME_IBM277"));
            encodingIANAAliasesMap.put("IBM277", "IBM277");
            encodingIANAAliasesMap.put("EBCDIC-CP-DK", "IBM277");
            encodingIANAAliasesMap.put("EBCDIC-CP-NO", "IBM277");
            encodingIANA2JavaMap.put("IBM278", "CP278");
            encodingIANADescriptionMap.put("IBM278", Util.THIS.getString("NAME_IBM277"));
            encodingIANAAliasesMap.put("IBM278", "IBM278");
            encodingIANAAliasesMap.put("EBCDIC-CP-FI", "IBM278");
            encodingIANAAliasesMap.put("EBCDIC-CP-SE", "IBM278");
            encodingIANA2JavaMap.put("IBM280", "CP280");
            encodingIANADescriptionMap.put("IBM280", Util.THIS.getString("NAME_IBM280"));
            encodingIANAAliasesMap.put("IBM280", "IBM280");
            encodingIANAAliasesMap.put("EBCDIC-CP-IT", "IBM280");
            encodingIANA2JavaMap.put("IBM284", "CP284");
            encodingIANADescriptionMap.put("IBM284", Util.THIS.getString("NAME_IBM284"));
            encodingIANAAliasesMap.put("IBM284", "IBM284");
            encodingIANAAliasesMap.put("EBCDIC-CP-ES", "IBM284");
            encodingIANA2JavaMap.put("IBM285", "CP285");
            encodingIANADescriptionMap.put("IBM285", Util.THIS.getString("NAME_IBM285"));
            encodingIANAAliasesMap.put("IBM285", "IBM285");
            encodingIANAAliasesMap.put("EBCDIC-CP-GB", "IBM285");
            encodingIANA2JavaMap.put("IBM297", "CP297");
            encodingIANADescriptionMap.put("IBM297", Util.THIS.getString("NAME_IBM297"));
            encodingIANAAliasesMap.put("IBM297", "IBM297");
            encodingIANAAliasesMap.put("EBCDIC-CP-FR", "IBM297");
            encodingIANA2JavaMap.put("IBM424", "CP424");
            encodingIANADescriptionMap.put("IBM424", Util.THIS.getString("NAME_IBM424"));
            encodingIANAAliasesMap.put("IBM424", "IBM424");
            encodingIANAAliasesMap.put("EBCDIC-CP-HE", "IBM424");
            encodingIANA2JavaMap.put("IBM500", "CP500");
            encodingIANADescriptionMap.put("IBM500", Util.THIS.getString("NAME_IBM500"));
            encodingIANAAliasesMap.put("IBM500", "IBM500");
            encodingIANAAliasesMap.put("EBCDIC-CP-CH", "IBM500");
            encodingIANAAliasesMap.put("EBCDIC-CP-BE", "IBM500");
            encodingIANA2JavaMap.put("IBM870", "CP870");
            encodingIANADescriptionMap.put("IBM870", Util.THIS.getString("NAME_IBM870"));
            encodingIANAAliasesMap.put("IBM870", "IBM870");
            encodingIANAAliasesMap.put("EBCDIC-CP-ROECE", "IBM870");
            encodingIANAAliasesMap.put("EBCDIC-CP-YU", "IBM870");
            encodingIANA2JavaMap.put("IBM871", "CP871");
            encodingIANADescriptionMap.put("IBM871", Util.THIS.getString("NAME_IBM871"));
            encodingIANAAliasesMap.put("IBM871", "IBM871");
            encodingIANAAliasesMap.put("EBCDIC-CP-IS", "IBM871");
            encodingIANA2JavaMap.put("IBM918", "CP918");
            encodingIANADescriptionMap.put("IBM918", Util.THIS.getString("NAME_IBM918"));
            encodingIANAAliasesMap.put("IBM918", "IBM918");
            encodingIANAAliasesMap.put("EBCDIC-CP-AR2", "IBM918");
            encodingIANA2JavaMap.put("EUC-JP", "EUCJIS");
            encodingIANADescriptionMap.put("EUC-JP", Util.THIS.getString("NAME_EUC-JP"));
            encodingIANAAliasesMap.put("EUC-JP", "EUC-JP");
            encodingIANA2JavaMap.put("EUC-KR", "KSC5601");
            encodingIANADescriptionMap.put("EUC-KR", Util.THIS.getString("NAME_EUC-KR"));
            encodingIANAAliasesMap.put("EUC-KR", "EUC-KR");
            encodingIANA2JavaMap.put("GB2312", "GB2312");
            encodingIANADescriptionMap.put("GB2312", Util.THIS.getString("NAME_GB2312"));
            encodingIANAAliasesMap.put("GB2312", "GB2312");
            encodingIANA2JavaMap.put("ISO-2022-JP", "JIS");
            encodingIANADescriptionMap.put("ISO-2022-JP", Util.THIS.getString("NAME_ISO-2022-JP"));
            encodingIANAAliasesMap.put("ISO-2022-JP", "ISO-2022-JP");
            encodingIANA2JavaMap.put("ISO-2022-KR", "ISO2022KR");
            encodingIANADescriptionMap.put("ISO-2022-KR", Util.THIS.getString("NAME_ISO-2022-KR"));
            encodingIANAAliasesMap.put("ISO-2022-KR", "ISO-2022-KR");
            encodingIANA2JavaMap.put("ISO-8859-1", "8859_1");
            encodingIANADescriptionMap.put("ISO-8859-1", Util.THIS.getString("NAME_ISO-8859-1"));
            encodingIANAAliasesMap.put("ISO-8859-1", "ISO-8859-1");
            encodingIANAAliasesMap.put("LATIN1", "ISO-8859-1");
            encodingIANAAliasesMap.put("L1", "ISO-8859-1");
            encodingIANAAliasesMap.put("IBM819", "ISO-8859-1");
            encodingIANAAliasesMap.put("CP819", "ISO-8859-1");
            encodingIANA2JavaMap.put("ISO-8859-2", "8859_2");
            encodingIANADescriptionMap.put("ISO-8859-2", Util.THIS.getString("NAME_ISO-8859-2"));
            encodingIANAAliasesMap.put("ISO-8859-2", "ISO-8859-2");
            encodingIANAAliasesMap.put("LATIN2", "ISO-8859-2");
            encodingIANAAliasesMap.put("L2", "ISO-8859-2");
            encodingIANA2JavaMap.put("ISO-8859-3", "8859_3");
            encodingIANADescriptionMap.put("ISO-8859-3", Util.THIS.getString("NAME_ISO-8859-3"));
            encodingIANAAliasesMap.put("ISO-8859-3", "ISO-8859-3");
            encodingIANAAliasesMap.put("LATIN3", "ISO-8859-3");
            encodingIANAAliasesMap.put("L3", "ISO-8859-3");
            encodingIANA2JavaMap.put("ISO-8859-4", "8859_4");
            encodingIANADescriptionMap.put("ISO-8859-4", Util.THIS.getString("NAME_ISO-8859-4"));
            encodingIANAAliasesMap.put("ISO-8859-4", "ISO-8859-4");
            encodingIANAAliasesMap.put("LATIN4", "ISO-8859-4");
            encodingIANAAliasesMap.put("L4", "ISO-8859-4");
            encodingIANA2JavaMap.put("ISO-8859-5", "8859_5");
            encodingIANADescriptionMap.put("ISO-8859-5", Util.THIS.getString("NAME_ISO-8859-5"));
            encodingIANAAliasesMap.put("ISO-8859-5", "ISO-8859-5");
            encodingIANAAliasesMap.put("CYRILLIC", "ISO-8859-5");
            encodingIANA2JavaMap.put("ISO-8859-6", "8859_6");
            encodingIANADescriptionMap.put("ISO-8859-6", Util.THIS.getString("NAME_ISO-8859-6"));
            encodingIANAAliasesMap.put("ISO-8859-6", "ISO-8859-6");
            encodingIANA2JavaMap.put("ISO-8859-7", "8859_7");
            encodingIANADescriptionMap.put("ISO-8859-7", Util.THIS.getString("NAME_ISO-8859-7"));
            encodingIANAAliasesMap.put("ISO-8859-7", "ISO-8859-7");
            encodingIANAAliasesMap.put("GREEK", "ISO-8859-7");
            encodingIANAAliasesMap.put("GREEK8", "ISO-8859-7");
            encodingIANA2JavaMap.put("ISO-8859-8", "8859_8");
            encodingIANADescriptionMap.put("ISO-8859-8", Util.THIS.getString("NAME_ISO-8859-8"));
            encodingIANAAliasesMap.put("ISO-8859-8", "ISO-8859-8");
            encodingIANAAliasesMap.put("HEBREW", "ISO-8859-8");
            encodingIANA2JavaMap.put("ISO-8859-9", "8859_9");
            encodingIANADescriptionMap.put("ISO-8859-9", Util.THIS.getString("NAME_ISO-8859-9"));
            encodingIANAAliasesMap.put("ISO-8859-9", "ISO-8859-9");
            encodingIANAAliasesMap.put("LATIN5", "ISO-8859-9");
            encodingIANAAliasesMap.put("L5", "ISO-8859-9");
            encodingIANA2JavaMap.put("KOI8-R", "KOI8_R");
            encodingIANADescriptionMap.put("KOI8-R", Util.THIS.getString("NAME_KOI8-R"));
            encodingIANAAliasesMap.put("KOI8-R", "KOI8-R");
            encodingIANA2JavaMap.put("US-ASCII", "8859_1");
            encodingIANADescriptionMap.put("US-ASCII", Util.THIS.getString("NAME_ASCII"));
            encodingIANAAliasesMap.put("ASCII", "US-ASCII");
            encodingIANAAliasesMap.put("US-ASCII", "US-ASCII");
            encodingIANAAliasesMap.put("ISO646-US", "US-ASCII");
            encodingIANAAliasesMap.put("IBM367", "US-ASCII");
            encodingIANAAliasesMap.put("CP367", "US-ASCII");
            encodingIANA2JavaMap.put("UTF-8", "UTF8");
            encodingIANADescriptionMap.put("UTF-8", Util.THIS.getString("NAME_UTF-8"));
            encodingIANAAliasesMap.put("UTF-8", "UTF-8");
            encodingIANA2JavaMap.put("UTF-16", "Unicode");
            encodingIANADescriptionMap.put("UTF-16", Util.THIS.getString("NAME_UTF-16"));
            encodingIANAAliasesMap.put("UTF-16", "UTF-16");
        }
    }

    private static final class Constraints
    extends UnicodeClasses
    implements AttlistDecl.Constraints,
    Attribute.Constraints,
    CDATASection.Constraints,
    CharacterReference.Constraints,
    Comment.Constraints,
    ConditionalSection.Constraints,
    DocumentFragment.Constraints,
    Document.Constraints,
    DocumentType.Constraints,
    DTD.Constraints,
    ElementDecl.Constraints,
    Element.Constraints,
    EntityDecl.Constraints,
    GeneralEntityReference.Constraints,
    NotationDecl.Constraints,
    ParameterEntityReference.Constraints,
    ProcessingInstruction.Constraints,
    Text.Constraints {
        private Constraints() {
        }

        private static void checkNullArgument(String argName, Object argValue) throws InvalidArgumentException {
            if (argValue == null) {
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("PROP_invalid_null_value"));
            }
        }

        private static void checkEmptyString(String argName, String string, boolean trim) throws InvalidArgumentException {
            if (string.length() == 0 || trim && string.trim().equals("")) {
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("PROP_invalid_empty_value"));
            }
        }

        private static void checkXMLName(String argName, String name) throws InvalidArgumentException {
            Constraints.checkNullArgument(argName, name);
            Constraints.checkEmptyString(argName, name, true);
            char first = name.charAt(0);
            if (!Constraints.isXMLNameStartChar(first)) {
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("PROP_invalid_first_char", String.valueOf(first)));
            }
            int len = name.length();
            for (int i = 0; i < len; ++i) {
                char c = name.charAt(i);
                if (Constraints.isXMLNameChar(c)) continue;
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("PROP_invalid_content_char", String.valueOf(c)));
            }
        }

        private static void checkNmToken(String argName, String token) throws InvalidArgumentException {
            Constraints.checkNullArgument(argName, token);
            Constraints.checkEmptyString(argName, token, true);
            int len = token.length();
            for (int i = 0; i < len; ++i) {
                char c = token.charAt(i);
                if (Constraints.isXMLNameChar(c)) continue;
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("PROP_invalid_content_char", String.valueOf(c)));
            }
        }

        private static void checkXMLNCName(String argName, String name) throws InvalidArgumentException {
            Constraints.checkNullArgument(argName, name);
            Constraints.checkEmptyString(argName, name, true);
            char first = name.charAt(0);
            if (!Constraints.isXMLNCNameStartChar(first)) {
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("PROP_invalid_first_char", String.valueOf(first)));
            }
            int len = name.length();
            for (int i = 0; i < len; ++i) {
                char c = name.charAt(i);
                if (Constraints.isXMLNCNameChar(c)) continue;
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("PROP_invalid_content_char", String.valueOf(c)));
            }
        }

        private static void checkNamespacePrefix(String prefix) throws InvalidArgumentException {
            String argName = Util.THIS.getString("PROP_NamespacePrefix");
            Constraints.checkXMLNCName(argName, prefix);
        }

        private static void checkNamespaceURI(String uri) throws InvalidArgumentException {
            String argName = Util.THIS.getString("PROP_NamespaceURI");
            Constraints.checkAttributeValue(argName, uri);
        }

        private static void checkElementName(String argName, String name) throws InvalidArgumentException {
            Constraints.checkNullArgument(argName, name);
            Constraints.checkXMLName(argName, name);
        }

        private static void checkAttributeName(String argName, String name) throws InvalidArgumentException {
            Constraints.checkNullArgument(argName, name);
            Constraints.checkXMLName(argName, name);
        }

        private static void checkAttributeValue(String argName, String value) throws InvalidArgumentException {
            Constraints.checkNullArgument(argName, value);
            Constraints.checkCharacterData(argName, value);
            int index = value.indexOf(60);
            if (index != -1) {
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("EXC_invalid_attribute_value", value));
            }
            index = value.indexOf(38);
            if (index != -1) {
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("EXC_invalid_attribute_value", value));
            }
            boolean apostrofFound = false;
            boolean quoteFound = false;
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c == '\'') {
                    if (quoteFound) {
                        throw new InvalidArgumentException((Object)argName, Util.THIS.getString("EXC_invalid_attribute_value", value));
                    }
                    apostrofFound = true;
                }
                if (c != '\"') continue;
                if (apostrofFound) {
                    throw new InvalidArgumentException((Object)argName, Util.THIS.getString("EXC_invalid_attribute_value", value));
                }
                quoteFound = true;
            }
        }

        private static void checkCharacterData(String argName, String text) throws InvalidArgumentException {
            Constraints.checkNullArgument(argName, text);
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                char c = text.charAt(i);
                if (Constraints.isXMLChar(c)) continue;
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("PROP_invalid_content_char", "0x" + Integer.toHexString(c)));
            }
        }

        private static void checkSystemId(String argName, String systemId) throws InvalidArgumentException {
            boolean apostrofFound = false;
            boolean quoteFound = false;
            int len = systemId.length();
            for (int i = 0; i < len; ++i) {
                char c = systemId.charAt(i);
                if (c == '\'') {
                    if (quoteFound) {
                        throw new InvalidArgumentException((Object)argName, Util.THIS.getString("EXC_Invalid_system_id", systemId));
                    }
                    apostrofFound = true;
                }
                if (c != '\"') continue;
                if (apostrofFound) {
                    throw new InvalidArgumentException((Object)argName, Util.THIS.getString("EXC_Invalid_system_id", systemId));
                }
                quoteFound = true;
            }
        }

        private static void checkPublicId(String argName, String publicId) throws InvalidArgumentException {
            boolean apostrofFound = false;
            boolean quoteFound = false;
            int len = publicId.length();
            for (int i = 0; i < len; ++i) {
                char c = publicId.charAt(i);
                if (c == '\'') {
                    if (quoteFound) {
                        throw new InvalidArgumentException((Object)argName, Util.THIS.getString("EXC_Invalid_public_id", publicId));
                    }
                    apostrofFound = true;
                    continue;
                }
                if (c == '\"') {
                    if (apostrofFound) {
                        throw new InvalidArgumentException((Object)argName, Util.THIS.getString("EXC_Invalid_public_id", publicId));
                    }
                    quoteFound = true;
                    continue;
                }
                if (Constraints.isXMLPubidLiteral(c)) continue;
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("EXC_Invalid_public_id", publicId));
            }
        }

        private static void checkNotationName(String argName, String name) throws InvalidArgumentException {
            Constraints.checkNullArgument(argName, name);
            Constraints.checkXMLName(argName, name);
        }

        private static void checkEncoding(String argName, String encoding) throws InvalidArgumentException {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TreeUtilities::checkEncoding: encoding = " + encoding);
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("      ::checkEncoding: stream = " + stream);
            }
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)stream, TreeUtilities.iana2java(encoding));
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("      ::checkEncoding: reader = " + reader);
                }
            }
            catch (IOException exc) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("      ::checkEncoding: IOException !!!", exc);
                }
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("EXC_Invalid_encoding", encoding));
            }
        }

        @Override
        public void checkAttributeName(TreeName treeName) throws InvalidArgumentException {
            String argName = Util.THIS.getString("PROP_AttributeName");
            Constraints.checkAttributeName(argName, treeName.getQualifiedName());
        }

        @Override
        public boolean isValidAttributeName(TreeName treeName) {
            try {
                this.checkAttributeName(treeName);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkElementTagName(TreeName elementTreeName) throws InvalidArgumentException {
            Constraints.checkElementName(Util.THIS.getString("PROP_ElementTagName"), elementTreeName.getQualifiedName());
        }

        @Override
        public boolean isValidElementTagName(TreeName elementTreeName) {
            try {
                this.checkElementTagName(elementTreeName);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkNotationDeclSystemId(String systemId) throws InvalidArgumentException {
            if (systemId == null) {
                return;
            }
            Constraints.checkSystemId(Util.THIS.getString("PROP_NotationDeclSystemId"), systemId);
        }

        @Override
        public boolean isValidNotationDeclSystemId(String systemId) {
            try {
                this.checkNotationDeclSystemId(systemId);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkDocumentEncoding(String encoding) throws InvalidArgumentException {
            if (encoding == null) {
                return;
            }
            Constraints.checkEncoding(Util.THIS.getString("PROP_DocumentEncoding"), encoding);
        }

        @Override
        public boolean isValidDocumentEncoding(String encoding) {
            try {
                this.checkDocumentEncoding(encoding);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkDTDEncoding(String encoding) throws InvalidArgumentException {
            if (encoding == null) {
                return;
            }
            Constraints.checkEncoding(Util.THIS.getString("PROP_DTDEncoding"), encoding);
        }

        @Override
        public boolean isValidDTDEncoding(String encoding) {
            try {
                this.checkDTDEncoding(encoding);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkCharacterReferenceName(String name) throws InvalidArgumentException {
            String argName = Util.THIS.getString("PROP_CharacterReferenceName");
            Constraints.checkNullArgument(argName, name);
            Constraints.checkEmptyString(argName, name, true);
            int i = 0;
            char first = name.charAt(i);
            if (first != '#') {
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("PROP_invalid_first_char", String.valueOf(first)));
            }
            if (name.length() <= ++i) {
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("PROP_invalid_empty_value"));
            }
            char second = name.charAt(i);
            int radix = 10;
            if (second == 'x') {
                radix = 16;
                if (name.length() <= ++i) {
                    throw new InvalidArgumentException((Object)argName, Util.THIS.getString("PROP_invalid_empty_value"));
                }
            }
            String number = name.substring(i);
            try {
                Short.parseShort(number, radix);
            }
            catch (NumberFormatException exc) {
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("PROP_invalid_content_char", number));
            }
        }

        @Override
        public boolean isValidCharacterReferenceName(String name) {
            try {
                this.checkCharacterReferenceName(name);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkEntityDeclInternalText(String internalText) throws InvalidArgumentException {
            Constraints.checkNullArgument(Util.THIS.getString("PROP_EntityDeclInternalText"), internalText);
            boolean apostrofFound = false;
            boolean quoteFound = false;
            int len = internalText.length();
            for (int i = 0; i < len; ++i) {
                char c = internalText.charAt(i);
                if (c == '\'') {
                    if (quoteFound) {
                        throw new InvalidArgumentException((Object)Util.THIS.getString("PROP_EntityDeclInternalText"), Util.THIS.getString("EXC_Invalid_Entity_Decl_Internal_text", internalText));
                    }
                    apostrofFound = true;
                }
                if (c != '\"') continue;
                if (apostrofFound) {
                    throw new InvalidArgumentException((Object)Util.THIS.getString("PROP_EntityDeclInternalText"), Util.THIS.getString("EXC_Invalid_Entity_Decl_Internal_text", internalText));
                }
                quoteFound = true;
            }
        }

        @Override
        public boolean isValidEntityDeclInternalText(String internalText) {
            try {
                this.checkEntityDeclInternalText(internalText);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkAttlistDeclElementName(String elementName) throws InvalidArgumentException {
            Constraints.checkElementName(Util.THIS.getString("PROP_AttlistDeclElementName"), elementName);
        }

        @Override
        public boolean isValidAttlistDeclElementName(String elementName) {
            try {
                this.checkAttlistDeclElementName(elementName);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkDTDVersion(String version) throws InvalidArgumentException {
            if (version == null) {
                return;
            }
            if (!version.equals("1.0")) {
                String arg = Util.THIS.getString("PROP_DTDVersion");
                String msg = Util.THIS.getString("PROP_invalid_version_number", version);
                throw new InvalidArgumentException((Object)arg, msg);
            }
        }

        @Override
        public boolean isValidDTDVersion(String version) {
            try {
                this.checkDTDVersion(version);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkDocumentTypeSystemId(String systemId) throws InvalidArgumentException {
            if (systemId == null) {
                return;
            }
            Constraints.checkSystemId(Util.THIS.getString("PROP_DocumentTypeSystemId"), systemId);
        }

        @Override
        public boolean isValidDocumentTypeSystemId(String systemId) {
            try {
                this.checkDocumentTypeSystemId(systemId);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkDocumentTypeElementName(String elementName) throws InvalidArgumentException {
            Constraints.checkElementName(Util.THIS.getString("PROP_DocumentTypeElementName"), elementName);
        }

        @Override
        public boolean isValidDocumentTypeElementName(String elementName) {
            try {
                this.checkDocumentTypeElementName(elementName);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkDocumentStandalone(String standalone) throws InvalidArgumentException {
            if (standalone == null) {
                return;
            }
            if (standalone.equals("yes")) {
                return;
            }
            if (standalone.equals("no")) {
                return;
            }
            throw new InvalidArgumentException((Object)standalone, standalone + Util.THIS.getString("PROP_is_not_valid_standalone_value"));
        }

        @Override
        public boolean isValidDocumentStandalone(String standalone) {
            try {
                this.checkDocumentStandalone(standalone);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkEntityDeclName(String name) throws InvalidArgumentException {
            Constraints.checkXMLName(Util.THIS.getString("PROP_EntityDeclName"), name);
        }

        @Override
        public boolean isValidEntityDeclName(String name) {
            try {
                this.checkEntityDeclName(name);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkAttlistDeclAttributeEnumeratedType(String[] enumeratedType) throws InvalidArgumentException {
            if (enumeratedType == null) {
                return;
            }
            int len = enumeratedType.length;
            for (int i = 0; i < len; ++i) {
                Constraints.checkNmToken(Util.THIS.getString("PROP_AttlistDeclAttributeEnumeratedType"), enumeratedType[i]);
            }
        }

        @Override
        public boolean isValidAttlistDeclAttributeEnumeratedType(String[] enumeratedType) {
            try {
                this.checkAttlistDeclAttributeEnumeratedType(enumeratedType);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkProcessingInstructionData(String data) throws InvalidArgumentException {
            Constraints.checkCharacterData(Util.THIS.getString("PROP_ProcessingInstructionData"), data);
            int index = data.indexOf("?>");
            if (index != -1) {
                throw new InvalidArgumentException((Object)data, Util.THIS.getString("PROP_invalid_processing_instruction_data"));
            }
        }

        @Override
        public boolean isValidProcessingInstructionData(String data) {
            try {
                this.checkProcessingInstructionData(data);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkEntityDeclNotationName(String notationName) throws InvalidArgumentException {
            if (notationName == null) {
                return;
            }
            Constraints.checkNotationName(Util.THIS.getString("PROP_EntityDeclNotationName"), notationName);
        }

        @Override
        public boolean isValidEntityDeclNotationName(String notationName) {
            try {
                this.checkEntityDeclNotationName(notationName);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkElementDeclName(String name) throws InvalidArgumentException {
            Constraints.checkElementName(Util.THIS.getString("PROP_ElementDeclName"), name);
        }

        @Override
        public boolean isValidElementDeclName(String name) {
            try {
                this.checkElementDeclName(name);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkGeneralEntityReferenceName(String name) throws InvalidArgumentException {
            Constraints.checkXMLName(Util.THIS.getString("PROP_GeneralEntityReferenceName"), name);
        }

        @Override
        public boolean isValidGeneralEntityReferenceName(String name) {
            try {
                this.checkGeneralEntityReferenceName(name);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkEntityDeclSystemId(String systemId) throws InvalidArgumentException {
            if (systemId == null) {
                return;
            }
            Constraints.checkSystemId(Util.THIS.getString("PROP_EntityDeclSystemId"), systemId);
        }

        @Override
        public boolean isValidEntityDeclSystemId(String systemId) {
            try {
                this.checkEntityDeclSystemId(systemId);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkProcessingInstructionTarget(String target) throws InvalidArgumentException {
            String argName = Util.THIS.getString("PROP_ProcessingInstructionTarget");
            Constraints.checkXMLName(argName, target);
            if (target.equalsIgnoreCase("xml")) {
                throw new InvalidArgumentException((Object)argName, Util.THIS.getString("PROP_invalid_content_char", target));
            }
        }

        @Override
        public boolean isValidProcessingInstructionTarget(String target) {
            try {
                this.checkProcessingInstructionTarget(target);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkEntityDeclPublicId(String publicId) throws InvalidArgumentException {
            if (publicId == null) {
                return;
            }
            Constraints.checkPublicId(Util.THIS.getString("PROP_EntityDeclPublicId"), publicId);
        }

        @Override
        public boolean isValidEntityDeclPublicId(String publicId) {
            try {
                this.checkEntityDeclPublicId(publicId);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkAttlistDeclAttributeDefaultValue(String defaultValue) throws InvalidArgumentException {
            if (defaultValue == null) {
                return;
            }
            boolean apostrofFound = false;
            boolean quoteFound = false;
            int len = defaultValue.length();
            for (int i = 0; i < len; ++i) {
                char c = defaultValue.charAt(i);
                if (c == '\'') {
                    if (quoteFound) {
                        throw new InvalidArgumentException((Object)Util.THIS.getString("PROP_AttlistDeclAttributeDefaultValue"), Util.THIS.getString("EXC_invalid_attribute_default_value", defaultValue));
                    }
                    apostrofFound = true;
                }
                if (c != '\"') continue;
                if (apostrofFound) {
                    throw new InvalidArgumentException((Object)Util.THIS.getString("PROP_AttlistDeclAttributeDefaultValue"), Util.THIS.getString("EXC_invalid_attribute_default_value", defaultValue));
                }
                quoteFound = true;
            }
        }

        @Override
        public boolean isValidAttlistDeclAttributeDefaultValue(String defaultValue) {
            try {
                this.checkAttlistDeclAttributeDefaultValue(defaultValue);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkDocumentFragmentVersion(String version) throws InvalidArgumentException {
            if (version == null) {
                return;
            }
            if (!version.equals("1.0")) {
                String arg = Util.THIS.getString("PROP_DocumentFragmentVersion");
                String msg = Util.THIS.getString("PROP_invalid_version_number", version);
                throw new InvalidArgumentException((Object)arg, msg);
            }
        }

        @Override
        public boolean isValidDocumentFragmentVersion(String version) {
            try {
                this.checkDocumentFragmentVersion(version);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkNotationDeclName(String name) throws InvalidArgumentException {
            Constraints.checkXMLName(Util.THIS.getString("PROP_NotationDeclName"), name);
        }

        @Override
        public boolean isValidNotationDeclName(String name) {
            try {
                this.checkNotationDeclName(name);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkAttributeValue(String value) throws InvalidArgumentException {
            String argName = Util.THIS.getString("PROP_AttributeValue");
            Constraints.checkAttributeValue(argName, value);
        }

        @Override
        public boolean isValidAttributeValue(String value) {
            try {
                this.checkAttributeValue(value);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkParameterEntityReferenceName(String name) throws InvalidArgumentException {
            Constraints.checkXMLName(Util.THIS.getString("PROP_ParameterEntityReferenceName"), name);
        }

        @Override
        public boolean isValidParameterEntityReferenceName(String name) {
            try {
                this.checkParameterEntityReferenceName(name);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkDocumentFragmentEncoding(String encoding) throws InvalidArgumentException {
            if (encoding == null) {
                return;
            }
            Constraints.checkEncoding(Util.THIS.getString("PROP_DocumentFragmentEncoding"), encoding);
        }

        @Override
        public boolean isValidDocumentFragmentEncoding(String encoding) {
            try {
                this.checkDocumentFragmentEncoding(encoding);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkTextData(String data) throws InvalidArgumentException {
            String argName = Util.THIS.getString("PROP_TextData");
            Constraints.checkCharacterData(argName, data);
            Constraints.checkEmptyString(argName, data, false);
            int index = data.indexOf(60);
            if (index != -1) {
                throw new InvalidArgumentException((Object)data, Util.THIS.getString("PROP_invalid_text_data"));
            }
            index = data.indexOf(38);
            if (index != -1) {
                throw new InvalidArgumentException((Object)data, Util.THIS.getString("PROP_invalid_text_data"));
            }
            index = data.indexOf("]]>");
            if (index != -1) {
                throw new InvalidArgumentException((Object)data, Util.THIS.getString("PROP_invalid_text_data"));
            }
        }

        @Override
        public boolean isValidTextData(String data) {
            try {
                this.checkTextData(data);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkDocumentTypePublicId(String publicId) throws InvalidArgumentException {
            if (publicId == null) {
                return;
            }
            Constraints.checkPublicId(Util.THIS.getString("PROP_DocumentTypePublicId"), publicId);
        }

        @Override
        public boolean isValidDocumentTypePublicId(String publicId) {
            try {
                this.checkDocumentTypePublicId(publicId);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkElementDeclContentType(TreeElementDecl.ContentType contentType) throws InvalidArgumentException {
            Constraints.checkNullArgument(Util.THIS.getString("PROP_ElementDeclContentType"), contentType);
        }

        @Override
        public boolean isValidElementDeclContentType(TreeElementDecl.ContentType contentType) {
            try {
                this.checkElementDeclContentType(contentType);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkDocumentVersion(String version) throws InvalidArgumentException {
            if (version == null) {
                return;
            }
            if (!version.equals("1.0")) {
                String arg = Util.THIS.getString("PROP_DocumentVersion");
                String msg = Util.THIS.getString("PROP_invalid_version_number", version);
                throw new InvalidArgumentException((Object)arg, msg);
            }
        }

        @Override
        public boolean isValidDocumentVersion(String version) {
            try {
                this.checkDocumentVersion(version);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkCDATASectionData(String data) throws InvalidArgumentException {
            Constraints.checkCharacterData(Util.THIS.getString("PROP_CDATASectionData"), data);
            int index = data.indexOf("]]>");
            if (index != -1) {
                throw new InvalidArgumentException((Object)data, Util.THIS.getString("PROP_invalid_cdata_section_data"));
            }
        }

        @Override
        public boolean isValidCDATASectionData(String data) {
            try {
                this.checkCDATASectionData(data);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkNotationDeclPublicId(String publicId) throws InvalidArgumentException {
            if (publicId == null) {
                return;
            }
            Constraints.checkPublicId(Util.THIS.getString("PROP_NotationDeclPublicId"), publicId);
        }

        @Override
        public boolean isValidNotationDeclPublicId(String publicId) {
            try {
                this.checkNotationDeclPublicId(publicId);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkAttlistDeclAttributeName(String attributeName) throws InvalidArgumentException {
            Constraints.checkAttributeName(Util.THIS.getString("PROP_AttlistDeclAttributeName"), attributeName);
        }

        @Override
        public boolean isValidAttlistDeclAttributeName(String attributeName) {
            try {
                this.checkAttlistDeclAttributeName(attributeName);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkCommentData(String data) throws InvalidArgumentException {
            Constraints.checkCharacterData(Util.THIS.getString("PROP_CommentData"), data);
            int index = data.indexOf("--");
            if (index != -1) {
                throw new InvalidArgumentException((Object)data, Util.THIS.getString("PROP_invalid_comment_data"));
            }
            if (data.endsWith("-")) {
                throw new InvalidArgumentException((Object)data, Util.THIS.getString("PROP_invalid_comment_data_end"));
            }
        }

        @Override
        public boolean isValidCommentData(String data) {
            try {
                this.checkCommentData(data);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkAttlistDeclAttributeType(short type) throws InvalidArgumentException {
            if (type != 0 && type != 1 && type != 2 && type != 3 && type != 4 && type != 5 && type != 6 && type != 7 && type != 8 && type != 9) {
                throw new InvalidArgumentException(type, Util.THIS.getString("PROP_invalid_attribute_list_declaration_type"));
            }
        }

        @Override
        public boolean isValidAttlistDeclAttributeType(short type) {
            try {
                this.checkAttlistDeclAttributeType(type);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }

        @Override
        public void checkAttlistDeclAttributeDefaultType(short defaultType) throws InvalidArgumentException {
            if (defaultType != 0 && defaultType != 1 && defaultType != 2 && defaultType != 3) {
                throw new InvalidArgumentException(defaultType, Util.THIS.getString("PROP_invalid_attribute_list_declaration_default_type"));
            }
        }

        @Override
        public boolean isValidAttlistDeclAttributeDefaultType(short defaultType) {
            try {
                this.checkAttlistDeclAttributeDefaultType(defaultType);
            }
            catch (InvalidArgumentException exc) {
                return false;
            }
            return true;
        }
    }
}

