/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.MigrateVaultKeyDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class MigrateVaultKeyRequest
extends BmcRequest<MigrateVaultKeyDetails> {
    private String databaseId;
    private MigrateVaultKeyDetails migrateVaultKeyDetails;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public MigrateVaultKeyDetails getMigrateVaultKeyDetails() {
        return this.migrateVaultKeyDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public MigrateVaultKeyDetails getBody$() {
        return this.migrateVaultKeyDetails;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).migrateVaultKeyDetails(this.migrateVaultKeyDetails).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",migrateVaultKeyDetails=").append(String.valueOf((Object)this.migrateVaultKeyDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MigrateVaultKeyRequest)) {
            return false;
        }
        MigrateVaultKeyRequest other = (MigrateVaultKeyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals((Object)this.migrateVaultKeyDetails, (Object)other.migrateVaultKeyDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.migrateVaultKeyDetails == null ? 43 : this.migrateVaultKeyDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<MigrateVaultKeyRequest, MigrateVaultKeyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private MigrateVaultKeyDetails migrateVaultKeyDetails = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder migrateVaultKeyDetails(MigrateVaultKeyDetails migrateVaultKeyDetails) {
            this.migrateVaultKeyDetails = migrateVaultKeyDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(MigrateVaultKeyRequest o) {
            this.databaseId(o.getDatabaseId());
            this.migrateVaultKeyDetails(o.getMigrateVaultKeyDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public MigrateVaultKeyRequest build() {
            MigrateVaultKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(MigrateVaultKeyDetails body) {
            this.migrateVaultKeyDetails(body);
            return this;
        }

        public MigrateVaultKeyRequest buildWithoutInvocationCallback() {
            MigrateVaultKeyRequest request = new MigrateVaultKeyRequest();
            request.databaseId = this.databaseId;
            request.migrateVaultKeyDetails = this.migrateVaultKeyDetails;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

