/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseTool
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final Name name;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="computeCount")
    private final Float computeCount;
    @JsonProperty(value="maxIdleTimeInMinutes")
    private final Integer maxIdleTimeInMinutes;

    @Deprecated
    @ConstructorProperties(value={"name", "isEnabled", "computeCount", "maxIdleTimeInMinutes"})
    public DatabaseTool(Name name, Boolean isEnabled, Float computeCount, Integer maxIdleTimeInMinutes) {
        this.name = name;
        this.isEnabled = isEnabled;
        this.computeCount = computeCount;
        this.maxIdleTimeInMinutes = maxIdleTimeInMinutes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Name getName() {
        return this.name;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Float getComputeCount() {
        return this.computeCount;
    }

    public Integer getMaxIdleTimeInMinutes() {
        return this.maxIdleTimeInMinutes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseTool(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf((Object)this.name));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", computeCount=").append(String.valueOf(this.computeCount));
        sb.append(", maxIdleTimeInMinutes=").append(String.valueOf(this.maxIdleTimeInMinutes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseTool)) {
            return false;
        }
        DatabaseTool other = (DatabaseTool)((Object)o);
        return Objects.equals((Object)this.name, (Object)other.name) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.computeCount, other.computeCount) && Objects.equals(this.maxIdleTimeInMinutes, other.maxIdleTimeInMinutes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.computeCount == null ? 43 : this.computeCount.hashCode());
        result = result * 59 + (this.maxIdleTimeInMinutes == null ? 43 : this.maxIdleTimeInMinutes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Name implements BmcEnum
    {
        Apex("APEX"),
        DatabaseActions("DATABASE_ACTIONS"),
        GraphStudio("GRAPH_STUDIO"),
        Oml("OML"),
        DataTransforms("DATA_TRANSFORMS"),
        Ords("ORDS"),
        MongodbApi("MONGODB_API"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Name> map;

        private Name(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Name create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Name', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Name.class);
            map = new HashMap<String, Name>();
            for (Name v : Name.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private Name name;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="computeCount")
        private Float computeCount;
        @JsonProperty(value="maxIdleTimeInMinutes")
        private Integer maxIdleTimeInMinutes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(Name name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder computeCount(Float computeCount) {
            this.computeCount = computeCount;
            this.__explicitlySet__.add("computeCount");
            return this;
        }

        public Builder maxIdleTimeInMinutes(Integer maxIdleTimeInMinutes) {
            this.maxIdleTimeInMinutes = maxIdleTimeInMinutes;
            this.__explicitlySet__.add("maxIdleTimeInMinutes");
            return this;
        }

        public DatabaseTool build() {
            DatabaseTool model = new DatabaseTool(this.name, this.isEnabled, this.computeCount, this.maxIdleTimeInMinutes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseTool model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("computeCount")) {
                this.computeCount(model.getComputeCount());
            }
            if (model.wasPropertyExplicitlySet("maxIdleTimeInMinutes")) {
                this.maxIdleTimeInMinutes(model.getMaxIdleTimeInMinutes());
            }
            return this;
        }
    }
}

