/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CloudDatabaseManagementConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="managementStatus")
    private final ManagementStatus managementStatus;
    @JsonProperty(value="managementType")
    private final ManagementType managementType;

    @Deprecated
    @ConstructorProperties(value={"managementStatus", "managementType"})
    public CloudDatabaseManagementConfig(ManagementStatus managementStatus, ManagementType managementType) {
        this.managementStatus = managementStatus;
        this.managementType = managementType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ManagementStatus getManagementStatus() {
        return this.managementStatus;
    }

    public ManagementType getManagementType() {
        return this.managementType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CloudDatabaseManagementConfig(");
        sb.append("super=").append(super.toString());
        sb.append("managementStatus=").append(String.valueOf((Object)this.managementStatus));
        sb.append(", managementType=").append(String.valueOf((Object)this.managementType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CloudDatabaseManagementConfig)) {
            return false;
        }
        CloudDatabaseManagementConfig other = (CloudDatabaseManagementConfig)((Object)o);
        return Objects.equals((Object)this.managementStatus, (Object)other.managementStatus) && Objects.equals((Object)this.managementType, (Object)other.managementType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.managementStatus == null ? 43 : this.managementStatus.hashCode());
        result = result * 59 + (this.managementType == null ? 43 : this.managementType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ManagementType implements BmcEnum
    {
        Basic("BASIC"),
        Advanced("ADVANCED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ManagementType> map;

        private ManagementType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ManagementType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ManagementType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ManagementType.class);
            map = new HashMap<String, ManagementType>();
            for (ManagementType v : ManagementType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ManagementStatus implements BmcEnum
    {
        Enabling("ENABLING"),
        Enabled("ENABLED"),
        Disabling("DISABLING"),
        Disabled("DISABLED"),
        Updating("UPDATING"),
        FailedEnabling("FAILED_ENABLING"),
        FailedDisabling("FAILED_DISABLING"),
        FailedUpdating("FAILED_UPDATING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ManagementStatus> map;

        private ManagementStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ManagementStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ManagementStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ManagementStatus.class);
            map = new HashMap<String, ManagementStatus>();
            for (ManagementStatus v : ManagementStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="managementStatus")
        private ManagementStatus managementStatus;
        @JsonProperty(value="managementType")
        private ManagementType managementType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder managementStatus(ManagementStatus managementStatus) {
            this.managementStatus = managementStatus;
            this.__explicitlySet__.add("managementStatus");
            return this;
        }

        public Builder managementType(ManagementType managementType) {
            this.managementType = managementType;
            this.__explicitlySet__.add("managementType");
            return this;
        }

        public CloudDatabaseManagementConfig build() {
            CloudDatabaseManagementConfig model = new CloudDatabaseManagementConfig(this.managementStatus, this.managementType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CloudDatabaseManagementConfig model) {
            if (model.wasPropertyExplicitlySet("managementStatus")) {
                this.managementStatus(model.getManagementStatus());
            }
            if (model.wasPropertyExplicitlySet("managementType")) {
                this.managementType(model.getManagementType());
            }
            return this;
        }
    }
}

