/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.menus;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.drivers.DescriptablePathChooser;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.netbeans.jemmy.drivers.MenuDriver;
import org.netbeans.jemmy.drivers.PathChooser;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JMenuBarOperator;
import org.netbeans.jemmy.operators.JMenuItemOperator;
import org.netbeans.jemmy.operators.JMenuOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;

public class QueueJMenuDriver
extends LightSupportiveDriver
implements MenuDriver {
    QueueTool queueTool = new QueueTool();

    public QueueJMenuDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.JMenuOperator", "org.netbeans.jemmy.operators.JMenuBarOperator", "org.netbeans.jemmy.operators.JPopupMenuOperator"});
    }

    @Override
    public Object pushMenu(final ComponentOperator oper, PathChooser chooser) {
        JMenuItem result;
        OneReleaseAction action;
        this.queueTool.setOutput(oper.getOutput().createErrorOutput());
        this.checkSupported(oper);
        if (oper instanceof JMenuBarOperator) {
            action = new OneReleaseAction(chooser, 0, oper, false){

                @Override
                protected void pushAlone(JMenuItemOperator subMenuOper) {
                    if (subMenuOper.getSource() instanceof JMenu && QueueJMenuDriver.this.isMenuBarSelected((JMenuBar)oper.getSource())) {
                        DriverManager.getMouseDriver(subMenuOper).enterMouse(subMenuOper);
                    } else {
                        DriverManager.getButtonDriver(subMenuOper).push(subMenuOper);
                    }
                }

                @Override
                protected boolean inTheMiddle(JMenuOperator subMenuOper, boolean mousePressed) {
                    if (QueueJMenuDriver.this.isMenuBarSelected((JMenuBar)oper.getSource())) {
                        DriverManager.getMouseDriver(subMenuOper).enterMouse(subMenuOper);
                        return false;
                    }
                    return super.inTheMiddle(subMenuOper, mousePressed);
                }

                @Override
                protected void process(MenuElement element) {
                    super.process(element);
                }

                @Override
                public MenuElement getMenuElement() {
                    return (MenuElement)((Object)oper.getSource());
                }
            };
        } else if (oper instanceof JPopupMenuOperator) {
            action = new OneReleaseAction(chooser, 0, oper, false){

                @Override
                public MenuElement getMenuElement() {
                    return (MenuElement)((Object)oper.getSource());
                }
            };
        } else {
            DriverManager.getButtonDriver(oper).press(oper);
            action = new OneReleaseAction(chooser, 0, oper, false){

                @Override
                public Object launch() {
                    this.process((MenuElement)((Object)oper.getSource()));
                    return (MenuElement)((Object)oper.getSource());
                }

                @Override
                public MenuElement getMenuElement() {
                    return null;
                }
            };
        }
        if (System.getProperty("java.specification.version").compareTo("1.4") > 0) {
            this.queueTool.setOutput(oper.getOutput().createErrorOutput());
            this.queueTool.waitEmpty(10L);
            this.queueTool.waitEmpty(10L);
            this.queueTool.waitEmpty(10L);
        }
        if ((result = this.runAction(action, oper, oper.getTimeouts().getTimeout("ComponentOperator.WaitComponentTimeout"), chooser instanceof DescriptablePathChooser ? ((DescriptablePathChooser)chooser).getDescription() : "Menu pushing")) instanceof JMenu) {
            for (int i = 1; i < chooser.getDepth(); ++i) {
                JMenu menu = (JMenu)result;
                final PopupMenuChooser popupChooser = new PopupMenuChooser(menu);
                action = new OneReleaseAction(chooser, i, oper, action.mousePressed){

                    @Override
                    public MenuElement getMenuElement() {
                        Window win = JPopupMenuOperator.findJPopupWindow(popupChooser);
                        if (win != null && win.isShowing()) {
                            return JPopupMenuOperator.findJPopupMenu(win, popupChooser);
                        }
                        return null;
                    }
                };
                result = this.runAction(action, oper, oper.getTimeouts().getTimeout("JMenuOperator.WaitPopupTimeout"), chooser instanceof DescriptablePathChooser ? ((DescriptablePathChooser)chooser).getDescription() : "Menu pushing");
            }
        }
        return result;
    }

    private JMenuItem runAction(final OneReleaseAction action, ComponentOperator env, long waitingTime, final String description) {
        Waiter waiter = new Waiter(new Waitable(){

            @Override
            public Object actionProduced(Object param) {
                return QueueJMenuDriver.this.queueTool.invokeSmoothly(action);
            }

            @Override
            public String getDescription() {
                return description;
            }
        });
        waiter.setOutput(env.getOutput().createErrorOutput());
        waiter.setTimeouts(env.getTimeouts().cloneThis());
        waiter.getTimeouts().setTimeout("Waiter.WaitingTime", waitingTime);
        waiter.getTimeouts().setTimeout("Waiter.TimeDelta", 100L);
        if (System.getProperty("java.specification.version").compareTo("1.4") > 0) {
            this.queueTool.setOutput(env.getOutput().createErrorOutput());
            this.queueTool.waitEmpty(10L);
            this.queueTool.waitEmpty(10L);
            this.queueTool.waitEmpty(10L);
        }
        try {
            return (JMenuItem)waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            action.stop();
            throw new JemmyException("Waiting has been interrupted", e);
        }
    }

    private boolean isMenuBarSelected(JMenuBar bar) {
        MenuElement[] subElements = bar.getSubElements();
        for (int i = 0; i < subElements.length; ++i) {
            if (!(subElements[i] instanceof JMenu) || !((JMenu)subElements[i]).isPopupMenuVisible()) continue;
            return true;
        }
        return false;
    }

    private static class PopupMenuChooser
    implements ComponentChooser {
        JMenu menu;

        public PopupMenuChooser(JMenu menu) {
            this.menu = menu;
        }

        @Override
        public boolean checkComponent(Component comp) {
            return comp == this.menu.getPopupMenu() && comp.isShowing() && comp.isEnabled();
        }

        @Override
        public String getDescription() {
            return this.menu.getText() + "'s popup";
        }
    }

    private abstract class OneReleaseAction
    extends QueueTool.QueueAction {
        PathChooser chooser;
        int depth;
        ComponentOperator env;
        boolean mousePressed;
        private boolean stopped;

        public OneReleaseAction(PathChooser chooser, int depth, ComponentOperator env, boolean mousePressed) {
            super("Menu pushing");
            this.mousePressed = false;
            this.stopped = false;
            this.chooser = chooser;
            this.depth = depth;
            this.env = env;
            this.mousePressed = mousePressed;
        }

        protected void pushAlone(JMenuItemOperator subMenuOper) {
            DriverManager.getButtonDriver(subMenuOper).push(subMenuOper);
        }

        protected void pushLast(JMenuItemOperator subMenuOper, boolean mousePressed) {
            DriverManager.getMouseDriver(subMenuOper).enterMouse(subMenuOper);
            DriverManager.getButtonDriver(subMenuOper).release(subMenuOper);
        }

        protected boolean inTheMiddle(JMenuOperator subMenuOper, boolean mousePressed) {
            if (!subMenuOper.isPopupMenuVisible()) {
                if (!mousePressed) {
                    DriverManager.getMouseDriver(subMenuOper).enterMouse(subMenuOper);
                    DriverManager.getButtonDriver(subMenuOper).press(subMenuOper);
                } else {
                    DriverManager.getMouseDriver(subMenuOper).enterMouse(subMenuOper);
                }
                return true;
            }
            return mousePressed;
        }

        protected void process(MenuElement element) {
            if (this.depth == this.chooser.getDepth() - 1) {
                JMenuItemOperator subMenuOper = new JMenuItemOperator((JMenuItem)element);
                subMenuOper.copyEnvironment(this.env);
                if (this.depth == 0) {
                    this.pushAlone(subMenuOper);
                } else {
                    this.pushLast(subMenuOper, this.mousePressed);
                }
            } else if (element instanceof JMenu) {
                JMenuOperator subMenuOper = new JMenuOperator((JMenu)element);
                subMenuOper.copyEnvironment(this.env);
                this.mousePressed = this.inTheMiddle(subMenuOper, this.mousePressed);
            } else {
                throw new JemmyException("Menu path too long");
            }
        }

        @Override
        public Object launch() {
            MenuElement element = this.getMenuElement();
            if (element != null) {
                MenuElement[] subElements = element.getSubElements();
                for (int i = 0; i < subElements.length; ++i) {
                    if (((Component)((Object)subElements[i])).isShowing() && ((Component)((Object)subElements[i])).isEnabled() && this.chooser.checkPathComponent(this.depth, subElements[i])) {
                        this.process(subElements[i]);
                        return subElements[i];
                    }
                    if (!this.stopped) continue;
                    return null;
                }
            }
            return null;
        }

        public abstract MenuElement getMenuElement();

        private void stop() {
            this.stopped = true;
        }
    }
}

