/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages;

import nu.validator.json.JsonHandler;
import nu.validator.messages.JsonExtractHandler;
import nu.validator.messages.JsonMessageTextHandler;
import nu.validator.messages.JsonSourceHandler;
import nu.validator.messages.MessageEmitter;
import nu.validator.messages.MessageTextHandler;
import nu.validator.messages.types.MessageType;
import nu.validator.source.SourceHandler;
import org.xml.sax.SAXException;

public class JsonMessageEmitter
extends MessageEmitter {
    private final JsonHandler handler;
    private final String callback;
    private final JsonExtractHandler extractHandler;
    private final JsonMessageTextHandler messageTextHandler;
    private boolean arrayOpen;

    public JsonMessageEmitter(JsonHandler handler, String callback, boolean asciiQuotes) {
        this.handler = handler;
        this.callback = callback;
        this.extractHandler = new JsonExtractHandler(handler);
        this.messageTextHandler = new JsonMessageTextHandler(handler, asciiQuotes);
    }

    @Override
    public void endMessage() throws SAXException {
        this.handler.endObject();
    }

    @Override
    public void startMessage(MessageType type, String systemId, int oneBasedFirstLine, int oneBasedFirstColumn, int oneBasedLastLine, int oneBasedLastColumn, boolean exact) throws SAXException {
        String subType;
        assert (this.arrayOpen);
        this.handler.startObject();
        this.handler.key("type");
        this.handler.string(type.getSuperType());
        if (systemId != null) {
            this.handler.key("url");
            this.handler.string(systemId);
        }
        if (oneBasedLastLine != -1) {
            this.handler.key("lastLine");
            this.handler.number(oneBasedLastLine);
            if (oneBasedFirstLine != oneBasedLastLine) {
                this.handler.key("firstLine");
                this.handler.number(oneBasedFirstLine);
            }
            if (oneBasedLastColumn != -1) {
                this.handler.key("lastColumn");
                this.handler.number(oneBasedLastColumn);
                if (oneBasedFirstColumn != oneBasedLastColumn) {
                    this.handler.key("firstColumn");
                    this.handler.number(oneBasedFirstColumn);
                }
            }
        }
        if ((subType = type.getSubType()) != null) {
            this.handler.key("subType");
            this.handler.string(subType);
        }
    }

    @Override
    public void endFullSource() throws SAXException {
    }

    @Override
    public void endMessages(String language) throws SAXException {
        this.maybeCloseArray();
        if (!"".equals(language) && language != null) {
            this.handler.key("language");
            this.handler.string(language);
        }
        this.handler.endObject();
        this.handler.endDocument();
    }

    private void maybeCloseArray() throws SAXException {
        if (this.arrayOpen) {
            this.handler.endArray();
            this.arrayOpen = false;
        }
    }

    @Override
    public void endSource() throws SAXException {
        this.handler.key("hiliteStart");
        this.handler.number(this.extractHandler.getHiliteStart());
        this.handler.key("hiliteLength");
        this.handler.number(this.extractHandler.getHiliteLength());
    }

    @Override
    public void endText() throws SAXException {
        this.handler.endString();
    }

    @Override
    public SourceHandler startFullSource(int lineOffset) throws SAXException {
        this.maybeCloseArray();
        this.handler.key("source");
        return new JsonSourceHandler(this.handler);
    }

    @Override
    public void startMessages(String documentUri, boolean willShowSource) throws SAXException {
        this.handler.startDocument(this.callback);
        this.handler.startObject();
        if (documentUri != null) {
            this.handler.key("url");
            this.handler.string(documentUri);
        }
        this.handler.key("messages");
        this.handler.startArray();
        this.arrayOpen = true;
    }

    @Override
    public SourceHandler startSource() throws SAXException {
        this.handler.key("extract");
        return this.extractHandler;
    }

    @Override
    public MessageTextHandler startText() throws SAXException {
        this.handler.key("message");
        this.handler.startString();
        return this.messageTextHandler;
    }
}

