/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.stream.FactoryConfigurationError;

class FactoryFinder {
    private static boolean debug = false;

    FactoryFinder() {
    }

    private static void debugPrintln(String string) {
        if (debug) {
            System.err.println("STREAM: " + string);
        }
    }

    private static ClassLoader findClassLoader() throws FactoryConfigurationError {
        ClassLoader classLoader;
        try {
            Class<?> clazz = Class.forName(FactoryFinder.class.getName() + "$ClassLoaderFinderConcrete");
            ClassLoaderFinder classLoaderFinder = (ClassLoaderFinder)clazz.newInstance();
            classLoader = classLoaderFinder.getContextClassLoader();
        }
        catch (LinkageError linkageError) {
            classLoader = FactoryFinder.class.getClassLoader();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classLoader = FactoryFinder.class.getClassLoader();
        }
        catch (Exception exception) {
            throw new FactoryConfigurationError(exception.toString(), exception);
        }
        return classLoader;
    }

    private static Object newInstance(String string, ClassLoader classLoader) throws FactoryConfigurationError {
        try {
            Class<?> clazz = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FactoryConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new FactoryConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    static Object find(String string) throws FactoryConfigurationError {
        return FactoryFinder.find(string, null);
    }

    static Object find(String string, String string2) throws FactoryConfigurationError {
        ClassLoader classLoader = FactoryFinder.findClassLoader();
        return FactoryFinder.find(string, string2, classLoader);
    }

    static Object find(String string, String string2, ClassLoader classLoader) throws FactoryConfigurationError {
        block12: {
            Object object;
            Object object2;
            String string3;
            block11: {
                try {
                    string3 = System.getProperty(string);
                    if (string3 != null) {
                        FactoryFinder.debugPrintln("found system property" + string3);
                        return FactoryFinder.newInstance(string3, classLoader);
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                try {
                    string3 = System.getProperty("java.home");
                    object2 = string3 + File.separator + "lib" + File.separator + "jaxp.properties";
                    object = new File((String)object2);
                    if (((File)object).exists()) {
                        Properties properties = new Properties();
                        properties.load(new FileInputStream((File)object));
                        String string4 = properties.getProperty(string);
                        FactoryFinder.debugPrintln("found java.home property " + string4);
                        return FactoryFinder.newInstance(string4, classLoader);
                    }
                }
                catch (Exception exception) {
                    if (!debug) break block11;
                    exception.printStackTrace();
                }
            }
            string3 = "META-INF/services/" + string;
            try {
                object2 = null;
                object2 = classLoader == null ? ClassLoader.getSystemResourceAsStream(string3) : classLoader.getResourceAsStream(string3);
                if (object2 != null) {
                    FactoryFinder.debugPrintln("found " + string3);
                    object = new BufferedReader(new InputStreamReader((InputStream)object2, "UTF-8"));
                    String string5 = ((BufferedReader)object).readLine();
                    ((BufferedReader)object).close();
                    if (string5 != null && !"".equals(string5)) {
                        FactoryFinder.debugPrintln("loaded from services: " + string5);
                        return FactoryFinder.newInstance(string5, classLoader);
                    }
                }
            }
            catch (Exception exception) {
                if (!debug) break block12;
                exception.printStackTrace();
            }
        }
        if (string2 == null) {
            throw new FactoryConfigurationError("Provider for " + string + " cannot be found", null);
        }
        FactoryFinder.debugPrintln("loaded from fallback value: " + string2);
        return FactoryFinder.newInstance(string2, classLoader);
    }

    static {
        try {
            debug = System.getProperty("xml.stream.debug") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class ClassLoaderFinderConcrete
    extends ClassLoaderFinder {
        ClassLoaderFinderConcrete() {
        }

        ClassLoader getContextClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private static abstract class ClassLoaderFinder {
        private ClassLoaderFinder() {
        }

        abstract ClassLoader getContextClassLoader();
    }
}

