/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.gsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.php.twig.editor.parsing.TwigParserResult;
import org.openide.filesystems.FileObject;

public class TwigStructureItem
implements StructureItem {
    private static final String BLOCK = "Block";
    List<TwigStructureItem> blocks;
    TwigParserResult.Block item;
    Snapshot snapshot;

    public TwigStructureItem(Snapshot snapshot, TwigParserResult.Block item, List<TwigParserResult.Block> blocks) {
        this.item = item;
        this.blocks = new ArrayList<TwigStructureItem>();
        this.snapshot = snapshot;
        for (TwigParserResult.Block current : blocks) {
            if (item.getOffset() >= current.getOffset() || current.getOffset() + current.getLength() >= item.getOffset() + item.getLength()) continue;
            this.blocks.add(new TwigStructureItem(snapshot, current, blocks));
        }
    }

    public String getName() {
        return "Block " + this.item.getExtra();
    }

    public String getSortText() {
        return "Block " + this.item.getDescription();
    }

    public String getHtml(HtmlFormatter hf) {
        return "Block " + this.item.getExtra();
    }

    public ElementHandle getElementHandle() {
        return new TwigElementHandle(this.item, this.snapshot);
    }

    public ElementKind getKind() {
        return ElementKind.ATTRIBUTE;
    }

    public Set<Modifier> getModifiers() {
        if (CharSequenceUtilities.startsWith((CharSequence)this.item.getDescription(), (CharSequence)"*")) {
            return Collections.singleton(Modifier.STATIC);
        }
        return Collections.emptySet();
    }

    public boolean isLeaf() {
        return this.blocks.isEmpty();
    }

    public List<? extends StructureItem> getNestedItems() {
        return this.blocks;
    }

    public long getPosition() {
        return this.item.getOffset();
    }

    public long getEndPosition() {
        return this.item.getOffset() + this.item.getLength();
    }

    public ImageIcon getCustomIcon() {
        return null;
    }

    static class TwigElementHandle
    implements ElementHandle {
        TwigParserResult.Block item;
        Snapshot snapshot;

        public TwigElementHandle(TwigParserResult.Block item, Snapshot snapshot) {
            this.item = item;
            this.snapshot = snapshot;
        }

        public FileObject getFileObject() {
            return this.snapshot.getSource().getFileObject();
        }

        public String getMimeType() {
            return "text/x-twig";
        }

        public String getName() {
            return "Block " + this.item.getExtra();
        }

        public String getIn() {
            return "Block " + this.item.getExtra();
        }

        public ElementKind getKind() {
            return ElementKind.ATTRIBUTE;
        }

        public Set<Modifier> getModifiers() {
            if (CharSequenceUtilities.startsWith((CharSequence)this.item.getDescription(), (CharSequence)"*")) {
                return Collections.singleton(Modifier.STATIC);
            }
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle eh) {
            if (!(eh instanceof TwigElementHandle)) {
                return false;
            }
            return eh.getName().equals(this.getName());
        }

        public OffsetRange getOffsetRange(ParserResult pr) {
            return new OffsetRange(this.item.getOffset(), this.item.getOffset() + this.item.getLength());
        }
    }
}

