/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seembedded.project;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seembedded.platform.ConnectionMethod;
import org.netbeans.modules.java.j2seembedded.platform.RemotePlatform;
import org.netbeans.modules.java.j2seembedded.project.Utilities;
import org.netbeans.modules.java.j2seproject.api.J2SEBuildPropertiesProvider;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public class RemoteBuildPropertiesProvider
implements J2SEBuildPropertiesProvider {
    private static final String PROP_PASSWD = "remote.platform.password";
    private static final String PROP_PASSPHRASE = "remote.platform.passphrase";
    private static final String PROP_OS_ARCH_RP = "remote.platform.rp.target";
    private static final String PROP_FILENAME_RP = "remote.platform.rp.filename";
    private static final String PROP_JAVA_SPEC_VER = "remote.platform.java.spec.ver";
    private final Project prj;

    public RemoteBuildPropertiesProvider(@NonNull Project prj) {
        Parameters.notNull((CharSequence)"prj", (Object)prj);
        this.prj = prj;
    }

    @NonNull
    public Map<String, String> createAdditionalProperties(@NonNull String command, @NonNull Lookup context) {
        Parameters.notNull((CharSequence)"command", (Object)command);
        Parameters.notNull((CharSequence)"context", (Object)context);
        switch (command) {
            case "run": 
            case "debug": 
            case "profile": {
                RemotePlatform rp = Utilities.getRemotePlatform(this.prj);
                if (rp == null) break;
                ConnectionMethod.Authentification auth = rp.getConnectionMethod().getAuthentification();
                HashMap<String, String> res = new HashMap<String, String>();
                String target = Utilities.getTargetOSForRP((String)rp.getSystemProperties().get("os.name"), (String)rp.getSystemProperties().get("os.arch"), (String)rp.getSystemProperties().get("sun.arch.abi"), (String)rp.getSystemProperties().get("java.vm.name"));
                res.put(PROP_JAVA_SPEC_VER, ((String)rp.getSystemProperties().get("java.specification.version")).replace(".", ""));
                res.put(PROP_OS_ARCH_RP, target);
                res.put(PROP_FILENAME_RP, target.replace("-", "").replace("15", ""));
                switch (auth.getKind()) {
                    case PASSWORD: {
                        res.put(PROP_PASSWD, ((ConnectionMethod.Authentification.Password)auth).getPassword());
                        break;
                    }
                    case KEY: {
                        res.put(PROP_PASSPHRASE, ((ConnectionMethod.Authentification.Key)auth).getPassPhrase());
                        break;
                    }
                    default: {
                        throw new IllegalStateException(auth.getKind().name());
                    }
                }
                return Collections.unmodifiableMap(res);
            }
        }
        return Collections.emptyMap();
    }

    @NonNull
    public Set<String> createConcealedProperties(@NonNull String command, @NonNull Lookup context) {
        Parameters.notNull((CharSequence)"command", (Object)command);
        Parameters.notNull((CharSequence)"context", (Object)context);
        switch (command) {
            case "run": 
            case "debug": 
            case "profile": {
                RemotePlatform rp = Utilities.getRemotePlatform(this.prj);
                if (rp == null) break;
                ConnectionMethod.Authentification.Kind kind = rp.getConnectionMethod().getAuthentification().getKind();
                switch (kind) {
                    case PASSWORD: {
                        return Collections.singleton(PROP_PASSWD);
                    }
                    case KEY: {
                        return Collections.singleton(PROP_PASSPHRASE);
                    }
                }
                throw new IllegalStateException(kind.name());
            }
        }
        return Collections.emptySet();
    }
}

