/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.actions.Bundle;
import org.netbeans.modules.project.ui.api.UnloadedProjectInformation;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class RecentProjects
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup,
PropertyChangeListener {
    private static final String PROJECT_URL_KEY = "org.netbeans.modules.project.ui.RecentProjectItem.Project_URL";
    private final ProjectDirListener prjDirListener = new ProjectDirListener();
    private UpdatingMenu subMenu;
    private boolean recreate;
    private static final RequestProcessor RP = new RequestProcessor(RecentProjects.class);

    public RecentProjects() {
        super(Bundle.LBL_RecentProjectsAction_Name());
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
        this.recreate = true;
    }

    @Override
    public boolean isEnabled() {
        return !OpenProjectList.getDefault().isRecentProjectsEmpty();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
    }

    public JMenuItem getMenuPresenter() {
        this.createMainSubMenu();
        return this.subMenu;
    }

    public JMenuItem getPopupPresenter() {
        UpdatingMenu menu = this.createSubMenu();
        this.fillSubMenu(menu);
        return menu;
    }

    private UpdatingMenu createSubMenu() {
        UpdatingMenu menu = new UpdatingMenu(this);
        menu.setMnemonic(Bundle.MNE_RecentProjectsAction_Name().charAt(0));
        return menu;
    }

    private void createMainSubMenu() {
        if (this.subMenu == null) {
            this.subMenu = this.createSubMenu();
            this.subMenu.getModel().addChangeListener(this.subMenu);
        }
    }

    private void fillSubMenu(JMenu menu) {
        menu.removeAll();
        List<UnloadedProjectInformation> projects = OpenProjectList.getDefault().getRecentProjectsInformation();
        if (projects.isEmpty()) {
            menu.setEnabled(false);
            return;
        }
        menu.setEnabled(true);
        MenuItemActionListener jmiActionListener = new MenuItemActionListener();
        final ArrayList<URL> urls = new ArrayList<URL>();
        for (final UnloadedProjectInformation p : projects) {
            URL prjDirURL = p.getURL();
            urls.add(prjDirURL);
            JMenuItem jmi = new JMenuItem(p.getDisplayName(), p.getIcon()){

                @Override
                public void menuSelectionChanged(boolean isIncluded) {
                    super.menuSelectionChanged(isIncluded);
                    if (isIncluded) {
                        FileObject prjDir = URLMapper.findFileObject((URL)p.getURL());
                        if (prjDir == null || !prjDir.isValid()) {
                            return;
                        }
                        StatusDisplayer.getDefault().setStatusText(FileUtil.getFileDisplayName((FileObject)prjDir));
                    }
                }
            };
            menu.add(jmi);
            jmi.putClientProperty(PROJECT_URL_KEY, prjDirURL);
            jmi.addActionListener(jmiActionListener);
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                for (URL u : urls) {
                    FileObject prjDir = URLMapper.findFileObject((URL)u);
                    if (prjDir == null || !prjDir.isValid()) continue;
                    prjDir.removeFileChangeListener((FileChangeListener)RecentProjects.this.prjDirListener);
                    prjDir.addFileChangeListener((FileChangeListener)RecentProjects.this.prjDirListener);
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("RecentProjects".equals(e.getPropertyName())) {
            final boolean en = !OpenProjectList.getDefault().isRecentProjectsEmpty();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RecentProjects.this.createMainSubMenu();
                    RecentProjects.this.subMenu.setEnabled(en);
                    RecentProjects.this.recreate = true;
                }
            });
        }
    }

    private class UpdatingMenu
    extends JMenu
    implements ChangeListener {
        UpdatingMenu(Action action) {
            super(action);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (RecentProjects.this.recreate && this.getModel().isSelected()) {
                RecentProjects.this.fillSubMenu(this);
                RecentProjects.this.recreate = false;
            }
        }
    }

    private class ProjectDirListener
    extends FileChangeAdapter {
        private ProjectDirListener() {
        }

        public void fileDeleted(FileEvent fe) {
            RecentProjects.this.recreate = true;
        }
    }

    private static class MenuItemActionListener
    implements ActionListener {
        private static final RequestProcessor RP = new RequestProcessor(MenuItemActionListener.class);

        private MenuItemActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                JMenuItem jmi = (JMenuItem)e.getSource();
                final URL url = (URL)jmi.getClientProperty(RecentProjects.PROJECT_URL_KEY);
                StatusDisplayer.getDefault().setStatusText(Bundle.STATUS_loading_recent(url));
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        Project project = null;
                        FileObject dir = URLMapper.findFileObject((URL)url);
                        if (dir != null && dir.isFolder()) {
                            try {
                                project = ProjectManager.getDefault().findProject(dir);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (project != null) {
                            OpenProjectList.getDefault().open(new Project[]{project}, false, true);
                            final String name = ProjectUtils.getInformation((Project)project).getName();
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ProjectTab ptLogical = ProjectTab.findDefault("projectTabLogical_tc");
                                    Node root = ptLogical.getExplorerManager().getRootContext();
                                    Node projNode = root.getChildren().findChild(name);
                                    if (projNode != null) {
                                        try {
                                            ptLogical.getExplorerManager().setSelectedNodes(new Node[]{projNode});
                                        }
                                        catch (PropertyVetoException propertyVetoException) {}
                                    } else {
                                        Logger.getLogger(RecentProjects.class.getName()).log(Level.WARNING, "Could not find {0} among {1}", new Object[]{name, Arrays.asList(root.getChildren().getNodes())});
                                    }
                                    ProjectUtilities.makeProjectTabVisible();
                                }
                            });
                        } else {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_InvalidProject()));
                        }
                    }
                });
            }
        }
    }
}

