/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.Bundle;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectCellRenderer;
import org.netbeans.modules.project.ui.TemplatesPanelGUI;
import org.netbeans.modules.project.ui.spi.TemplateCategorySorter;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.AsyncGUIJob;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class TemplateChooserPanelGUI
extends JPanel
implements PropertyChangeListener,
AsyncGUIJob {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private FileObject templatesFolder;
    private TemplatesPanelGUI.Builder builder = new FileChooserBuilder();
    @NullAllowed
    private Project project;
    @NonNull
    private String[] projectRecommendedTypes;
    private String category;
    private String template;
    private boolean isWarmUp = true;
    private ListCellRenderer projectCellRenderer;
    private boolean firstTime = true;
    private ActionListener defaultActionListener;
    private boolean includeTemplatesWithProjects;
    private JLabel jLabel1;
    private JComboBox projectsComboBox;
    private JPanel templatesPanel;

    public TemplateChooserPanelGUI(boolean includeTemplatesWithProject) {
        this.includeTemplatesWithProjects = includeTemplatesWithProject;
        this.initComponents();
        this.setPreferredSize(PREF_DIM);
        this.setName(Bundle.LBL_TemplateChooserPanelGUI_Name());
        this.projectCellRenderer = new ProjectCellRenderer();
        this.projectsComboBox.setRenderer(this.projectCellRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readValues(@NullAllowed Project p, String category, String template) {
        boolean wf;
        TemplateChooserPanelGUI templateChooserPanelGUI = this;
        synchronized (templateChooserPanelGUI) {
            this.project = p;
            this.projectRecommendedTypes = OpenProjectList.getRecommendedTypes(p);
            this.category = category;
            this.template = template;
            wf = this.isWarmUp;
        }
        if (!wf) {
            this.selectProject(this.project);
            ((TemplatesPanelGUI)this.templatesPanel).setSelectedCategoryByName(this.category);
            ((TemplatesPanelGUI)this.templatesPanel).setSelectedTemplateByName(this.template);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.project = null;
    }

    private void initValues(@NullAllowed Project p) {
        DefaultComboBoxModel<Object> projectsModel;
        if (this.includeTemplatesWithProjects) {
            Project[] openProjects = OpenProjectList.getDefault().getOpenProjects();
            Arrays.sort(openProjects, OpenProjectList.projectByDisplayName());
            projectsModel = new DefaultComboBoxModel<Project>(openProjects);
            this.selectProject(p);
        } else {
            projectsModel = new DefaultComboBoxModel();
        }
        this.projectsComboBox.setModel(projectsModel);
        this.projectsComboBox.setEnabled(this.includeTemplatesWithProjects);
        this.selectProject(p);
    }

    private void selectProject(@NullAllowed Project p) {
        if (p != null) {
            DefaultComboBoxModel projectsModel = (DefaultComboBoxModel)this.projectsComboBox.getModel();
            if (projectsModel.getIndexOf(p) == -1) {
                projectsModel.insertElementAt(p, 0);
            }
            this.projectsComboBox.setSelectedItem(p);
        } else {
            this.projectsComboBox.setSelectedItem(null);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    void setDefaultActionListener(ActionListener al) {
        this.defaultActionListener = al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public Project getProject() {
        boolean wf;
        TemplateChooserPanelGUI templateChooserPanelGUI = this;
        synchronized (templateChooserPanelGUI) {
            wf = this.isWarmUp;
        }
        if (wf) {
            return this.project;
        }
        return (Project)this.projectsComboBox.getSelectedItem();
    }

    public FileObject getTemplate() {
        return ((TemplatesPanelGUI)this.templatesPanel).getSelectedTemplate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireChange();
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    public String getCategoryName() {
        return ((TemplatesPanelGUI)this.templatesPanel).getSelectedCategoryName();
    }

    public String getTemplateName() {
        return ((TemplatesPanelGUI)this.templatesPanel).getSelectedTemplateName();
    }

    public void setCategory(String category) {
        ((TemplatesPanelGUI)this.templatesPanel).setSelectedCategoryByName(category);
    }

    @Override
    public void addNotify() {
        if (this.firstTime) {
            Utilities.attachInitJob((Component)this, (AsyncGUIJob)this);
            this.firstTime = false;
        }
        super.addNotify();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.projectsComboBox = new JComboBox();
        this.templatesPanel = new TemplatesPanelGUI(this.builder);
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.projectsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"LBL_TemplateChooserPanelGUI_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 13, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"ACSN_jLabel1"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"ACSD_jLabel1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.projectsComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.templatesPanel, gridBagConstraints);
    }

    private static boolean isFilteredFileTemplate(DataObject dobj, String filterText, Project project, String[] projectRecommendedTypes) {
        boolean res = false;
        if (TemplateChooserPanelGUI.isTemplate(dobj) && OpenProjectList.isRecommended(project, projectRecommendedTypes, dobj.getPrimaryFile())) {
            if (dobj instanceof DataShadow) {
                dobj = ((DataShadow)dobj).getOriginal();
            }
            res = null == filterText || dobj.getNodeDelegate().getDisplayName().toLowerCase().contains(filterText.toLowerCase());
        }
        return res;
    }

    private static boolean isTemplate(DataObject dobj) {
        if (dobj.isTemplate()) {
            return true;
        }
        if (dobj instanceof DataShadow) {
            return ((DataShadow)dobj).getOriginal().isTemplate();
        }
        return false;
    }

    private boolean hasChildren(Project p, DataObject folder) {
        if (!(folder instanceof DataFolder)) {
            return false;
        }
        DataFolder f = (DataFolder)folder;
        if (!OpenProjectList.isRecommended(p, this.projectRecommendedTypes, f.getPrimaryFile())) {
            return false;
        }
        DataObject[] ch = f.getChildren();
        for (int i = 0; i < ch.length; ++i) {
            if (!(TemplateChooserPanelGUI.isTemplate(ch[i]) && OpenProjectList.isRecommended(p, this.projectRecommendedTypes, ch[i].getPrimaryFile()) ? !(ch[i] instanceof DataShadow) : ch[i] instanceof DataFolder && this.hasChildren(p, ch[i]))) continue;
            return true;
        }
        return false;
    }

    public void construct() {
        this.templatesFolder = FileUtil.getConfigFile((String)"Templates");
        ((TemplatesPanelGUI)this.templatesPanel).warmUp(this.templatesFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        TemplateChooserPanelGUI templateChooserPanelGUI;
        Cursor cursor = null;
        try {
            String t;
            String c;
            Project p;
            TemplateChooserPanelGUI templateChooserPanelGUI2 = this;
            synchronized (templateChooserPanelGUI2) {
                p = this.project;
                c = this.category;
                t = this.template;
            }
            cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.initValues(p);
            ((TemplatesPanelGUI)this.templatesPanel).doFinished(this.templatesFolder, c, t);
            templateChooserPanelGUI = this;
        }
        catch (Throwable throwable) {
            TemplateChooserPanelGUI templateChooserPanelGUI3 = this;
            synchronized (templateChooserPanelGUI3) {
                this.isWarmUp = false;
            }
            if (cursor != null) {
                this.setCursor(cursor);
            }
            throw throwable;
        }
        synchronized (templateChooserPanelGUI) {
            this.isWarmUp = false;
        }
        if (cursor != null) {
            this.setCursor(cursor);
        }
    }

    static /* synthetic */ String[] access$202(TemplateChooserPanelGUI x0, String[] x1) {
        x0.projectRecommendedTypes = x1;
        return x1;
    }

    final class FileChooserBuilder
    implements TemplatesPanelGUI.Builder {
        FileChooserBuilder() {
        }

        @Override
        public Children createCategoriesChildren(DataFolder folder, String filterText) {
            return Children.create((ChildFactory)new TemplateChildren(folder, true, filterText), (boolean)true);
        }

        @Override
        public Children createTemplatesChildren(DataFolder folder, String filterText) {
            return Children.create((ChildFactory)new FileChildren(folder, filterText), (boolean)true);
        }

        @Override
        public void fireChange() {
            TemplateChooserPanelGUI.this.fireChange();
        }

        @Override
        public String getCategoriesName() {
            return Bundle.CTL_Categories();
        }

        @Override
        public String getTemplatesName() {
            return Bundle.CTL_Files();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (null != TemplateChooserPanelGUI.this.defaultActionListener) {
                TemplateChooserPanelGUI.this.defaultActionListener.actionPerformed(e);
            }
        }
    }

    private final class FileChildren
    extends ChildFactory<DataObject> {
        private DataFolder root;
        private final String filterText;

        public FileChildren(DataFolder folder, String filterText) {
            this.root = folder;
            assert (this.root != null) : "Root can not be null";
            this.filterText = filterText;
        }

        protected boolean createKeys(List<DataObject> keys) {
            for (DataObject dobj : this.root.getChildren()) {
                if (!TemplateChooserPanelGUI.isFilteredFileTemplate(dobj, this.filterText, TemplateChooserPanelGUI.this.project, TemplateChooserPanelGUI.this.projectRecommendedTypes)) continue;
                keys.add(dobj);
            }
            return true;
        }

        protected Node createNodeForKey(DataObject d) {
            return new FilterNode(d.getNodeDelegate(), Children.LEAF);
        }
    }

    private final class TemplateChildren
    extends ChildFactory.Detachable<TemplateKey>
    implements ActionListener {
        private final DataFolder folder;
        private final boolean isRoot;
        private final String filterText;

        TemplateChildren(DataFolder folder, boolean root, String filterText) {
            this.folder = folder;
            this.isRoot = root;
            this.filterText = filterText;
        }

        protected void addNotify() {
            TemplateChooserPanelGUI.this.projectsComboBox.addActionListener(this);
        }

        protected void removeNotify() {
            TemplateChooserPanelGUI.this.projectsComboBox.removeActionListener(this);
        }

        protected boolean createKeys(List<TemplateKey> keys) {
            DataObject[] children = this.folder.getChildren();
            if (this.isRoot) {
                TemplateCategorySorter tcs;
                Project p = TemplateChooserPanelGUI.this.getProject();
                TemplateCategorySorter templateCategorySorter = tcs = p != null ? (TemplateCategorySorter)p.getLookup().lookup(TemplateCategorySorter.class) : null;
                if (tcs != null) {
                    ArrayList<DataObject> dobjs = new ArrayList<DataObject>();
                    for (DataObject d : children) {
                        if (!this.isFolderOfTemplates(d)) continue;
                        dobjs.add(d);
                    }
                    List<DataObject> sorted = tcs.sort(dobjs);
                    assert (sorted.size() == dobjs.size() && new HashSet<DataObject>(dobjs).equals(new HashSet<DataObject>(sorted)));
                    children = sorted.toArray(new DataObject[children.length]);
                }
            }
            for (DataObject d : children) {
                if (!this.isFolderOfTemplates(d)) continue;
                boolean leaf = true;
                for (DataObject child : ((DataFolder)d).getChildren()) {
                    if (!this.isFolderOfTemplates(child)) continue;
                    leaf = false;
                    break;
                }
                if (null != this.filterText && !this.hasFilteredFileTemplates(d, this.filterText)) continue;
                keys.add(new TemplateKey(d, leaf));
            }
            return true;
        }

        private boolean hasFilteredFileTemplates(DataObject root, String filterText) {
            boolean res = false;
            if (root instanceof DataFolder) {
                for (DataObject dobj : ((DataFolder)root).getChildren()) {
                    res = TemplateChooserPanelGUI.isFilteredFileTemplate(dobj, filterText, TemplateChooserPanelGUI.this.project, TemplateChooserPanelGUI.this.projectRecommendedTypes);
                    if (!res && dobj instanceof DataFolder) {
                        res = this.hasFilteredFileTemplates(dobj, filterText);
                    }
                    if (res) break;
                }
            }
            return res;
        }

        protected Node createNodeForKey(TemplateKey k) {
            return new FilterNode(k.d.getNodeDelegate(), k.leaf ? Children.LEAF : Children.create((ChildFactory)new TemplateChildren((DataFolder)k.d, false, this.filterText), (boolean)true));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TemplateChooserPanelGUI.access$202(TemplateChooserPanelGUI.this, OpenProjectList.getRecommendedTypes(TemplateChooserPanelGUI.this.getProject()));
            String cat = TemplateChooserPanelGUI.this.getCategoryName();
            String template = ((TemplatesPanelGUI)TemplateChooserPanelGUI.this.templatesPanel).getSelectedTemplateName();
            this.refresh(false);
            TemplateChooserPanelGUI.this.setCategory(cat);
            ((TemplatesPanelGUI)TemplateChooserPanelGUI.this.templatesPanel).setSelectedTemplateByName(template);
        }

        private boolean isFolderOfTemplates(DataObject d) {
            Object o;
            if (d instanceof DataFolder && !TemplateChooserPanelGUI.isTemplate((DataObject)((DataFolder)d)) && ((o = d.getPrimaryFile().getAttribute("simple")) == null || Boolean.TRUE.equals(o))) {
                boolean hasChildren = TemplateChooserPanelGUI.this.hasChildren((Project)TemplateChooserPanelGUI.this.projectsComboBox.getSelectedItem(), d);
                if (hasChildren) {
                    return hasChildren;
                }
                int n = 0;
                DataObject[] dataObjectArray = ((DataFolder)d).getChildren();
                int n2 = dataObjectArray.length;
                if (n < n2) {
                    DataObject child = dataObjectArray[n];
                    return this.isFolderOfTemplates(child);
                }
            }
            return false;
        }
    }

    private static final class TemplateKey {
        final DataObject d;
        final boolean leaf;

        TemplateKey(DataObject d, boolean leaf) {
            this.d = d;
            this.leaf = leaf;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TemplateKey)) {
                return false;
            }
            return this.d == ((TemplateKey)o).d && this.leaf == ((TemplateKey)o).leaf;
        }

        public int hashCode() {
            return this.d.hashCode();
        }
    }
}

