/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.UpdateUserDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateUserRequest
extends BmcRequest<UpdateUserDetails> {
    private String userId;
    private UpdateUserDetails updateUserDetails;
    private String ifMatch;

    public String getUserId() {
        return this.userId;
    }

    public UpdateUserDetails getUpdateUserDetails() {
        return this.updateUserDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateUserDetails getBody$() {
        return this.updateUserDetails;
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).updateUserDetails(this.updateUserDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userId=").append(String.valueOf(this.userId));
        sb.append(",updateUserDetails=").append(String.valueOf((Object)this.updateUserDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userId, other.userId) && Objects.equals((Object)this.updateUserDetails, (Object)other.updateUserDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.updateUserDetails == null ? 43 : this.updateUserDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateUserRequest, UpdateUserDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userId = null;
        private UpdateUserDetails updateUserDetails = null;
        private String ifMatch = null;

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder updateUserDetails(UpdateUserDetails updateUserDetails) {
            this.updateUserDetails = updateUserDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateUserRequest o) {
            this.userId(o.getUserId());
            this.updateUserDetails(o.getUpdateUserDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateUserRequest build() {
            UpdateUserRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateUserDetails body) {
            this.updateUserDetails(body);
            return this;
        }

        public UpdateUserRequest buildWithoutInvocationCallback() {
            UpdateUserRequest request = new UpdateUserRequest();
            request.userId = this.userId;
            request.updateUserDetails = this.updateUserDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

