/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.TagNamespace;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListTagNamespacesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String page;
    private Integer limit;
    private Boolean includeSubcompartments;
    private TagNamespace.LifecycleState lifecycleState;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getIncludeSubcompartments() {
        return this.includeSubcompartments;
    }

    public TagNamespace.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).page(this.page).limit(this.limit).includeSubcompartments(this.includeSubcompartments).lifecycleState(this.lifecycleState);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",includeSubcompartments=").append(String.valueOf(this.includeSubcompartments));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListTagNamespacesRequest)) {
            return false;
        }
        ListTagNamespacesRequest other = (ListTagNamespacesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.includeSubcompartments, other.includeSubcompartments) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.includeSubcompartments == null ? 43 : this.includeSubcompartments.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTagNamespacesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String page = null;
        private Integer limit = null;
        private Boolean includeSubcompartments = null;
        private TagNamespace.LifecycleState lifecycleState = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder includeSubcompartments(Boolean includeSubcompartments) {
            this.includeSubcompartments = includeSubcompartments;
            return this;
        }

        public Builder lifecycleState(TagNamespace.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTagNamespacesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.includeSubcompartments(o.getIncludeSubcompartments());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTagNamespacesRequest build() {
            ListTagNamespacesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListTagNamespacesRequest buildWithoutInvocationCallback() {
            ListTagNamespacesRequest request = new ListTagNamespacesRequest();
            request.compartmentId = this.compartmentId;
            request.page = this.page;
            request.limit = this.limit;
            request.includeSubcompartments = this.includeSubcompartments;
            request.lifecycleState = this.lifecycleState;
            return request;
        }
    }
}

