/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IdentityProviderGroupSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="identityProviderId")
    private final String identityProviderId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="externalIdentifier")
    private final String externalIdentifier;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeModified")
    private final Date timeModified;

    @Deprecated
    @ConstructorProperties(value={"id", "identityProviderId", "displayName", "name", "externalIdentifier", "timeCreated", "timeModified"})
    public IdentityProviderGroupSummary(String id, String identityProviderId, String displayName, String name, String externalIdentifier, Date timeCreated, Date timeModified) {
        this.id = id;
        this.identityProviderId = identityProviderId;
        this.displayName = displayName;
        this.name = name;
        this.externalIdentifier = externalIdentifier;
        this.timeCreated = timeCreated;
        this.timeModified = timeModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeModified() {
        return this.timeModified;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IdentityProviderGroupSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", identityProviderId=").append(String.valueOf(this.identityProviderId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", externalIdentifier=").append(String.valueOf(this.externalIdentifier));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeModified=").append(String.valueOf(this.timeModified));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentityProviderGroupSummary)) {
            return false;
        }
        IdentityProviderGroupSummary other = (IdentityProviderGroupSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.identityProviderId, other.identityProviderId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.name, other.name) && Objects.equals(this.externalIdentifier, other.externalIdentifier) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeModified, other.timeModified) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.identityProviderId == null ? 43 : this.identityProviderId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.externalIdentifier == null ? 43 : this.externalIdentifier.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeModified == null ? 43 : this.timeModified.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="identityProviderId")
        private String identityProviderId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="externalIdentifier")
        private String externalIdentifier;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeModified")
        private Date timeModified;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder identityProviderId(String identityProviderId) {
            this.identityProviderId = identityProviderId;
            this.__explicitlySet__.add("identityProviderId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder externalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
            this.__explicitlySet__.add("externalIdentifier");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeModified(Date timeModified) {
            this.timeModified = timeModified;
            this.__explicitlySet__.add("timeModified");
            return this;
        }

        public IdentityProviderGroupSummary build() {
            IdentityProviderGroupSummary model = new IdentityProviderGroupSummary(this.id, this.identityProviderId, this.displayName, this.name, this.externalIdentifier, this.timeCreated, this.timeModified);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IdentityProviderGroupSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("identityProviderId")) {
                this.identityProviderId(model.getIdentityProviderId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("externalIdentifier")) {
                this.externalIdentifier(model.getExternalIdentifier());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeModified")) {
                this.timeModified(model.getTimeModified());
            }
            return this;
        }
    }
}

