/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util.commands;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeTasksJob;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;
import org.netbeans.modules.mylyn.util.CancelableProgressMonitor;
import org.netbeans.modules.mylyn.util.NbTask;
import org.netbeans.modules.mylyn.util.internal.Accessor;

public class SynchronizeTasksCommand
extends BugtrackingCommand {
    private String stringValue;
    private final TaskRepository taskRepository;
    private final Set<NbTask> tasks;
    private final CancelableProgressMonitor monitor;
    private final AbstractRepositoryConnector repositoryConnector;
    private final TaskList taskList;
    private final TaskDataManager taskDataManager;
    private final RepositoryModel repositoryModel;
    private final boolean user;

    SynchronizeTasksCommand(AbstractRepositoryConnector repositoryConnector, TaskRepository taskRepository, RepositoryModel repositoryModel, TaskDataManager taskDataManager, TaskList taskList, Set<NbTask> tasks, boolean isUserAction) {
        this.repositoryConnector = repositoryConnector;
        this.taskRepository = taskRepository;
        this.repositoryModel = repositoryModel;
        this.taskDataManager = taskDataManager;
        this.taskList = taskList;
        this.tasks = tasks;
        this.monitor = new CancelableProgressMonitor();
        this.user = isUserAction;
    }

    @Override
    public void execute() throws CoreException, IOException, MalformedURLException {
        Logger log = Logger.getLogger(this.getClass().getName());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "executing SynchronizeTasksCommand for tasks {0}:{1}", new Object[]{this.taskRepository.getUrl(), this.tasks});
        }
        Set<ITask> mylynTasks = Accessor.getInstance().toMylynTasks(this.tasks);
        SynchronizeTasksJob job = new SynchronizeTasksJob(this.taskList, this.taskDataManager, (IRepositoryModel)this.repositoryModel, this.repositoryConnector, this.taskRepository, mylynTasks);
        job.setUser(this.user);
        job.run((IProgressMonitor)this.monitor);
    }

    @Override
    public void cancel() {
        this.monitor.setCanceled(true);
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder sb = new StringBuilder().append("Synchronizing tasks ").append(this.tasks).append(",repository=").append(this.taskRepository.getUrl()).append("]");
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }
}

