/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util.commands;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizationSession;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;
import org.netbeans.modules.mylyn.util.CancelableProgressMonitor;
import org.netbeans.modules.mylyn.util.NbTask;
import org.netbeans.modules.mylyn.util.internal.Accessor;

public class SimpleQueryCommand
extends BugtrackingCommand {
    private final AbstractRepositoryConnector repositoryConnector;
    private final TaskRepository taskRepository;
    private final IRepositoryQuery query;
    private IStatus status;
    private final IProgressMonitor monitor;
    private final Set<NbTask> tasks;
    private final TaskDataManager taskDataManager;

    SimpleQueryCommand(AbstractRepositoryConnector repositoryConnector, TaskRepository taskRepository, TaskDataManager taskDataManager, IRepositoryQuery query) {
        this.taskRepository = taskRepository;
        this.repositoryConnector = repositoryConnector;
        this.query = query;
        this.taskDataManager = taskDataManager;
        this.monitor = new CancelableProgressMonitor();
        this.tasks = new HashSet<NbTask>();
    }

    @Override
    public void execute() throws CoreException {
        final Logger log = Logger.getLogger(this.getClass().getName());
        if (log.isLoggable(Level.FINE)) {
            Map attrs = this.query.getAttributes();
            log.log(Level.FINE, "executing SimpleQueryCommand for query {0} on repository {1} with url \n\t{2} and parameters \n\t{3}", new Object[]{this.query.getSummary(), this.taskRepository.getUrl(), this.query.getUrl(), attrs != null ? attrs : null});
        }
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                try {
                    Accessor acc = Accessor.getInstance();
                    NbTask task = acc.getOrCreateTask(SimpleQueryCommand.this.taskRepository, taskData.getTaskId(), true);
                    SimpleQueryCommand.this.taskDataManager.putUpdatedTaskData(acc.getDelegate(task), taskData, true);
                    SimpleQueryCommand.this.tasks.add(task);
                }
                catch (CoreException ex) {
                    log.log(Level.INFO, "Cannot save task data " + taskData.getTaskId(), ex);
                }
            }
        };
        this.status = this.repositoryConnector.performQuery(this.taskRepository, this.query, collector, (ISynchronizationSession)new SynchronizationSession(), this.monitor);
        if (this.status != null && this.status.getSeverity() == 4) {
            if (this.status.getException() instanceof CoreException) {
                throw (CoreException)this.status.getException();
            }
            throw new CoreException(this.status);
        }
    }

    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public void cancel() {
        this.monitor.setCanceled(true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SimpleQueryCommand [repository=");
        sb.append(this.taskRepository.getUrl());
        sb.append(", summary=");
        sb.append(this.query.getSummary());
        sb.append(", url=");
        sb.append(this.query.getUrl());
        sb.append("]");
        return super.toString();
    }

    public Collection<NbTask> getTasks() {
        return this.tasks;
    }
}

