/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.queues;

import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.mercurial.ui.queues.QCreatePatchParameters;
import org.netbeans.modules.spellchecker.api.Spellchecker;
import org.netbeans.modules.versioning.util.StringSelector;
import org.netbeans.modules.versioning.util.TemplateSelector;
import org.netbeans.modules.versioning.util.UndoRedoSupport;
import org.netbeans.modules.versioning.util.common.CommitMessageMouseAdapter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CommitPanel
extends JPanel {
    private final QCreatePatchParameters parameters;
    private UndoRedoSupport um;
    final JCheckBox cbAuthor = new JCheckBox();
    final JComboBox cmbAuthor = new JComboBox();
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel messageLabel;
    final JTextArea messageTextArea = new JTextArea();
    private JLabel recentLabel;
    private JLabel templatesLabel;
    final JTextField txtPatchName = new JTextField();

    public CommitPanel(QCreatePatchParameters parameters, String commitMessage, String patchName) {
        this.parameters = parameters;
        this.initComponents();
        boolean skipTemplates = false;
        if (patchName != null && !patchName.isEmpty()) {
            this.txtPatchName.setText(patchName);
            this.txtPatchName.setEditable(false);
            skipTemplates = true;
        }
        this.messageTextArea.setColumns(60);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setRows(4);
        this.messageTextArea.setTabSize(4);
        this.messageTextArea.setWrapStyleWord(true);
        this.messageTextArea.setMinimumSize(new Dimension(100, 18));
        this.messageTextArea.getAccessibleContext().setAccessibleName(this.getMessage("ACSN_CommitForm_Message"));
        this.messageTextArea.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CommitForm_Message"));
        this.messageTextArea.addMouseListener((MouseListener)new CommitMessageMouseAdapter());
        Spellchecker.register((JTextComponent)this.messageTextArea);
        this.initCommitMessage(commitMessage, skipTemplates);
        this.cmbAuthor.setModel(parameters.createRecentUsersModel());
        this.initActions();
    }

    private void initCommitMessage(String commitMessage, boolean skipTemplates) {
        TemplateSelector ts = new TemplateSelector(this.parameters.getPreferences());
        if (commitMessage == null) {
            commitMessage = "";
        }
        this.messageTextArea.setText(commitMessage);
        if (ts.isAutofill() && !skipTemplates) {
            this.messageTextArea.setText(ts.getTemplate());
        } else {
            List<String> messages;
            String lastCommitMessage = this.parameters.getLastCanceledCommitMessage();
            if (lastCommitMessage.isEmpty() && new StringSelector.RecentMessageSelector(this.parameters.getPreferences()).isAutoFill() && (messages = this.parameters.getCommitMessages()).size() > 0) {
                lastCommitMessage = messages.get(0);
            }
            if (commitMessage.isEmpty() && !lastCommitMessage.isEmpty()) {
                this.messageTextArea.setText(lastCommitMessage);
            }
        }
        this.messageTextArea.selectAll();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.um == null) {
            this.um = UndoRedoSupport.register((JTextComponent)this.messageTextArea);
        }
    }

    @Override
    public void removeNotify() {
        if (!(this.getParent() != null && this.getParent().isShowing() || this.um == null)) {
            this.um.unregister();
            this.um = null;
        }
        super.removeNotify();
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.templatesLabel = this.parameters.getMessagesTemplateLink(this.messageTextArea);
        this.recentLabel = this.parameters.getRecentMessagesLink(this.messageTextArea);
        this.jLabel1 = new JLabel();
        this.messageLabel.setLabelFor(this.messageTextArea);
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.messageLabel.text"));
        this.messageTextArea.setColumns(20);
        this.messageTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.messageTextArea);
        Mnemonics.setLocalizedText((JLabel)this.templatesLabel, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.templatesLabel.text"));
        this.templatesLabel.setToolTipText(NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.templatesLabel.TTtext"));
        Mnemonics.setLocalizedText((JLabel)this.recentLabel, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.recentLabel.text"));
        this.recentLabel.setToolTipText(NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.recentLabel.TTtext"));
        this.jLabel1.setLabelFor(this.txtPatchName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.jLabel1.text"));
        this.jLabel1.setToolTipText(NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.jLabel1.TTtext"));
        this.txtPatchName.setText(NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.txtPatchName.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbAuthor, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.cbAuthor.text"));
        this.cbAuthor.setToolTipText(NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.cbAuthor.TTtext"));
        this.cmbAuthor.setEditable(true);
        this.cmbAuthor.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbAuthor).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmbAuthor, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtPatchName, -1, 400, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 501, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.messageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 382, Short.MAX_VALUE).addComponent(this.recentLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.templatesLabel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtPatchName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.messageLabel).addComponent(this.templatesLabel).addComponent(this.recentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 69, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbAuthor).addComponent(this.cmbAuthor, -2, -1, -2)).addContainerGap()));
    }

    private String getMessage(String msgKey) {
        return NbBundle.getMessage(CommitPanel.class, (String)msgKey);
    }

    private void initActions() {
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        Object action = this.recentLabel.getClientProperty("openAction");
        if (action instanceof Action) {
            inputMap.put(KeyStroke.getKeyStroke(82, 512, false), "messageHistory");
            actionMap.put("messageHistory", (Action)action);
        }
        if ((action = this.templatesLabel.getClientProperty("openAction")) instanceof Action) {
            inputMap.put(KeyStroke.getKeyStroke(76, 512, false), "messageTemplate");
            actionMap.put("messageTemplate", (Action)action);
        }
    }
}

