/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PatternTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.MatcherUtilities;

public class ConvertToSwitchPatternInstanceOf {
    public static ErrorDescription trivial(HintContext ctx) {
        TreePath parent = ctx.getPath().getParentPath();
        if (parent.getLeaf().getKind() == Tree.Kind.IF) {
            return null;
        }
        Tree ifPath = ctx.getPath().getLeaf();
        String expr0 = null;
        expr0 = ((TreePath)ctx.getVariables().get("$expr0")).getLeaf().toString();
        int matchVarIndex = 1;
        while (ifPath != null && ifPath.getKind() == Tree.Kind.IF) {
            IfTree it = (IfTree)ifPath;
            if (MatcherUtilities.matches((HintContext)ctx, (TreePath)new TreePath(ctx.getPath(), it.getCondition()), (String)("($expr" + ++matchVarIndex + " instanceof $typeI" + matchVarIndex + ")"), (boolean)true) && MatcherUtilities.matches((HintContext)ctx, (TreePath)new TreePath(ctx.getPath(), it.getThenStatement()), (String)("{ $typeV" + matchVarIndex + " $var" + matchVarIndex + " = ($typeC" + matchVarIndex + ") $expr" + matchVarIndex + "; $other" + matchVarIndex + "$;}"), (boolean)true)) {
                if (!((TreePath)ctx.getVariables().get("$expr" + matchVarIndex)).getLeaf().toString().equals(expr0)) {
                    return null;
                }
                for (TreePath tp : (Collection)ctx.getMultiVariables().get("$other" + matchVarIndex + "$")) {
                    if (tp.getLeaf().getKind() != Tree.Kind.BREAK && tp.getLeaf().getKind() != Tree.Kind.CONTINUE) continue;
                    return null;
                }
                TypeMirror typeI = ctx.getInfo().getTrees().getTypeMirror((TreePath)ctx.getVariables().get("$typeI" + matchVarIndex + ""));
                TypeMirror typeC = ctx.getInfo().getTrees().getTypeMirror((TreePath)ctx.getVariables().get("$typeC" + matchVarIndex + ""));
                if (!ctx.getInfo().getTypes().isSameType(typeI, typeC)) {
                    System.err.println("different types (" + typeI + ", " + typeC + ") in " + ctx.getInfo().getFileObject());
                    return null;
                }
            } else {
                return null;
            }
            ifPath = it.getElseStatement();
        }
        if (ifPath != null && ifPath.getKind() == Tree.Kind.BLOCK) {
            Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath(), true, Collections.emptySet()).toEditorFix();
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_ConvertToSwitchPatternInstanceOf(), (Fix[])new Fix[]{fix});
        }
        return null;
    }

    public static ErrorDescription patternMatchToSwitch(HintContext ctx) {
        TreePath parent = ctx.getPath().getParentPath();
        if (parent.getLeaf().getKind() == Tree.Kind.IF) {
            return null;
        }
        Tree ifPath = ctx.getPath().getLeaf();
        String expr0 = null;
        expr0 = ((TreePath)ctx.getVariables().get("$expr0")).getLeaf().toString();
        int matchVarIndex = 1;
        while (ifPath != null && ifPath.getKind() == Tree.Kind.IF) {
            IfTree it = (IfTree)ifPath;
            if (MatcherUtilities.matches((HintContext)ctx, (TreePath)new TreePath(ctx.getPath(), it.getCondition()), (String)("($expr" + ++matchVarIndex + " instanceof $typeI" + matchVarIndex + " $var" + matchVarIndex + ")"), (boolean)true) && MatcherUtilities.matches((HintContext)ctx, (TreePath)new TreePath(ctx.getPath(), it.getThenStatement()), (String)("{ $other" + matchVarIndex + "$;}"), (boolean)true)) {
                if (((Collection)ctx.getMultiVariables().get("$other" + matchVarIndex + "$")).isEmpty()) {
                    return null;
                }
                if (!((TreePath)ctx.getVariables().get("$expr" + matchVarIndex)).getLeaf().toString().equals(expr0)) {
                    return null;
                }
                for (TreePath tp : (Collection)ctx.getMultiVariables().get("$other" + matchVarIndex + "$")) {
                    if (tp.getLeaf().getKind() != Tree.Kind.BREAK && tp.getLeaf().getKind() != Tree.Kind.CONTINUE) continue;
                    return null;
                }
            } else {
                return null;
            }
            ifPath = it.getElseStatement();
        }
        Fix fix = new FixPatternMatchToSwitch(ctx.getInfo(), ctx.getPath(), false, Collections.emptySet()).toEditorFix();
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_ConvertToSwitchPatternInstanceOf(), (Fix[])new Fix[]{fix});
    }

    public static ErrorDescription switchPatternMatchToSwitchNull(HintContext ctx) {
        SwitchTree switchTree = (SwitchTree)ctx.getPath().getLeaf();
        if (!ConvertToSwitchPatternInstanceOf.isPatternMatch(switchTree)) {
            return null;
        }
        ExpressionTree expression = ((ParenthesizedTree)switchTree.getExpression()).getExpression();
        Tree parent = ctx.getPath().getParentPath().getLeaf();
        if (!(parent instanceof BlockTree)) {
            return null;
        }
        int indexOf = ((BlockTree)parent).getStatements().indexOf(switchTree) - 1;
        Tree ifTree = ((BlockTree)parent).getStatements().get(indexOf);
        if (!(ifTree instanceof IfTree && MatcherUtilities.matches((HintContext)ctx, (TreePath)new TreePath(ctx.getPath(), ((IfTree)ifTree).getCondition()), (String)"($expr0 == null)", (boolean)true) && ((TreePath)ctx.getVariables().get("$expr0")).getLeaf().toString().equals(expression.toString()))) {
            return null;
        }
        Fix fix = new FixSwitchPatternMatchToSwitchNull(ctx.getInfo(), ctx.getPath().getParentPath(), indexOf).toEditorFix();
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)ifTree, (String)Bundle.ERR_ConvertToSwitchPatternInstanceOf(), (Fix[])new Fix[]{fix});
    }

    public static boolean isPatternMatch(Tree node) {
        try {
            return node.getClass().getField("patternSwitch").getBoolean(node);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean isValidCaseTree(Tree tree) {
        return tree instanceof BlockTree || tree instanceof ExpressionStatementTree || tree instanceof ThrowTree;
    }

    private static final class FixSwitchPatternMatchToSwitchNull
    extends JavaFix {
        private final int indexOf;

        public FixSwitchPatternMatchToSwitchNull(CompilationInfo info, TreePath path, int indexOf) {
            super(info, path);
            this.indexOf = indexOf;
        }

        protected String getText() {
            return Bundle.FIX_ConvertToSwitchPatternInstanceOf();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath main = ctx.getPath();
            TreeMaker make = wc.getTreeMaker();
            LinkedList<IdentifierTree> caseNullLabel = new LinkedList<IdentifierTree>();
            SwitchTree switchTree = (SwitchTree)((BlockTree)main.getLeaf()).getStatements().get(this.indexOf + 1);
            Tree ifTree = ((BlockTree)main.getLeaf()).getStatements().get(this.indexOf);
            StatementTree thenStatement = ((IfTree)ifTree).getThenStatement();
            caseNullLabel.add(wc.getTreeMaker().Identifier((CharSequence)"null"));
            BlockTree blockTree = (BlockTree)thenStatement;
            BlockTree statementTree = blockTree.getStatements().size() == 1 && ConvertToSwitchPatternInstanceOf.isValidCaseTree(blockTree.getStatements().get(0)) ? (Tree)blockTree.getStatements().get(0) : blockTree;
            CaseTree caseMultipleSwitchPatterns = wc.getTreeMaker().CasePatterns(caseNullLabel, (Tree)statementTree);
            SwitchTree insertSwitchCase = make.insertSwitchCase(switchTree, 0, caseMultipleSwitchPatterns);
            wc.rewrite((Tree)switchTree, (Tree)insertSwitchCase);
            BlockTree removeBlockStatement = make.removeBlockStatement((BlockTree)main.getLeaf(), this.indexOf);
            wc.rewrite(main.getLeaf(), (Tree)removeBlockStatement);
        }
    }

    private static final class FixPatternMatchToSwitch
    extends JavaFix {
        private final boolean removeFirst;

        public FixPatternMatchToSwitch(CompilationInfo info, TreePath main, boolean removeFirst, Set<TreePath> replaceOccurrences) {
            super(info, main);
            this.removeFirst = removeFirst;
        }

        protected String getText() {
            return Bundle.FIX_ConvertToSwitchPatternInstanceOf();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath main = ctx.getPath();
            LinkedList<CaseTree> ctl = new LinkedList<CaseTree>();
            InstanceOfTree iot = null;
            Tree ifPath = ctx.getPath().getLeaf();
            int matchVarIndex = 1;
            ArrayList<Object> ifTrees = new ArrayList<Object>();
            while (ifPath != null && ifPath.getKind() == Tree.Kind.IF) {
                ++matchVarIndex;
                IfTree it = (IfTree)ifPath;
                ifTrees.add(it);
                ifPath = it.getElseStatement();
            }
            for (IfTree ifTree : ifTrees) {
                LinkedList<PatternTree> caseBindPattern = new LinkedList<PatternTree>();
                iot = (InstanceOfTree)((ParenthesizedTree)ifTree.getCondition()).getExpression();
                StatementTree bt = ifTree.getThenStatement();
                StatementTree thenBlock = this.removeFirst ? wc.getTreeMaker().removeBlockStatement((BlockTree)bt, 0) : bt;
                PatternTree pattern = iot.getPattern();
                caseBindPattern.add(pattern);
                BlockTree blockTree = (BlockTree)thenBlock;
                StatementTree statementTree = blockTree.getStatements().size() == 1 && ConvertToSwitchPatternInstanceOf.isValidCaseTree(blockTree.getStatements().get(0)) ? (Tree)blockTree.getStatements().get(0) : thenBlock;
                CaseTree caseMultipleSwitchPatterns = wc.getTreeMaker().CasePatterns(caseBindPattern, (Tree)statementTree);
                ctl.add(caseMultipleSwitchPatterns);
            }
            BlockTree elseTree = (BlockTree)ifPath;
            if (elseTree == null) {
                elseTree = wc.getTreeMaker().Block(new ArrayList(), false);
            }
            BlockTree blockTree = elseTree.getStatements().size() == 1 && ConvertToSwitchPatternInstanceOf.isValidCaseTree(elseTree.getStatements().get(0)) ? (Tree)elseTree.getStatements().get(0) : elseTree;
            CaseTree casePatterns = wc.getTreeMaker().Case(Collections.emptyList(), (Tree)blockTree);
            ctl.add(casePatterns);
            wc.rewrite((Tree)((IfTree)main.getLeaf()), (Tree)wc.getTreeMaker().Switch(iot.getExpression(), ctl));
        }
    }

    private static final class FixImpl
    extends JavaFix {
        private final boolean removeFirst;

        public FixImpl(CompilationInfo info, TreePath main, boolean removeFirst, Set<TreePath> replaceOccurrences) {
            super(info, main);
            this.removeFirst = removeFirst;
        }

        protected String getText() {
            return Bundle.FIX_ConvertToSwitchPatternInstanceOf();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath main = ctx.getPath();
            LinkedList<CaseTree> ctl = new LinkedList<CaseTree>();
            Tree ifPath = ctx.getPath().getLeaf();
            int matchVarIndex = 1;
            ArrayList<IfTree> ifTrees = new ArrayList<IfTree>();
            while (ifPath != null && ifPath.getKind() == Tree.Kind.IF) {
                ++matchVarIndex;
                IfTree it = (IfTree)ifPath;
                ifTrees.add(it);
                ifPath = it.getElseStatement();
            }
            InstanceOfTree iot = null;
            for (IfTree ifTree : ifTrees) {
                LinkedList<Tree> caseBindPattern = new LinkedList<Tree>();
                iot = (InstanceOfTree)((ParenthesizedTree)ifTree.getCondition()).getExpression();
                StatementTree bt = ifTree.getThenStatement();
                VariableTree var = (VariableTree)((BlockTree)bt).getStatements().get(0);
                StatementTree thenBlock = this.removeFirst ? wc.getTreeMaker().removeBlockStatement((BlockTree)bt, 0) : bt;
                caseBindPattern.add(wc.getTreeMaker().BindingPattern(wc.getTreeMaker().Variable(wc.getTreeMaker().Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)var.getName().toString(), iot.getType(), null)));
                BlockTree blockTree = (BlockTree)thenBlock;
                StatementTree statementTree = blockTree.getStatements().size() == 1 && ConvertToSwitchPatternInstanceOf.isValidCaseTree(blockTree.getStatements().get(0)) ? (Tree)blockTree.getStatements().get(0) : thenBlock;
                CaseTree caseMultipleSwitchPatterns = wc.getTreeMaker().CasePatterns(caseBindPattern, (Tree)statementTree);
                ctl.add(caseMultipleSwitchPatterns);
            }
            BlockTree elseTree = (BlockTree)ifPath;
            if (elseTree == null) {
                elseTree = wc.getTreeMaker().Block(new ArrayList(), false);
            }
            BlockTree defaultTree = elseTree.getStatements().size() == 1 && ConvertToSwitchPatternInstanceOf.isValidCaseTree(elseTree.getStatements().get(0)) ? (Tree)elseTree.getStatements().get(0) : elseTree;
            CaseTree caseMultipleSwitchPatterns = wc.getTreeMaker().Case(Collections.emptyList(), (Tree)defaultTree);
            ctl.add(caseMultipleSwitchPatterns);
            wc.rewrite((Tree)((IfTree)main.getLeaf()), (Tree)wc.getTreeMaker().Switch(iot.getExpression(), ctl));
        }
    }
}

