/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.java.hints.introduce.Bundle;
import org.netbeans.modules.java.hints.introduce.MemberSearchResult;
import org.netbeans.modules.java.hints.introduce.MemberValidator;
import org.netbeans.modules.java.hints.introduce.NameChangeSupport;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class IntroduceFieldPanel
extends JPanel
implements ChangeListener {
    public static final int FIELD = 0;
    public static final int CONSTANT = 1;
    public static final int VARIABLE = 2;
    public static final int INIT_METHOD = 1;
    public static final int INIT_FIELD = 2;
    public static final int INIT_CONSTRUCTORS = 4;
    private static final int ACCESS_PUBLIC = 1;
    private static final int ACCESS_PROTECTED = 2;
    private static final int ACCESS_DEFAULT = 3;
    private static final int ACCESS_PRIVATE = 4;
    private int[] allowInitMethods;
    private boolean allowFinalInCurrentMethod;
    private JButton btnOk;
    private int elementType;
    private Preferences preferences;
    private boolean allowAccess = true;
    private NameChangeSupport changeSupport;
    private NotificationLineSupport notifier;
    private boolean refactorExisting;
    private JRadioButton accessDefault;
    private ButtonGroup accessGroup;
    private JRadioButton accessPrivate;
    private JRadioButton accessProtected;
    private JRadioButton accessPublic;
    private JCheckBox checkRefactorExisting;
    private JCheckBox declareFinal;
    private JRadioButton initConstructors;
    private JRadioButton initField;
    private JRadioButton initMethod;
    private ButtonGroup initilizeIn;
    private JLabel lblAccess;
    private JLabel lblInitializeIn;
    private JLabel lblName;
    private JTextField name;
    private JCheckBox replaceAll;
    private String fieldNameTest;
    private Integer initializeInTest;
    private Boolean replaceAllTest;
    private Set<Modifier> accessTest;
    private Boolean declareFinalTest;

    public IntroduceFieldPanel(String name, int[] allowInitMethods, int numOccurrences, boolean allowFinalInCurrentMethod, boolean variableRewrite, int type, String prefNode, JButton btnOk) {
        this.elementType = type;
        this.btnOk = btnOk;
        this.initComponents();
        this.name.setText(name);
        if (name != null && name.trim().length() > 0 && !variableRewrite) {
            this.name.setCaretPosition(name.length());
            this.name.setSelectionStart(0);
            this.name.setSelectionEnd(name.length());
        }
        if (variableRewrite) {
            this.name.setEditable(false);
        }
        this.allowInitMethods = allowInitMethods;
        this.replaceAll.setEnabled(numOccurrences > 1);
        this.allowFinalInCurrentMethod = allowFinalInCurrentMethod;
        Preferences pref = this.preferences = NbPreferences.forModule(IntroduceFieldPanel.class).node(prefNode);
        if (numOccurrences == 1) {
            this.replaceAll.setEnabled(false);
            this.replaceAll.setSelected(false);
        } else {
            this.replaceAll.setEnabled(true);
            this.replaceAll.setText(this.replaceAll.getText() + " (" + numOccurrences + ")");
            this.replaceAll.setSelected(pref.getBoolean("replaceAll", true));
        }
        if (this.isConstant()) {
            this.declareFinal.setEnabled(false);
            this.declareFinal.setSelected(true);
        } else {
            this.declareFinal.setSelected(pref.getBoolean("declareFinal", true));
        }
        if (this.supportsAccess()) {
            int accessModifier = pref.getInt("accessModifier", 4);
            switch (accessModifier) {
                case 1: {
                    this.accessPublic.setSelected(true);
                    break;
                }
                case 2: {
                    this.accessProtected.setSelected(true);
                    break;
                }
                case 3: {
                    this.accessDefault.setSelected(true);
                    break;
                }
                case 4: {
                    this.accessPrivate.setSelected(true);
                }
            }
        } else {
            this.lblAccess.setVisible(false);
            this.accessPublic.setVisible(false);
            this.accessProtected.setVisible(false);
            this.accessDefault.setVisible(false);
            this.accessPrivate.setVisible(false);
        }
        this.changeSupport = new FieldNameSupport();
        this.changeSupport.setChangeListener(this);
        this.resetAccess();
        this.resetInit();
        this.adjustInitializeIn();
        this.adjustFinal();
    }

    public void setTarget(TreePathHandle target) {
        this.changeSupport.setTarget(target);
    }

    public void setValidator(MemberValidator v) {
        this.changeSupport.setValidator(v);
    }

    public void setNotifier(NotificationLineSupport notifier) {
        this.notifier = notifier;
    }

    private void resetInit() {
        if (this.supportsInit()) {
            int init = this.preferences.getInt("initMethod", 1);
            switch (init) {
                case 2: {
                    this.initField.setSelected(true);
                    break;
                }
                case 4: {
                    this.initConstructors.setSelected(true);
                    break;
                }
                default: {
                    this.initMethod.setSelected(true);
                    break;
                }
            }
        } else {
            this.lblInitializeIn.setVisible(false);
            this.initField.setVisible(false);
            this.initConstructors.setVisible(false);
            this.initMethod.setVisible(false);
            this.initMethod.setSelected(false);
        }
    }

    private void resetAccess() {
        if (this.supportsAccess()) {
            int accessModifier = this.preferences.getInt("accessModifier", 4);
            switch (accessModifier) {
                case 1: {
                    this.accessPublic.setSelected(true);
                    break;
                }
                case 2: {
                    this.accessProtected.setSelected(true);
                    break;
                }
                case 3: {
                    this.accessDefault.setSelected(true);
                    break;
                }
                case 4: {
                    this.accessPrivate.setSelected(true);
                }
            }
        } else {
            this.lblAccess.setVisible(false);
            this.accessPublic.setVisible(false);
            this.accessProtected.setVisible(false);
            this.accessDefault.setVisible(false);
            this.accessPrivate.setVisible(false);
        }
    }

    public void setAllowAccess(boolean allow) {
        this.allowAccess = allow;
        this.resetAccess();
        this.resetInit();
    }

    private boolean isConstant() {
        return this.elementType == 1;
    }

    private boolean supportsInit() {
        return this.allowAccess && this.elementType == 0;
    }

    private boolean supportsAccess() {
        return this.allowAccess && this.elementType != 2;
    }

    private Preferences getPreferences() {
        return this.preferences;
    }

    private void adjustInitializeIn() {
        if (!this.supportsInit()) {
            return;
        }
        int initIn = this.allowInitMethods != null ? this.allowInitMethods[this.replaceAll.isSelected() ? 1 : 0] : 2;
        boolean oldInitMethod = this.initMethod.isSelected();
        this.initMethod.setEnabled((initIn & 1) != 0);
        this.initField.setEnabled((initIn & 2) != 0);
        this.initConstructors.setEnabled((initIn & 4) != 0);
        if (!this.initMethod.isEnabled() && this.initMethod.isSelected()) {
            if (this.initField.isEnabled()) {
                this.initField.setSelected(true);
            } else {
                this.initConstructors.setSelected(true);
            }
        } else if (!this.initField.isEnabled() && this.initField.isSelected()) {
            if (this.initMethod.isEnabled()) {
                this.initMethod.setSelected(true);
            } else {
                this.initConstructors.setSelected(true);
            }
        } else if (!this.initConstructors.isEnabled() && this.initConstructors.isSelected()) {
            if (this.initMethod.isEnabled()) {
                this.initMethod.setSelected(true);
            } else {
                this.initField.setSelected(true);
            }
        }
        if (oldInitMethod != this.initMethod.isSelected()) {
            this.adjustFinal();
        }
    }

    private void adjustFinal() {
        if (this.isConstant()) {
            return;
        }
        this.declareFinal.setEnabled(!this.initMethod.isSelected() || this.allowFinalInCurrentMethod);
        if (this.initMethod.isSelected() && !this.allowFinalInCurrentMethod) {
            this.declareFinal.setSelected(false);
        }
    }

    public boolean isRefactorExisting() {
        return this.checkRefactorExisting.isEnabled() && this.checkRefactorExisting.isSelected();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.btnOk.setEnabled(this.changeSupport.isValid());
    }

    String getDefaultErrorMessage(String inputText) {
        return "'" + inputText + "' is not a valid identifier";
    }

    private void initComponents() {
        this.initilizeIn = new ButtonGroup();
        this.accessGroup = new ButtonGroup();
        this.lblName = new JLabel();
        this.name = new JTextField();
        this.replaceAll = new JCheckBox();
        this.declareFinal = new JCheckBox();
        this.lblInitializeIn = new JLabel();
        this.initMethod = new JRadioButton();
        this.initField = new JRadioButton();
        this.initConstructors = new JRadioButton();
        this.lblAccess = new JLabel();
        this.accessPublic = new JRadioButton();
        this.accessProtected = new JRadioButton();
        this.accessDefault = new JRadioButton();
        this.accessPrivate = new JRadioButton();
        this.checkRefactorExisting = new JCheckBox();
        this.lblName.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_Name"));
        this.name.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.replaceAll, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_ReplaceAll"));
        this.replaceAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.replaceAll.setMargin(new Insets(0, 0, 0, 0));
        this.replaceAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroduceFieldPanel.this.replaceAllActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.declareFinal, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_DeclareFinal"));
        this.declareFinal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.declareFinal.setMargin(new Insets(0, 0, 0, 0));
        this.declareFinal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroduceFieldPanel.this.declareFinalActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblInitializeIn, (String)NbBundle.getMessage(IntroduceFieldPanel.class, (String)"IntroduceFieldPanel.lblInitializeIn.text"));
        this.initilizeIn.add(this.initMethod);
        Mnemonics.setLocalizedText((AbstractButton)this.initMethod, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_CurrentMethod"));
        this.initMethod.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.initMethod.setMargin(new Insets(0, 0, 0, 0));
        this.initMethod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroduceFieldPanel.this.initMethodActionPerformed(evt);
            }
        });
        this.initilizeIn.add(this.initField);
        Mnemonics.setLocalizedText((AbstractButton)this.initField, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_Field"));
        this.initField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.initField.setMargin(new Insets(0, 0, 0, 0));
        this.initField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroduceFieldPanel.this.initFieldActionPerformed(evt);
            }
        });
        this.initilizeIn.add(this.initConstructors);
        Mnemonics.setLocalizedText((AbstractButton)this.initConstructors, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_Constructors"));
        this.initConstructors.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.initConstructors.setMargin(new Insets(0, 0, 0, 0));
        this.initConstructors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroduceFieldPanel.this.initConstructorsActionPerformed(evt);
            }
        });
        this.lblAccess.setLabelFor(this.accessPublic);
        Mnemonics.setLocalizedText((JLabel)this.lblAccess, (String)NbBundle.getMessage(IntroduceFieldPanel.class, (String)"LBL_Access"));
        this.accessGroup.add(this.accessPublic);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPublic, (String)NbBundle.getMessage(IntroduceFieldPanel.class, (String)"LBL_public"));
        this.accessPublic.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessPublic.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessProtected);
        Mnemonics.setLocalizedText((AbstractButton)this.accessProtected, (String)NbBundle.getMessage(IntroduceFieldPanel.class, (String)"LBL_protected"));
        this.accessProtected.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessProtected.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessDefault);
        Mnemonics.setLocalizedText((AbstractButton)this.accessDefault, (String)NbBundle.getMessage(IntroduceFieldPanel.class, (String)"LBL_Default"));
        this.accessDefault.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessDefault.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessPrivate);
        this.accessPrivate.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPrivate, (String)NbBundle.getMessage(IntroduceFieldPanel.class, (String)"LBL_private"));
        this.accessPrivate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessPrivate.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.checkRefactorExisting, (String)NbBundle.getMessage(IntroduceFieldPanel.class, (String)"IntroduceFieldPanel.checkRefactorExisting.text"));
        this.checkRefactorExisting.setEnabled(false);
        this.checkRefactorExisting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroduceFieldPanel.this.checkRefactorExistingActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAccess).addComponent(this.lblName)).addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.name, -1, 425, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.accessPublic).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessProtected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessPrivate)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.declareFinal).addComponent(this.replaceAll).addGroup(layout.createSequentialGroup().addComponent(this.lblInitializeIn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.initConstructors).addComponent(this.initField).addComponent(this.initMethod))).addComponent(this.checkRefactorExisting)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.name, -2, -1, -2).addComponent(this.lblName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblAccess).addComponent(this.accessPublic).addComponent(this.accessProtected).addComponent(this.accessDefault).addComponent(this.accessPrivate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.declareFinal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblInitializeIn).addGroup(layout.createSequentialGroup().addComponent(this.initMethod).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.initField).addGap(7, 7, 7).addComponent(this.initConstructors))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkRefactorExisting).addContainerGap(20, Short.MAX_VALUE)));
        this.lblName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Name"));
        this.replaceAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_ReplaceAllOccurences"));
        this.declareFinal.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_DeclareFinal"));
        this.initMethod.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_CurrentMethod"));
        this.initField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Field"));
        this.initConstructors.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Constructors"));
        this.accessPublic.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Public"));
        this.accessProtected.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Protected"));
        this.accessDefault.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Default"));
        this.accessPrivate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Private"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Dialog"));
    }

    private void declareFinalActionPerformed(ActionEvent evt) {
    }

    private void initConstructorsActionPerformed(ActionEvent evt) {
        this.adjustFinal();
    }

    private void initFieldActionPerformed(ActionEvent evt) {
        this.adjustFinal();
    }

    private void initMethodActionPerformed(ActionEvent evt) {
        this.adjustFinal();
    }

    private void replaceAllActionPerformed(ActionEvent evt) {
        this.adjustInitializeIn();
    }

    private void checkRefactorExistingActionPerformed(ActionEvent evt) {
        if (this.checkRefactorExisting.isEnabled()) {
            this.refactorExisting = this.checkRefactorExisting.isSelected();
        }
    }

    public String getFieldName() {
        if (this.fieldNameTest != null) {
            return this.fieldNameTest;
        }
        return this.name.getText();
    }

    public int getInitializeIn() {
        int ret;
        if (this.initializeInTest != null) {
            return this.initializeInTest;
        }
        if (!this.allowAccess) {
            return 2;
        }
        if (this.initMethod.isSelected()) {
            ret = 1;
        } else if (this.initField.isSelected()) {
            ret = 2;
        } else if (this.initConstructors.isSelected()) {
            ret = 4;
        } else {
            if (this.isConstant()) {
                return 2;
            }
            throw new IllegalStateException();
        }
        this.getPreferences().putInt("initMethod", ret);
        return ret;
    }

    public boolean isReplaceAll() {
        if (this.replaceAllTest != null) {
            return this.replaceAllTest;
        }
        boolean ret = this.replaceAll.isSelected();
        this.getPreferences().putBoolean("replaceAll", ret);
        return ret;
    }

    public Set<Modifier> getAccess() {
        Set<Modifier> set;
        int val;
        if (this.accessTest != null) {
            return this.accessTest;
        }
        if (!this.allowAccess) {
            return Collections.emptySet();
        }
        if (this.accessPublic.isSelected()) {
            val = 1;
            set = EnumSet.of(Modifier.PUBLIC);
        } else if (this.accessProtected.isSelected()) {
            val = 2;
            set = EnumSet.of(Modifier.PROTECTED);
        } else if (this.accessDefault.isSelected()) {
            val = 3;
            set = Collections.emptySet();
        } else {
            val = 4;
            set = EnumSet.of(Modifier.PRIVATE);
        }
        this.getPreferences().putInt("accessModifier", val);
        return set;
    }

    public boolean isDeclareFinal() {
        if (this.declareFinalTest != null) {
            return this.declareFinalTest;
        }
        if (this.isConstant()) {
            return true;
        }
        boolean ret = this.declareFinal.isSelected();
        this.getPreferences().putBoolean("declareFinal", ret);
        return ret;
    }

    void setAccess(Set<Modifier> access) {
        this.accessTest = access;
    }

    void setDeclareFinal(Boolean declareFinal) {
        this.declareFinalTest = declareFinal;
    }

    void setFieldName(String fieldName) {
        this.fieldNameTest = fieldName;
    }

    void setInitializeIn(Integer initializeIn) {
        this.initializeInTest = initializeIn;
    }

    void setReplaceAll(Boolean replaceAll) {
        this.replaceAllTest = replaceAll;
    }

    private class FieldNameSupport
    extends NameChangeSupport {
        public FieldNameSupport() {
            super(IntroduceFieldPanel.this.name);
        }

        @Override
        protected boolean updateUI(MemberSearchResult result) {
            if (IntroduceFieldPanel.this.notifier == null) {
                return false;
            }
            boolean ok = false;
            boolean refactor = false;
            if (result == null) {
                ok = true;
            } else if (result.getConflictingKind() != null) {
                if (result.getConflictingKind() != ElementKind.FIELD) {
                    IntroduceFieldPanel.this.notifier.setErrorMessage(Bundle.ERR_LocalVarOrParameterHidden());
                } else {
                    IntroduceFieldPanel.this.notifier.setErrorMessage(Bundle.ERR_ConflictingField());
                }
                ok = false;
            } else if (result.getOverriden() != null) {
                IntroduceFieldPanel.this.notifier.setWarningMessage(Bundle.WARN_InheritedFieldHidden());
            } else if (result.getShadowed() != null) {
                IntroduceFieldPanel.this.notifier.setInformationMessage(Bundle.INFO_FieldHidden());
                refactor = true;
            } else {
                ok = true;
            }
            if (ok) {
                IntroduceFieldPanel.this.notifier.clearMessages();
            }
            if (refactor) {
                IntroduceFieldPanel.this.checkRefactorExisting.setEnabled(true);
                IntroduceFieldPanel.this.checkRefactorExisting.setSelected(refactor);
            } else {
                IntroduceFieldPanel.this.checkRefactorExisting.setEnabled(false);
                IntroduceFieldPanel.this.checkRefactorExisting.setSelected(false);
            }
            return result == null || !result.isConflicting();
        }

        @Override
        protected void notifyNameError(String msg) {
            if (IntroduceFieldPanel.this.notifier != null) {
                IntroduceFieldPanel.this.notifier.setErrorMessage(msg);
                IntroduceFieldPanel.this.btnOk.setEnabled(false);
            }
        }
    }
}

