/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.CaseTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.queries.CompilerOptionsQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class DifferentCaseKindsFix
implements ErrorRule<Void> {
    private static final int SWITCH_RULE_PREVIEW_JDK_VERSION = 13;
    private static final Set<String> ERROR_CODES = new HashSet<String>(Arrays.asList("compiler.err.switch.mixing.case.types"));

    public Set<String> getCodes() {
        return Collections.unmodifiableSet(ERROR_CODES);
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        if (Utilities.isJDKVersionLower(13) && !CompilerOptionsQuery.getOptions((FileObject)info.getFileObject()).getArguments().contains("--enable-preview")) {
            return null;
        }
        TreePath parentPath = treePath.getParentPath();
        if (parentPath.getLeaf() instanceof CaseTree) {
            parentPath = parentPath.getParentPath();
        }
        List<? extends CaseTree> caseTrees = null;
        boolean flag = false;
        if (parentPath.getLeaf().getKind() == Tree.Kind.SWITCH_EXPRESSION) {
            caseTrees = ((SwitchExpressionTree)parentPath.getLeaf()).getCases();
        } else {
            flag = true;
            caseTrees = ((SwitchTree)parentPath.getLeaf()).getCases();
        }
        boolean completesNormally = false;
        boolean wasDefault = false;
        boolean wasEmpty = false;
        for (CaseTree caseTree : caseTrees) {
            if (caseTree.getStatements() == null && caseTree.getBody() == null) {
                return null;
            }
            if (!flag || caseTree.getStatements() == null) continue;
            if (completesNormally) {
                if (!wasEmpty) {
                    return null;
                }
                if (wasDefault) {
                    return null;
                }
                if (!wasDefault && caseTree.getExpression() == null) {
                    return null;
                }
            }
            completesNormally = Utilities.completesNormally(info, new TreePath(treePath.getParentPath(), caseTree));
            wasDefault = caseTree.getExpression() == null;
            wasEmpty = caseTree.getStatements().isEmpty();
        }
        return Collections.singletonList(new FixImpl(info, treePath).toEditorFix());
    }

    public String getId() {
        return DifferentCaseKindsFix.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(DifferentCaseKindsFix.class, (String)"FIX_DifferentCaseKinds");
    }

    public String getDescription() {
        return NbBundle.getMessage(DifferentCaseKindsFix.class, (String)"FIX_DifferentCaseKinds");
    }

    public void cancel() {
    }

    private static final class FixImpl
    extends JavaFix {
        CompilationInfo info;
        TreePath path;

        public FixImpl(CompilationInfo info, TreePath path) {
            super(info, path);
            this.info = info;
            this.path = path;
        }

        protected String getText() {
            return NbBundle.getMessage(DifferentCaseKindsFix.class, (String)"FIX_DifferentCaseKinds");
        }

        public String toDebugString() {
            return NbBundle.getMessage(DifferentCaseKindsFix.class, (String)"FIX_DifferentCaseKinds");
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            TreePath tp = ctx.getPath();
            TreePath switchPath = tp.getParentPath();
            if (switchPath.getLeaf() instanceof CaseTree) {
                switchPath = switchPath.getParentPath();
            }
            Tree switchBlock = switchPath.getLeaf();
            Utilities.performRewriteRuleSwitch(ctx, tp, switchBlock, false);
        }
    }
}

