/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.util.TreePath;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.util.NbBundle;

public class EqualsHint {
    private static final boolean ERASURE_PREFS_DEFAULT = true;
    private static final String ERASURE_PREFS_KEY = "eguals-hint-erasure";

    public static ErrorDescription arrayEquals(HintContext ctx) {
        TreePath arr = (TreePath)ctx.getVariables().get("$arr");
        TypeMirror tm = ctx.getInfo().getTrees().getTypeMirror(arr);
        if (tm == null || tm.getKind() != TypeKind.ARRAY) {
            return null;
        }
        String fixArraysDisplayName = NbBundle.getMessage(EqualsHint.class, (String)"FIX_ReplaceWithArraysEquals");
        Fix arrays = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixArraysDisplayName, (TreePath)ctx.getPath(), (String)"java.util.Arrays.equals($obj, $arr)");
        String fixInstanceDisplayName = NbBundle.getMessage(EqualsHint.class, (String)"FIX_ReplaceWithInstanceEquals");
        Fix instance = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixInstanceDisplayName, (TreePath)ctx.getPath(), (String)"$obj == $arr");
        String displayName = NbBundle.getMessage(EqualsHint.class, (String)"ERR_ARRAY_EQUALS");
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[]{arrays, instance});
    }

    public static ErrorDescription incompatibleEquals(HintContext ctx) {
        boolean castable;
        TypeMirror thsType;
        TreePath ths = (TreePath)ctx.getVariables().get("$this");
        TreePath par = (TreePath)ctx.getVariables().get("$par");
        if (ths != null) {
            thsType = ctx.getInfo().getTrees().getTypeMirror(ths);
        } else {
            TreePath cls;
            for (cls = ctx.getPath(); cls != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)cls.getLeaf().getKind()); cls = cls.getParentPath()) {
            }
            if (cls == null) {
                return null;
            }
            thsType = ctx.getInfo().getTrees().getTypeMirror(cls);
        }
        if (thsType == null || thsType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        TypeMirror parType = ctx.getInfo().getTrees().getTypeMirror(par);
        if (parType == null || parType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        if (ctx.getPreferences().getBoolean(ERASURE_PREFS_KEY, true)) {
            Types types = ctx.getInfo().getTypes();
            thsType = types.erasure(thsType);
            parType = types.erasure(parType);
        }
        boolean bl = castable = ctx.getInfo().getTypeUtilities().isCastable(thsType, parType) || ctx.getInfo().getTypeUtilities().isCastable(parType, thsType);
        if (castable) {
            return null;
        }
        String displayName = NbBundle.getMessage(EqualsHint.class, (String)"ERR_INCOMPATIBLE_EQUALS");
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
    }
}

