/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.doc.api.JsDocumentationSupport;
import org.netbeans.modules.javascript2.doc.spi.DocParameter;
import org.netbeans.modules.javascript2.doc.spi.JsComment;
import org.netbeans.modules.javascript2.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.model.JsFunctionImpl;
import org.netbeans.modules.javascript2.model.JsObjectImpl;
import org.netbeans.modules.javascript2.model.ModelElementFactory;
import org.netbeans.modules.javascript2.model.api.JsElement;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.JsWith;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.types.api.DeclarationScope;
import org.netbeans.modules.javascript2.types.api.Identifier;
import org.netbeans.modules.javascript2.types.spi.ParserResult;
import org.openide.filesystems.FileObject;

public class OccurrenceBuilder {
    private final Map<String, Map<OffsetRange, Item>> holder = new HashMap<String, Map<OffsetRange, Item>>();
    private final ParserResult parserResult;

    public OccurrenceBuilder(ParserResult parserResult) {
        this.parserResult = parserResult;
    }

    public void addOccurrence(String name, OffsetRange range, DeclarationScope whereUsed, JsObject currentParent, JsWith inWith, boolean isFunction, boolean leftSite) {
        Map<OffsetRange, Item> items = this.holder.get(name);
        if (items == null) {
            items = new HashMap<OffsetRange, Item>(1);
            this.holder.put(name, items);
        }
        if (!items.containsKey(range)) {
            items.put(range, new Item(range, whereUsed, currentParent, inWith, isFunction, leftSite));
        }
    }

    public void processOccurrences(JsObject global) {
        for (Map.Entry<String, Map<OffsetRange, Item>> entry : this.holder.entrySet()) {
            String name = entry.getKey();
            Map<OffsetRange, Item> items = entry.getValue();
            for (Item item : items.values()) {
                this.processOccurrence(global, name, item);
            }
        }
        this.holder.clear();
        Collection<Identifier> usedInJsHintInline = ModelUtils.getDefinedGlobal(this.parserResult.getSnapshot(), global.getOffset());
        for (Identifier iden : usedInJsHintInline) {
            JsObject object = global.getProperty(iden.getName());
            if (object == null) continue;
            object.addOccurrence(iden.getOffsetRange());
        }
    }

    private void processOccurrence(JsObject global, String name, Item item) {
        JsObject property = null;
        JsObject parameter = null;
        JsObject parent = item.currentParent;
        if (!(parent instanceof JsWith) && !(parent.getParent() instanceof JsWith)) {
            for (DeclarationScope scope = item.scope; scope != null && property == null && parameter == null; scope = scope.getParentScope()) {
                if (scope instanceof JsFunction) {
                    parameter = ((JsFunction)scope).getParameter(name);
                }
                property = ((JsObject)scope).getProperty(name);
            }
            if (parameter != null) {
                if (property == null) {
                    property = parameter;
                } else if (property.getJSKind() != JsElement.Kind.VARIABLE) {
                    property = parameter;
                }
            }
        } else {
            if (!(parent instanceof JsWith) && parent.getParent() instanceof JsWith) {
                parent = parent.getParent();
            }
            property = parent.getProperty(name);
        }
        if (!(parent instanceof JsWith) && property == null) {
            JsObject possibleParent = parent;
            while (property == null && possibleParent != null) {
                property = possibleParent.getProperty(name);
                if ((possibleParent = possibleParent.getParent()) == null || !possibleParent.equals(possibleParent.getParent())) continue;
            }
        }
        if (property != null) {
            this.addDocNameOccurence((JsObjectImpl)property);
            this.addDocTypesOccurence((JsObjectImpl)property);
            ((JsObjectImpl)property).addOccurrence(item.range);
        } else {
            Identifier nameIden = ModelElementFactory.create(this.parserResult, name, item.range.getStart(), item.range.getEnd());
            if (nameIden != null) {
                if (item.currentWith != null) {
                    JsWith with = item.currentWith;
                    property = with.getProperty(name);
                    if (property != null) {
                        ((JsObjectImpl)property).addOccurrence(item.range);
                    } else {
                        this.createNewProperty(with, item, nameIden);
                    }
                } else {
                    if (!(parent instanceof JsWith)) {
                        parent = global;
                    }
                    this.createNewProperty(parent, item, nameIden);
                }
            }
        }
    }

    private void createNewProperty(JsObject parent, Item item, Identifier nameIden) {
        JsObjectImpl newObject;
        if (!item.isFunction) {
            newObject = new JsObjectImpl(parent, nameIden, nameIden.getOffsetRange(), item.leftSite, this.parserResult.getSnapshot().getMimeType(), null);
        } else {
            FileObject fo = this.parserResult.getSnapshot().getSource().getFileObject();
            newObject = new JsFunctionImpl(fo, parent, nameIden, Collections.emptyList(), this.parserResult.getSnapshot().getMimeType(), null);
        }
        newObject.addOccurrence(nameIden.getOffsetRange());
        parent.addProperty(nameIden.getName(), newObject);
        this.addDocNameOccurence(newObject);
        this.addDocTypesOccurence(newObject);
    }

    private void addDocNameOccurence(JsObjectImpl jsObject) {
        JsDocumentationHolder holder = JsDocumentationSupport.getDocumentationHolder((ParserResult)this.parserResult);
        JsComment comment = holder.getCommentForOffset(jsObject.getOffset(), holder.getCommentBlocks());
        if (comment != null) {
            for (DocParameter docParameter : comment.getParameters()) {
                Identifier paramName = docParameter.getParamName();
                String name = docParameter.getParamName() == null ? "" : docParameter.getParamName().getName();
                if (!name.equals(jsObject.getName())) continue;
                jsObject.addOccurrence(paramName.getOffsetRange());
            }
        }
    }

    private void addDocTypesOccurence(JsObjectImpl jsObject) {
        JsDocumentationHolder holder = JsDocumentationSupport.getDocumentationHolder((ParserResult)this.parserResult);
        if (holder.getOccurencesMap().containsKey(jsObject.getName())) {
            for (OffsetRange offsetRange : (List)holder.getOccurencesMap().get(jsObject.getName())) {
                jsObject.addOccurrence(offsetRange);
            }
        }
    }

    private static class Item {
        final DeclarationScope scope;
        final JsObject currentParent;
        final JsWith currentWith;
        final boolean isFunction;
        final boolean leftSite;
        final OffsetRange range;

        public Item(OffsetRange range, DeclarationScope scope, JsObject currentParent, JsWith currentWith, boolean isFunction, boolean leftSite) {
            this.scope = scope;
            this.currentParent = currentParent;
            this.isFunction = isFunction;
            this.leftSite = leftSite;
            this.range = range;
            this.currentWith = currentWith;
        }
    }
}

