/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SmartSteppingCallback;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SmartSteppingImpl
extends SmartSteppingCallback
implements PropertyChangeListener {
    private Set exclusionPatterns = new HashSet();
    private SmartSteppingFilter smartSteppingFilter;
    private SourcePath engineContext;

    public void initFilter(SmartSteppingFilter f) {
        this.smartSteppingFilter = f;
    }

    public boolean stopHere(ContextProvider lookupProvider, JPDAThread thread, SmartSteppingFilter f) {
        String n1;
        String className = thread.getClassName();
        if (className == null) {
            return false;
        }
        SourcePath ectx = this.getEngineContext(lookupProvider);
        boolean b = ectx.sourceAvailable(thread, null, false);
        if (b) {
            return true;
        }
        try {
            String sourcePath = thread.getSourcePath(null);
            sourcePath = sourcePath.replace(File.pathSeparatorChar, '/');
            FileObject sourceFO = GlobalPathRegistry.getDefault().findResource(sourcePath);
            if (sourceFO != null) {
                Set cpaths = GlobalPathRegistry.getDefault().getPaths("classpath/source");
                FileObject rootFO = null;
                for (ClassPath cp : cpaths) {
                    FileObject fo = cp.findOwnerRoot(sourceFO);
                    if (fo == null) continue;
                    if (rootFO == null) {
                        rootFO = fo;
                        continue;
                    }
                    rootFO = null;
                    break;
                }
                if (rootFO != null) {
                    File file = FileUtil.toFile(rootFO);
                    String sourceRoot = file.getAbsolutePath();
                    String[] additionalSourceRoots = ectx.getAdditionalSourceRoots();
                    String[] originalSourceRoots = ectx.getOriginalSourceRoots();
                    if (Arrays.asList(additionalSourceRoots).contains(sourceRoot)) {
                        return false;
                    }
                    if (Arrays.asList(originalSourceRoots).contains(sourceRoot)) {
                        return false;
                    }
                    String[] sourceRoots = ectx.getSourceRoots();
                    String[] new_additionalSourceRoots = new String[additionalSourceRoots.length + 1];
                    String[] new_sourceRoots = new String[sourceRoots.length + 1];
                    System.arraycopy(additionalSourceRoots, 0, new_additionalSourceRoots, 0, additionalSourceRoots.length);
                    System.arraycopy(sourceRoots, 0, new_sourceRoots, 0, sourceRoots.length);
                    new_additionalSourceRoots[additionalSourceRoots.length] = sourceRoot;
                    new_sourceRoots[sourceRoots.length] = sourceRoot;
                    ectx.setSourceRoots(new_sourceRoots, new_additionalSourceRoots);
                    return true;
                }
            }
        }
        catch (AbsentInformationException sourcePath) {
            // empty catch block
        }
        String name = n1 = className.replace('.', '/');
        int i = name.lastIndexOf(47);
        if (i > 0 && !ectx.sourceAvailable(n1 = name.substring(0, i), false)) {
            name = n1;
        }
        HashSet<String> s = new HashSet<String>();
        s.add(name.replace('/', '.') + ".*");
        this.addExclusionPatterns(s, f);
        return false;
    }

    private void addExclusionPatterns(Set ep, SmartSteppingFilter f) {
        f.addExclusionPatterns(ep);
        if (f == this.smartSteppingFilter) {
            this.exclusionPatterns.addAll(ep);
        }
    }

    private void removeExclusionPatterns() {
        this.smartSteppingFilter.removeExclusionPatterns(this.exclusionPatterns);
        this.exclusionPatterns = new HashSet();
    }

    private SourcePath getEngineContext(ContextProvider lookupProvider) {
        if (this.engineContext == null) {
            this.engineContext = (SourcePath)lookupProvider.lookupFirst(null, SourcePath.class);
            this.engineContext.addPropertyChangeListener(this);
        }
        return this.engineContext;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "sourceRoots") {
            this.removeExclusionPatterns();
        }
    }
}

