/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.parser.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.modules.html.editor.lib.api.DefaultHelpItem;
import org.netbeans.modules.html.editor.lib.api.HelpItem;
import org.netbeans.modules.html.editor.lib.api.HelpResolver;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagType;
import org.netbeans.modules.html.parser.HtmlDocumentation;
import org.netbeans.modules.html.parser.model.Attribute;
import org.netbeans.modules.html.parser.model.ContentType;
import org.netbeans.modules.html.parser.model.ElementDescriptor;
import org.netbeans.modules.html.parser.model.ElementDescriptorRules;
import org.netbeans.modules.html.parser.model.HtmlTagProvider;
import org.openide.util.NbBundle;

public class EDHtmlTag
implements HtmlTag {
    private ElementDescriptor descriptor;
    private Map<String, HtmlTagAttribute> attrs;
    private HtmlTagType type;
    private Collection<HtmlTag> children;

    public EDHtmlTag(ElementDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    private void initAttributes() {
        this.attrs = new HashMap<String, HtmlTagAttribute>();
        for (Attribute attr : this.descriptor.getAttributes()) {
            this.attrs.put(attr.getName(), HtmlTagProvider.getHtmlTagAttributeInstance(attr));
        }
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public int hashCode() {
        int hash = 3;
        hash = 61 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
        hash = 61 * hash + (this.getTagClass() != null ? this.getTagClass().hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HtmlTag)) {
            return false;
        }
        HtmlTag other = (HtmlTag)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return this.getTagClass() == other.getTagClass();
    }

    public String toString() {
        return String.format("ElementName2HtmlTagAdapter{name=%s, type=%s}", this.getName(), this.getTagClass());
    }

    public synchronized Collection<HtmlTagAttribute> getAttributes() {
        if (this.attrs == null) {
            this.initAttributes();
        }
        return this.attrs.values();
    }

    public boolean isEmpty() {
        return this.descriptor.isEmpty();
    }

    public boolean hasOptionalOpenTag() {
        return this.descriptor.hasOptionalOpenTag();
    }

    public boolean hasOptionalEndTag() {
        return this.descriptor.hasOptionalEndTag();
    }

    public synchronized HtmlTagAttribute getAttribute(String name) {
        if (this.attrs == null) {
            this.initAttributes();
        }
        return this.attrs.get(name);
    }

    public HtmlTagType getTagClass() {
        return this.descriptor.getTagType();
    }

    public synchronized Collection<HtmlTag> getChildren() {
        if (this.children == null) {
            Collection<ElementDescriptor> directChildren = this.descriptor.getChildrenElements();
            this.children = new LinkedList<HtmlTag>(HtmlTagProvider.convert(directChildren));
            for (ContentType ct : this.descriptor.getChildrenTypes()) {
                Collection<ElementDescriptor> contentTypeChildren = ElementDescriptorRules.getElementsByContentType(ct);
                this.children.addAll(HtmlTagProvider.convert(contentTypeChildren));
            }
        }
        return this.children;
    }

    public HelpItem getHelp() {
        StringBuilder header = new StringBuilder();
        header.append("<h2>");
        header.append(NbBundle.getMessage(HtmlTagProvider.class, (String)"MSG_ElementPrefix"));
        header.append(" '");
        header.append(this.descriptor.getName());
        header.append("'</h2>");
        return this.descriptor.getHelpLink() != null ? new DefaultHelpItem(HtmlDocumentation.getDefault().resolveLink(this.descriptor.getHelpLink()), (HelpResolver)HtmlDocumentation.getDefault(), header.toString()) : null;
    }
}

