/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.netbeans.modules.web.jsf.navigation.NavigationCaseEdge;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneElement;
import org.openide.util.Exceptions;

public class PageFlowDeleteAction
extends AbstractAction {
    private final PageFlowScene scene;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.web.jsf.navigation.graph.actions.PageFlowDeleteAction");
    private final Collection<NavigationCaseEdge> thoseEdges = new ArrayList<NavigationCaseEdge>();
    private final Collection<NavigationCaseEdge> theseEdges = new ArrayList<NavigationCaseEdge>();

    public PageFlowDeleteAction(PageFlowScene scene) {
        this.scene = scene;
        this.putValue("ACCELERATOR_KEY", KeyStroke.getKeyStroke(127, 0));
    }

    @Override
    public boolean isEnabled() {
        Set selectedObjs = this.scene.getSelectedObjects();
        if (selectedObjs.isEmpty()) {
            return false;
        }
        for (Object selectedObj : selectedObjs) {
            if (!(selectedObj instanceof PageFlowSceneElement)) {
                return false;
            }
            PageFlowSceneElement element = (PageFlowSceneElement)selectedObj;
            if (!element.isModifiable()) {
                return false;
            }
            if (!this.scene.getPageFlowView().getPageFlowController().isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_ALL_FACESCONFIG) || !(element instanceof Page)) continue;
            this.thoseEdges.clear();
            this.theseEdges.clear();
            ArrayList allEdges = new ArrayList();
            Collection pins = this.scene.getNodePins((Page)element);
            for (Pin pin : pins) {
                allEdges.addAll(this.scene.findPinEdges(pin, true, true));
            }
            for (NavigationCaseEdge edge : allEdges) {
                if (edge.isModifiable()) {
                    this.theseEdges.add(edge);
                    continue;
                }
                this.thoseEdges.add(edge);
            }
            if (!this.theseEdges.isEmpty()) continue;
            return false;
        }
        return super.isEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object myObj;
        LinkedList<PageFlowSceneElement> deleteNodesList = new LinkedList<PageFlowSceneElement>();
        HashSet selectedObjects = new HashSet(this.scene.getSelectedObjects());
        LOG.fine("Selected Objects: " + selectedObjects);
        LOG.finest("Scene: \nNodes: " + this.scene.getNodes() + "\nEdges: " + this.scene.getEdges() + "\nPins: " + this.scene.getPins());
        if (selectedObjects.size() == 1 && (myObj = selectedObjects.toArray()[0]) instanceof PageFlowSceneElement) {
            deleteNodesList.add((PageFlowSceneElement)myObj);
            this.deleteNodes(deleteNodesList);
            return;
        }
        HashSet<NavigationCaseEdge> selectedEdges = new HashSet<NavigationCaseEdge>();
        HashSet<PageFlowSceneElement> selectedNonEdges = new HashSet<PageFlowSceneElement>();
        HashSet nonEdgeSelectedObjects = new HashSet();
        for (Object selectedObj : selectedObjects) {
            if (!(selectedObj instanceof PageFlowSceneElement)) continue;
            if (this.scene.isEdge(selectedObj)) {
                assert (!this.scene.isPin(selectedObj));
                selectedEdges.add((NavigationCaseEdge)selectedObj);
                continue;
            }
            assert (this.scene.isNode(selectedObj) || this.scene.isPin(selectedObj));
            selectedNonEdges.add((PageFlowSceneElement)selectedObj);
        }
        deleteNodesList.addAll(selectedEdges);
        deleteNodesList.addAll(selectedNonEdges);
        this.deleteNodes(deleteNodesList);
    }

    private void deleteNodes(Queue<PageFlowSceneElement> deleteNodes) {
        final Queue<PageFlowSceneElement> myDeleteNodes = deleteNodes;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    for (PageFlowSceneElement deleteNode : myDeleteNodes) {
                        if (!deleteNode.canDestroy()) continue;
                        if (deleteNode instanceof NavigationCaseEdge) {
                            PageFlowDeleteAction.this.updateSourcePins((NavigationCaseEdge)deleteNode);
                        }
                        if (PageFlowDeleteAction.this.scene.getPageFlowView().getPageFlowController().isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_ALL_FACESCONFIG)) {
                            if (PageFlowDeleteAction.this.thoseEdges.isEmpty()) {
                                deleteNode.destroy();
                            } else {
                                for (NavigationCaseEdge edge : PageFlowDeleteAction.this.theseEdges) {
                                    if (PageFlowDeleteAction.this.scene.findWidget(edge) == null) continue;
                                    PageFlowDeleteAction.this.updateSourcePins(edge);
                                    edge.destroy();
                                }
                            }
                            PageFlowDeleteAction.this.thoseEdges.clear();
                            continue;
                        }
                        deleteNode.destroy();
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private void updateSourcePins(NavigationCaseEdge navCaseNode) {
        Pin source = (Pin)this.scene.getEdgeSource(navCaseNode);
        if (source != null && !source.isDefault()) {
            source.setFromOutcome(null);
        }
    }
}

