/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import javax.tools.JavaFileObject;
import nbjavac.StringWrapper;

public class ReferenceParser {
    private final ParserFactory fac;

    public ReferenceParser(ParserFactory fac) {
        this.fac = fac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference parse(String sig, Mode mode) throws ParseException {
        List<JCTree> paramTypes;
        Name member;
        JCTree qualExpr;
        JCTree.JCExpression moduleName;
        Log.DeferredDiagnosticHandler dh = new Log.DeferredDiagnosticHandler(this.fac.log);
        try {
            int slash = sig.indexOf("/");
            int afterSlash = slash + 1;
            int hash = sig.indexOf("#", afterSlash);
            int afterHash = hash + 1;
            int lparen = sig.indexOf("(", Math.max(slash, hash) + 1);
            int afterLparen = lparen + 1;
            switch (slash) {
                case -1: {
                    JCTree.JCExpression jCExpression = null;
                    break;
                }
                case 0: {
                    throw new ParseException(0, "dc.ref.syntax.error");
                }
                default: {
                    JCTree.JCExpression jCExpression = moduleName = this.parseModule(sig, 0, slash, dh);
                }
            }
            if (slash > 0 && sig.length() == afterSlash) {
                qualExpr = null;
                member = null;
            } else if (hash == -1) {
                if (lparen == -1 && mode != Mode.MEMBER_REQUIRED) {
                    qualExpr = this.parseType(sig, afterSlash, sig.length(), dh);
                    member = null;
                } else {
                    if (mode == Mode.MEMBER_DISALLOWED) {
                        throw new ParseException(hash, "dc.ref.unexpected.input");
                    }
                    qualExpr = null;
                    member = this.parseMember(sig, afterSlash, lparen > -1 ? lparen : sig.length(), dh);
                }
            } else {
                if (mode == Mode.MEMBER_DISALLOWED) {
                    throw new ParseException(hash, "dc.ref.unexpected.input");
                }
                JCTree jCTree = qualExpr = hash == afterSlash ? null : this.parseType(sig, afterSlash, hash, dh);
                if (sig.indexOf("#", afterHash) == afterHash) {
                    if (mode != Mode.MEMBER_OPTIONAL) {
                        throw new ParseException(afterHash, "dc.ref.unexpected.input");
                    }
                    member = null;
                } else {
                    member = lparen == -1 ? this.parseMember(sig, afterHash, sig.length(), dh) : this.parseMember(sig, afterHash, lparen, dh);
                }
            }
            if (lparen == -1) {
                paramTypes = null;
            } else {
                int rparen = sig.indexOf(")", lparen);
                if (rparen != sig.length() - 1) {
                    throw new ParseException(rparen, "dc.ref.bad.parens");
                }
                paramTypes = this.parseParams(sig, afterLparen, rparen, dh);
            }
            assert (dh.getDiagnostics().isEmpty());
        }
        finally {
            this.fac.log.popDiagnosticHandler(dh);
        }
        return new Reference(moduleName, qualExpr, member, paramTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCExpression parseModule(String sig, int beginIndex, int endIndex, Log.DeferredDiagnosticHandler dh) throws ParseException {
        String s = sig.substring(beginIndex, endIndex);
        JavaFileObject prev = this.fac.log.useSource(null);
        try {
            JavacParser p = this.fac.newParser(s, false, false, false);
            JCTree.JCExpression expr = p.qualident(false);
            if (p.token().kind != Tokens.TokenKind.EOF) {
                throw new ParseException(beginIndex + p.token().pos, "dc.ref.unexpected.input");
            }
            this.checkDiags(dh, beginIndex);
            JCTree.JCExpression jCExpression = expr;
            return jCExpression;
        }
        finally {
            this.fac.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree parseType(String sig, int beginIndex, int endIndex, Log.DeferredDiagnosticHandler dh) throws ParseException {
        String s = sig.substring(beginIndex, endIndex);
        JavaFileObject prev = this.fac.log.useSource(null);
        try {
            JavacParser p = this.fac.newParser(s, false, false, false);
            JCTree.JCExpression tree = p.parseType();
            if (p.token().kind != Tokens.TokenKind.EOF) {
                throw new ParseException(beginIndex + p.token().pos, "dc.ref.unexpected.input");
            }
            this.checkDiags(dh, beginIndex);
            JCTree.JCExpression jCExpression = tree;
            return jCExpression;
        }
        finally {
            this.fac.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Name parseMember(String sig, int beginIndex, int endIndex, Log.DeferredDiagnosticHandler dh) throws ParseException {
        String s = sig.substring(beginIndex, endIndex);
        JavaFileObject prev = this.fac.log.useSource(null);
        try {
            JavacParser p = this.fac.newParser(s, false, false, false);
            Name name = p.ident();
            if (p.token().kind != Tokens.TokenKind.EOF) {
                throw new ParseException(beginIndex + p.token().pos, "dc.ref.unexpected.input");
            }
            this.checkDiags(dh, beginIndex);
            Name name2 = name;
            return name2;
        }
        finally {
            this.fac.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JCTree> parseParams(String sig, int beginIndex, int endIndex, Log.DeferredDiagnosticHandler dh) throws ParseException {
        String s = sig.substring(beginIndex, endIndex);
        if (StringWrapper.isBlank(s)) {
            return List.nil();
        }
        JavaFileObject prev = this.fac.log.useSource(null);
        try {
            JavacParser p = this.fac.newParser(s.replace("...", "[]"), false, false, false);
            ListBuffer<JCTree.JCExpression> paramTypes = new ListBuffer<JCTree.JCExpression>();
            paramTypes.add(p.parseType());
            if (p.token().kind == Tokens.TokenKind.IDENTIFIER) {
                p.nextToken();
            }
            while (p.token().kind == Tokens.TokenKind.COMMA) {
                p.nextToken();
                paramTypes.add(p.parseType());
                if (p.token().kind != Tokens.TokenKind.IDENTIFIER) continue;
                p.nextToken();
            }
            if (p.token().kind != Tokens.TokenKind.EOF) {
                throw new ParseException(p.token().pos, "dc.ref.unexpected.input");
            }
            Tree typeAnno = (Tree)new TypeAnnotationFinder().scan(paramTypes, null);
            if (typeAnno != null) {
                int annoPos = ((JCTree)typeAnno).getStartPosition();
                throw new ParseException(beginIndex + annoPos, "dc.ref.annotations.not.allowed");
            }
            this.checkDiags(dh, beginIndex);
            List<JCTree> list = paramTypes.toList();
            return list;
        }
        finally {
            this.fac.log.useSource(prev);
        }
    }

    private void checkDiags(Log.DeferredDiagnosticHandler h, int offset) throws ParseException {
        JCDiagnostic d = h.getDiagnostics().peek();
        if (d != null) {
            throw new ParseException(offset + (int)d.getPosition(), "dc.ref.syntax.error");
        }
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = 0L;
        final int pos;

        ParseException(int pos, String message) {
            super(message);
            this.pos = pos;
        }
    }

    public static enum Mode {
        MEMBER_DISALLOWED,
        MEMBER_OPTIONAL,
        MEMBER_REQUIRED;

    }

    public static class Reference {
        public final JCTree.JCExpression moduleName;
        public final JCTree qualExpr;
        public final Name member;
        public final List<JCTree> paramTypes;

        Reference(JCTree.JCExpression moduleName, JCTree qualExpr, Name member, List<JCTree> paramTypes) {
            this.moduleName = moduleName;
            this.qualExpr = qualExpr;
            this.member = member;
            this.paramTypes = paramTypes;
        }
    }

    static class TypeAnnotationFinder
    extends TreeScanner<Tree, Void> {
        TypeAnnotationFinder() {
        }

        @Override
        public Tree visitAnnotatedType(AnnotatedTypeTree t, Void ignore) {
            return t;
        }

        @Override
        public Tree reduce(Tree t1, Tree t2) {
            return t1 != null ? t1 : t2;
        }
    }
}

