/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.locate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.phpunit.commands.PhpUnit;
import org.netbeans.modules.php.spi.testing.locate.Locations;
import org.netbeans.modules.php.spi.testing.locate.TestLocator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Pair;

public class PhpUnitTestLocator
implements TestLocator {
    private final PhpModule phpModule;

    public PhpUnitTestLocator(PhpModule phpModule) {
        assert (phpModule != null);
        this.phpModule = phpModule;
    }

    public Set<Locations.Offset> findSources(FileObject testFile) {
        assert (this.phpModule.getSourceDirectory() != null) : "Source directory must exist";
        return this.find(Collections.singletonList(this.phpModule.getSourceDirectory()), testFile, false);
    }

    public Set<Locations.Offset> findTests(FileObject testedFile) {
        assert (!this.phpModule.getTestDirectories().isEmpty()) : "Test directories must exist";
        return this.find(this.phpModule.getTestDirectories(), testedFile, true);
    }

    private Set<Locations.Offset> find(List<FileObject> sourceRoots, FileObject file, boolean searchTest) {
        EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
        assert (editorSupport != null) : "Editor support must exist";
        TreeSet<Locations.Offset> phpFiles = new TreeSet<Locations.Offset>(new Comparator<Locations.Offset>(){

            @Override
            public int compare(Locations.Offset o1, Locations.Offset o2) {
                return o1.getFile().getPath().compareTo(o2.getFile().getPath());
            }
        });
        for (PhpClass phpClass : editorSupport.getClasses(file)) {
            ArrayList<Pair> classes = new ArrayList<Pair>();
            if (searchTest) {
                classes.add(Pair.of((Object)PhpUnit.makeTestClass(phpClass.getName()), (Object)PhpUnit.makeTestClass(phpClass.getFullyQualifiedName())));
                classes.add(Pair.of((Object)PhpUnit.makeSuiteClass(phpClass.getName()), (Object)PhpUnit.makeSuiteClass(phpClass.getFullyQualifiedName())));
            } else {
                if (!PhpUnit.isTestOrSuiteClass(phpClass.getName())) continue;
                String fullyQualifiedName = phpClass.getFullyQualifiedName();
                assert (fullyQualifiedName != null) : "No FQN for php class: " + phpClass.getName();
                classes.add(Pair.of((Object)PhpUnit.getTestedClass(phpClass.getName()), (Object)PhpUnit.getTestedClass(fullyQualifiedName)));
            }
            List<Locations.Offset> results = new ArrayList<Locations.Offset>();
            for (Pair namePair : classes) {
                Collection files;
                results.clear();
                for (FileObject sourceRoot : sourceRoots) {
                    files = editorSupport.filesForClass(sourceRoot, new PhpClass((String)namePair.first(), (String)namePair.second(), -1));
                    results.addAll(this.filterPhpFiles(sourceRoot, files));
                }
                if (!results.isEmpty()) {
                    phpFiles.addAll(results);
                    continue;
                }
                for (FileObject sourceRoot : sourceRoots) {
                    files = editorSupport.filesForClass(sourceRoot, new PhpClass((String)namePair.first(), null, -1));
                    results = this.filterPhpFiles(sourceRoot, files);
                    phpFiles.addAll(results);
                }
            }
        }
        return phpFiles;
    }

    private List<Locations.Offset> filterPhpFiles(FileObject sourceRoot, Collection<Pair<FileObject, Integer>> files) {
        ArrayList<Locations.Offset> results = new ArrayList<Locations.Offset>(files.size());
        for (Pair<FileObject, Integer> pair : files) {
            FileObject fileObject = (FileObject)pair.first();
            if (!FileUtils.isPhpFile((FileObject)fileObject) || !FileUtil.isParentOf((FileObject)sourceRoot, (FileObject)fileObject)) continue;
            results.add(new Locations.Offset(fileObject, ((Integer)pair.second()).intValue()));
        }
        return results;
    }
}

