/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.io.File;
import java.io.IOException;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

abstract class JavaSymbolDescriptorBase
extends SymbolDescriptor {
    private final ElementHandle<TypeElement> owner;
    private final ProjectInformation projectInformation;
    private final FileObject root;
    private final ClassIndexImpl ci;
    private volatile FileObject cachedFo;
    private volatile String cachedPath;
    private volatile String ownerName;

    JavaSymbolDescriptorBase(@NonNull ElementHandle<TypeElement> owner, @NullAllowed ProjectInformation projectInformation, @NonNull FileObject root, @NonNull ClassIndexImpl ci) {
        assert (owner != null);
        assert (root != null);
        assert (ci != null);
        this.owner = owner;
        this.projectInformation = projectInformation;
        this.root = root;
        this.ci = ci;
    }

    JavaSymbolDescriptorBase(@NonNull JavaSymbolDescriptorBase other, @NullAllowed String ownerName) {
        this.owner = other.owner;
        this.projectInformation = other.projectInformation;
        this.root = other.root;
        this.ci = other.ci;
        this.cachedFo = other.cachedFo;
        this.cachedPath = other.cachedPath;
        this.ownerName = ownerName != null ? ownerName : other.ownerName;
    }

    @NonNull
    public final String getOwnerName() {
        String on = this.ownerName;
        if (on == null) {
            this.ownerName = on = JavaSymbolDescriptorBase.replace(this.owner.getBinaryName(), this.getSimpleName());
        }
        return on;
    }

    @CheckForNull
    public final FileObject getFileObject() {
        FileObject res = this.cachedFo;
        if (res == null) {
            ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[]{this.root}));
            res = this.cachedFo = SourceUtils.getFile(this.owner, (ClasspathInfo)cpInfo);
        }
        return res;
    }

    @NonNull
    public final String getFileDisplayPath() {
        String res = this.cachedPath;
        if (res == null) {
            File rootFile = FileUtil.toFile((FileObject)this.root);
            if (rootFile != null) {
                try {
                    String binaryName = this.owner.getBinaryName();
                    String relativePath = this.ci.getSourceName(binaryName);
                    if (relativePath == null) {
                        relativePath = binaryName;
                        int lastDot = relativePath.lastIndexOf(46);
                        int csIndex = relativePath.indexOf(36, lastDot);
                        if (csIndex > 0 && csIndex < relativePath.length() - 1) {
                            relativePath = binaryName.substring(0, csIndex);
                        }
                        relativePath = String.format("%s.%s", FileObjects.convertPackage2Folder((String)relativePath, (char)File.separatorChar), "java");
                    }
                    res = new File(rootFile, relativePath).getAbsolutePath();
                }
                catch (IOException | InterruptedException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            if (res == null) {
                FileObject fo = this.getFileObject();
                res = fo == null ? "" : FileUtil.getFileDisplayName((FileObject)fo);
            }
            this.cachedPath = res;
        }
        return res;
    }

    @NonNull
    public final String getProjectName() {
        return this.projectInformation == null ? "" : this.projectInformation.getDisplayName();
    }

    @CheckForNull
    public final Icon getProjectIcon() {
        return this.projectInformation == null ? null : this.projectInformation.getIcon();
    }

    public final int getOffset() {
        return -1;
    }

    @NonNull
    final FileObject getRoot() {
        return this.root;
    }

    @NonNull
    final ElementHandle<TypeElement> getOwner() {
        return this.owner;
    }

    @NonNull
    private static String replace(@NonNull String name, @NonNull String simpleName) {
        char c;
        int i;
        int upBound = name.length();
        int pos = upBound - simpleName.length();
        if ((pos == 0 || pos > 0 && name.charAt(pos - 1) == '$') && name.substring(pos).equalsIgnoreCase(simpleName)) {
            upBound = pos;
        }
        for (i = 1; i < upBound && ((c = name.charAt(i)) != '$' || name.charAt(i - 1) == '.' || i >= name.length() - 1 || name.charAt(i + 1) == '.'); ++i) {
        }
        if (i < upBound) {
            char[] data = name.toCharArray();
            while (i < upBound) {
                int c2 = name.charAt(i);
                if (c2 == 36 && name.charAt(i - 1) != '.' && i < name.length() - 1 && name.charAt(i + 1) != '.') {
                    c2 = 46;
                }
                data[i] = c2;
                ++i;
            }
            name = new String(data);
        }
        return name;
    }
}

