/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.Context;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;

public abstract class SyntaxContext
extends Context {
    public abstract ASTPath getASTPath();

    public static SyntaxContext create(Document doc, ASTPath path) {
        return new CookieImpl(doc, path);
    }

    private static class CookieImpl
    extends SyntaxContext {
        private Document doc;
        private ASTPath path;
        private JTextComponent component;

        CookieImpl(Document doc, ASTPath path) {
            this.doc = doc;
            this.path = path;
        }

        @Override
        public JTextComponent getJTextComponent() {
            DataObject dob;
            EditorCookie ec;
            if (this.component == null && (ec = (EditorCookie)(dob = NbEditorUtilities.getDataObject((Document)this.doc)).getLookup().lookup(EditorCookie.class)).getOpenedPanes().length > 0) {
                this.component = ec.getOpenedPanes()[0];
            }
            return this.component;
        }

        @Override
        public ASTPath getASTPath() {
            return this.path;
        }

        @Override
        public Document getDocument() {
            return this.doc;
        }

        @Override
        public int getOffset() {
            return this.path.getLeaf().getOffset();
        }
    }
}

