/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;

public abstract class Context {
    public abstract JTextComponent getJTextComponent();

    public abstract Document getDocument();

    public abstract int getOffset();

    public static Context create(Document doc, int offset) {
        return new CookieImpl(doc, offset);
    }

    private static class CookieImpl
    extends Context {
        private Document doc;
        private JTextComponent component;
        private int offset;

        CookieImpl(Document doc, int offset) {
            this.doc = doc;
            this.offset = offset;
        }

        @Override
        public JTextComponent getJTextComponent() {
            DataObject dob;
            EditorCookie ec;
            if (this.component == null && (ec = (EditorCookie)(dob = NbEditorUtilities.getDataObject((Document)this.doc)).getLookup().lookup(EditorCookie.class)).getOpenedPanes().length > 0) {
                this.component = ec.getOpenedPanes()[0];
            }
            return this.component;
        }

        @Override
        public Document getDocument() {
            return this.doc;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }
    }
}

