/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gototest;

import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.gototest.Bundle;
import org.netbeans.modules.gototest.OppositeCandidateChooser;
import org.netbeans.modules.gototest.PopupUtil;
import org.netbeans.modules.gsf.testrunner.ui.api.TestCreatorPanelDisplayer;
import org.netbeans.modules.gsf.testrunner.ui.api.UICommonUtils;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;

public class GotoOppositeAction
extends CallableSystemAction {
    private HashMap<TestLocator.LocationResult, String> locationResults = new HashMap();
    private Semaphore lock;

    public GotoOppositeAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
        String trimmedName = NbBundle.getMessage(GotoOppositeAction.class, (String)"LBL_Action_GoToTest_trimmed");
        this.putValue("trimmed-text", trimmedName);
    }

    public String getName() {
        return Bundle.LBL_Action_GoToTestOrTestedClass();
    }

    public boolean isEnabled() {
        assert (EventQueue.isDispatchThread());
        EditorCookie ec = (EditorCookie)Utilities.actionsGlobalContext().lookup(EditorCookie.class);
        return ec != null && ec.getDocument() != null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("ShortDescription", NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_Action_GoToTest"));
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction() {
        int[] caretOffsetHolder = new int[]{-1};
        final FileObject fo = this.getApplicableFileObject(caretOffsetHolder);
        final int caretOffset = caretOffsetHolder[0];
        if (fo != null) {
            RequestProcessor RP = new RequestProcessor(GotoOppositeAction.class.getName());
            RP.post(new Runnable(){

                @Override
                public void run() {
                    TestLocator.FileType currentFileType = GotoOppositeAction.this.getCurrentFileType();
                    if (currentFileType == TestLocator.FileType.NEITHER) {
                        StatusDisplayer.getDefault().setStatusText(Bundle.No_Test_Or_Tested_Class_Found());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TestCreatorPanelDisplayer.getDefault().displayPanel(UICommonUtils.getFileObjectsFromNodes((Node[])TopComponent.getRegistry().getActivatedNodes()), null, null);
                            }
                        });
                    } else {
                        GotoOppositeAction.this.populateLocationResults(fo, caretOffset);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (GotoOppositeAction.this.locationResults.size() == 1) {
                                    GotoOppositeAction.this.handleResult((TestLocator.LocationResult)GotoOppositeAction.this.locationResults.keySet().iterator().next());
                                } else if (GotoOppositeAction.this.locationResults.size() > 1) {
                                    GotoOppositeAction.this.showPopup(fo);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private void populateLocationResults(FileObject fo, int caretOffset) {
        this.locationResults.clear();
        Collection locators = Lookup.getDefault().lookupAll(TestLocator.class);
        int permits = 0;
        for (TestLocator locator : locators) {
            if (!locator.appliesTo(fo)) continue;
            ++permits;
        }
        this.lock = new Semaphore(permits);
        try {
            this.lock.acquire(permits);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (TestLocator locator : locators) {
            if (!locator.appliesTo(fo)) continue;
            this.doPopulateLocationResults(fo, caretOffset, locator);
        }
        try {
            this.lock.acquire(permits);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void doPopulateLocationResults(FileObject fo, int caretOffset, TestLocator locator) {
        if (locator != null && locator.appliesTo(fo)) {
            if (locator.asynchronous()) {
                locator.findOpposite(fo, caretOffset, new TestLocator.LocationListener(){

                    @Override
                    public void foundLocation(FileObject fo, TestLocator.LocationResult location) {
                        if (location != null) {
                            FileObject fileObject = location.getFileObject();
                            if (fileObject == null) {
                                String msg = location.getErrorMessage();
                                if (msg != null) {
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 1));
                                }
                            } else {
                                GotoOppositeAction.this.locationResults.put(location, fileObject.getName());
                            }
                        }
                        GotoOppositeAction.this.lock.release();
                    }
                });
            } else {
                TestLocator.LocationResult opposite = locator.findOpposite(fo, caretOffset);
                if (opposite != null) {
                    FileObject fileObject = opposite.getFileObject();
                    if (fileObject == null) {
                        String msg = opposite.getErrorMessage();
                        if (msg != null) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 1));
                        }
                    } else {
                        this.locationResults.put(opposite, fileObject.getName());
                    }
                }
                this.lock.release();
            }
        }
    }

    private void showPopup(FileObject fo) {
        Point l = new Point(-1, -1);
        try {
            EditorCookie ec = (EditorCookie)fo.getLookup().lookup(EditorCookie.class);
            if (ec != null) {
                JEditorPane pane = NbDocument.findRecentEditorPane((EditorCookie)ec);
                Rectangle pos = pane.modelToView(pane.getCaretPosition());
                l = new Point(pos.x + pos.width, pos.y + pos.height);
                SwingUtilities.convertPointToScreen(l, pane);
                String label = Bundle.LBL_PickExpression();
                PopupUtil.showPopup(new OppositeCandidateChooser(this, label, this.locationResults), label, l.x, l.y, true, -1);
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(GotoOppositeAction.class.getName()).log(Level.WARNING, null, ex);
        }
    }

    public void handleResult(TestLocator.LocationResult opposite) {
        FileObject fileObject = opposite.getFileObject();
        if (fileObject != null) {
            NbDocument.openDocument((Lookup.Provider)fileObject, (int)opposite.getOffset(), (Line.ShowOpenType)Line.ShowOpenType.OPEN, (Line.ShowVisibilityType)Line.ShowVisibilityType.FOCUS);
        } else if (opposite.getErrorMessage() != null) {
            String msg = opposite.getErrorMessage();
            NotifyDescriptor.Message descr = new NotifyDescriptor.Message((Object)msg, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
        }
    }

    private TestLocator getLocatorFor(FileObject fo) {
        Collection locators = Lookup.getDefault().lookupAll(TestLocator.class);
        for (TestLocator locator : locators) {
            if (!locator.appliesTo(fo)) continue;
            return locator;
        }
        return null;
    }

    private TestLocator.FileType getFileType(FileObject fo) {
        TestLocator locator = this.getLocatorFor(fo);
        if (locator != null) {
            return locator.getFileType(fo);
        }
        return TestLocator.FileType.NEITHER;
    }

    private TestLocator.FileType getCurrentFileType() {
        FileObject fo = this.getApplicableFileObject(new int[1]);
        return fo != null ? this.getFileType(fo) : TestLocator.FileType.NEITHER;
    }

    private FileObject getApplicableFileObject(int[] caretPosHolder) {
        if (!EventQueue.isDispatchThread()) {
            Collection dobs = Utilities.actionsGlobalContext().lookupAll(FileObject.class);
            return dobs.size() == 1 ? (FileObject)dobs.iterator().next() : null;
        }
        TopComponent comp = TopComponent.getRegistry().getActivated();
        if (comp == null) {
            return null;
        }
        Node[] nodes = comp.getActivatedNodes();
        if (nodes != null && nodes.length == 1) {
            if (comp instanceof CloneableEditorSupport.Pane) {
                JEditorPane editorPane;
                EditorCookie ec = (EditorCookie)nodes[0].getLookup().lookup(EditorCookie.class);
                if (ec != null && (editorPane = NbDocument.findRecentEditorPane((EditorCookie)ec)) != null) {
                    if (editorPane.getCaret() != null) {
                        caretPosHolder[0] = editorPane.getCaret().getDot();
                    }
                    Document document = editorPane.getDocument();
                    return Source.create((Document)document).getFileObject();
                }
            } else {
                return UICommonUtils.getFileObjectFromNode((Node)nodes[0]);
            }
        }
        return null;
    }
}

