/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.sax;

import nu.validator.htmlparser.impl.HtmlAttributes;
import nu.validator.htmlparser.impl.TreeBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SAXStreamer
extends TreeBuilder<Attributes> {
    private ContentHandler contentHandler = null;
    private LexicalHandler lexicalHandler = null;

    SAXStreamer() {
    }

    @Override
    protected void addAttributesToElement(Attributes element, HtmlAttributes attributes) throws SAXException {
        Attributes existingAttrs = element;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qName = attributes.getQNameNoBoundsCheck(i);
            if (existingAttrs.getIndex(qName) >= 0) continue;
            this.fatal();
        }
    }

    @Override
    protected void appendCharacters(Attributes parent, char[] buf, int start, int length) throws SAXException {
        this.contentHandler.characters(buf, start, length);
    }

    @Override
    protected void appendChildrenToNewParent(Attributes oldParent, Attributes newParent) throws SAXException {
        this.fatal();
    }

    @Override
    protected void appendComment(Attributes parent, char[] buf, int start, int length) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(buf, start, length);
        }
    }

    @Override
    protected void appendCommentToDocument(char[] buf, int start, int length) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(buf, start, length);
        }
    }

    @Override
    protected Attributes createElement(String ns, String name, HtmlAttributes attributes, Attributes intendedParent) throws SAXException {
        return attributes;
    }

    @Override
    protected Attributes createHtmlElementSetAsRoot(HtmlAttributes attributes) throws SAXException {
        return attributes;
    }

    @Override
    protected void detachFromParent(Attributes element) throws SAXException {
        this.fatal();
    }

    @Override
    protected void appendElement(Attributes child, Attributes newParent) throws SAXException {
    }

    @Override
    protected boolean hasChildren(Attributes element) throws SAXException {
        return false;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    @Override
    protected void appendDoctypeToDocument(String name, String publicIdentifier, String systemIdentifier) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicIdentifier, systemIdentifier);
            this.lexicalHandler.endDTD();
        }
    }

    @Override
    protected void elementPopped(String ns, String name, Attributes node) throws SAXException {
        this.contentHandler.endElement(ns, name, name);
    }

    @Override
    protected void elementPushed(String ns, String name, Attributes node) throws SAXException {
        this.contentHandler.startElement(ns, name, name, node);
    }

    @Override
    protected void end() throws SAXException {
        this.contentHandler.endDocument();
    }

    @Override
    protected void start(boolean fragment) throws SAXException {
        this.contentHandler.setDocumentLocator(this.tokenizer);
        if (!fragment) {
            this.contentHandler.startDocument();
        }
    }

    @Override
    protected void fatal() throws SAXException {
        SAXParseException spe = new SAXParseException("Cannot recover after last error. Any further errors will be ignored.", this.tokenizer);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(spe);
        }
        throw spe;
    }

    @Override
    protected Attributes createAndInsertFosterParentedElement(String ns, String name, HtmlAttributes attributes, Attributes table, Attributes stackParent) throws SAXException {
        this.fatal();
        throw new RuntimeException("Unreachable");
    }

    @Override
    protected void insertFosterParentedCharacters(char[] buf, int start, int length, Attributes table, Attributes stackParent) throws SAXException {
        this.fatal();
    }

    @Override
    protected void insertFosterParentedChild(Attributes child, Attributes table, Attributes stackParent) throws SAXException {
        this.fatal();
    }
}

