/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import java.io.CharConversionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.xml.XMLUtil;

public class Utils {
    private static final String CLASS_EXTENSION = "class";
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());

    private Utils() {
        throw new IllegalStateException();
    }

    @CheckForNull
    public static String escape(@NonNull String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (CharConversionException charConversionException) {
                // empty catch block
            }
        }
        return null;
    }

    @CheckForNull
    public static FileObject getFile(@NonNull ElementHandle<TypeElement> toResolve, @NonNull ClasspathInfo cpInfo) {
        FileObject res = SourceUtils.getFile(toResolve, (ClasspathInfo)cpInfo);
        if (res == null) {
            ClassPath cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT), cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE)});
            res = cp.findResource(String.format("%s.%s", toResolve.getBinaryName().replace('.', '/'), CLASS_EXTENSION));
        }
        return res;
    }

    @NonNull
    public static <T extends JComponent> T updateBackground(@NonNull T comp) {
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            comp.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        return comp;
    }

    @CheckForNull
    public static <T extends Element> ElementHandle<T> createElementHandle(@NonNull T element) {
        if (element.getKind() == ElementKind.OTHER) {
            return null;
        }
        try {
            return ElementHandle.create(element);
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.INFO, "Unresolvable element: {0}, reason: {1}", new Object[]{element, e.getMessage()});
            return null;
        }
    }

    public static boolean signatureEquals(@NonNull ElementHandle<Element> handle, @NonNull Element element) {
        if (handle == null) {
            return false;
        }
        if (element.getKind() == ElementKind.OTHER) {
            return false;
        }
        try {
            return handle.signatureEquals(element);
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.INFO, "Unresolvable element: {0}, reason: {1}", new Object[]{element, e.getMessage()});
            return false;
        }
    }
}

