/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.MultiTargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class MultiTargetChooserPanel
implements WizardDescriptor.Panel,
ChangeListener {
    public static final String TARGET_NAME = "MultiTargetChooserPanel.TARGET_NAME";
    public static final String TARGET_FOLDER = "MultiTargetChooserPanel.TARGET_FOLDER";
    public static final String TARGET_PACKAGE = "MultiTargetChooserPanel.TARGET_PACKAGE";
    static final int TYPE_FILE = 0;
    static final int TYPE_PACKAGE = 1;
    static final int TYPE_PKG_INFO = 2;
    private static final String FOLDER_TO_DELETE = "folderToDelete";
    private final SpecificationVersion JDK_14 = new SpecificationVersion("1.4");
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private MultiTargetChooserPanelGUI gui;
    private WizardDescriptor.Panel bottomPanel;
    private WizardDescriptor wizard;
    private Project project;
    private SourceGroup[] folders;
    private int type;
    private boolean isValidPackageRequired;

    public MultiTargetChooserPanel(Project project, SourceGroup[] folders, WizardDescriptor.Panel bottomPanel) {
        this(project, folders, bottomPanel, false);
    }

    public MultiTargetChooserPanel(Project project, SourceGroup[] folders, WizardDescriptor.Panel bottomPanel, boolean isValidPackageRequired) {
        this.project = project;
        this.folders = folders;
        if (0 == folders.length) {
            this.folders = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        }
        this.bottomPanel = bottomPanel;
        this.type = 0;
        if (bottomPanel != null) {
            bottomPanel.addChangeListener((ChangeListener)this);
        }
        this.isValidPackageRequired = isValidPackageRequired;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new MultiTargetChooserPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.type);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        HelpCtx bottomHelp;
        if (this.bottomPanel != null && (bottomHelp = this.bottomPanel.getHelp()) != null) {
            return bottomHelp;
        }
        return null;
    }

    public boolean isValid() {
        if (this.gui == null || this.gui.getTargetName() == null) {
            this.setErrorMessage(null);
            return false;
        }
        if (this.type == 1) {
            if (!MultiTargetChooserPanel.isValidPackageName(this.gui.getTargetName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidPackage");
                return false;
            }
        } else if (this.type == 2) {
            assert ("package-info".equals(this.gui.getTargetName()));
            if (!MultiTargetChooserPanel.isValidPackageName(this.gui.getPackageName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidPackage");
                return false;
            }
        } else {
            if (!MultiTargetChooserPanel.isValidTypeIdentifier(this.gui.getTargetName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidClass");
                return false;
            }
            if (!MultiTargetChooserPanel.isValidPackageName(this.gui.getPackageName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidPackage");
                return false;
            }
        }
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        boolean returnValue = true;
        FileObject rootFolder = this.gui.getRootFolder();
        if (rootFolder == null) {
            this.setErrorMessage("ERR_JavaTargetChooser_InvalidRootFolder");
            return false;
        }
        SpecificationVersion specVersion = null;
        if (this.type != 1) {
            String sl = SourceLevelQuery.getSourceLevel((FileObject)rootFolder);
            specVersion = sl != null ? new SpecificationVersion(sl) : null;
        }
        String errorMessage = MultiTargetChooserPanel.canUseFileName(rootFolder, this.gui.getPackageFileName(), this.gui.getTargetName(), template.getExt());
        if (this.gui != null) {
            this.setLocalizedErrorMessage(errorMessage);
        }
        if (errorMessage != null) {
            returnValue = false;
        }
        if (this.type != 1 && returnValue && this.gui.getPackageName().length() == 0 && specVersion != null && this.JDK_14.compareTo(specVersion) <= 0) {
            if (this.isValidPackageRequired) {
                this.setErrorMessage("ERR_JavaTargetChooser_CantUseDefaultPackage");
                return false;
            }
            this.setErrorMessage("ERR_JavaTargetChooser_DefaultPackage");
        }
        String templateSrcLev = (String)template.getAttribute("javac.source");
        if (specVersion != null && templateSrcLev != null && specVersion.compareTo(new SpecificationVersion(templateSrcLev)) < 0) {
            this.setErrorMessage("ERR_JavaTargetChooser_WrongPlatform");
        }
        this.wizard.putProperty(TARGET_NAME, (Object)this.gui.getTargetName());
        this.wizard.putProperty(TARGET_FOLDER, (Object)rootFolder.getFileObject(this.gui.getPackageFileName().replace('.', '/')));
        this.wizard.putProperty(TARGET_PACKAGE, (Object)this.gui.getPackageFileName());
        if (returnValue && this.bottomPanel != null && !this.bottomPanel.isValid()) {
            return false;
        }
        return returnValue;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        Iterator<ChangeListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().stateChanged(e);
        }
    }

    public void readSettings(Object settings) {
        Object substitute;
        this.wizard = (WizardDescriptor)settings;
        if (this.gui != null) {
            FileObject preselectedFolder = Templates.getTargetFolder((WizardDescriptor)this.wizard);
            this.gui.initValues(Templates.getTemplate((WizardDescriptor)this.wizard), preselectedFolder);
        }
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings(settings);
        }
        if (this.gui != null && (substitute = this.gui.getClientProperty("NewFileWizard_Title")) != null) {
            this.wizard.putProperty("NewFileWizard_Title", substitute);
        }
    }

    public void storeSettings(Object settings) {
        Object value = ((WizardDescriptor)settings).getValue();
        if (WizardDescriptor.PREVIOUS_OPTION.equals(value) || WizardDescriptor.CANCEL_OPTION.equals(value) || WizardDescriptor.CLOSED_OPTION.equals(value)) {
            return;
        }
        if (this.isValid()) {
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings(settings);
            }
            Templates.setTargetFolder((WizardDescriptor)((WizardDescriptor)settings), (FileObject)this.getTargetFolderFromGUI((WizardDescriptor)settings));
            Templates.setTargetName((WizardDescriptor)((WizardDescriptor)settings), (String)this.gui.getTargetName());
        }
        ((WizardDescriptor)settings).putProperty("NewFileWizard_Title", null);
        if (WizardDescriptor.FINISH_OPTION.equals(value)) {
            this.wizard.putProperty(FOLDER_TO_DELETE, null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChange();
    }

    private void setErrorMessage(String key) {
        if (key == null) {
            this.setLocalizedErrorMessage("");
        } else {
            this.setLocalizedErrorMessage(NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)key));
        }
    }

    private void setLocalizedErrorMessage(String message) {
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)message);
    }

    private FileObject getTargetFolderFromGUI(WizardDescriptor wd) {
        assert (this.gui != null);
        FileObject rootFolder = this.gui.getRootFolder();
        FileObject folder = null;
        if (this.type != 1) {
            String packageFileName = this.gui.getPackageFileName();
            folder = rootFolder.getFileObject(packageFileName);
            if (folder == null) {
                try {
                    FileObject fo;
                    folder = rootFolder;
                    StringTokenizer tk = new StringTokenizer(packageFileName, "/");
                    String name = null;
                    while (tk.hasMoreTokens() && (fo = folder.getFileObject(name = tk.nextToken(), "")) != null) {
                        folder = fo;
                    }
                    folder = folder.createFolder(name);
                    FileObject toDelete = (FileObject)wd.getProperty(FOLDER_TO_DELETE);
                    if (toDelete == null) {
                        wd.putProperty(FOLDER_TO_DELETE, (Object)folder);
                    } else if (!toDelete.equals(folder)) {
                        toDelete.delete();
                        wd.putProperty(FOLDER_TO_DELETE, (Object)folder);
                    }
                    while (tk.hasMoreTokens()) {
                        name = tk.nextToken();
                        folder = folder.createFolder(name);
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        } else {
            folder = rootFolder;
        }
        return folder;
    }

    static boolean isValidPackageName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(str, ".");
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidTypeIdentifier(String ident) {
        return ident != null && !"".equals(ident) && Utilities.isJavaIdentifier((String)ident);
    }

    public static final String canUseFileName(FileObject targetFolder, String folderName, String newObjectName, String extension) {
        StringBuffer sb;
        String newObjectNameToDisplay = newObjectName;
        if (newObjectName != null) {
            newObjectName = newObjectName.replace('.', '/');
        }
        if (extension != null && extension.length() > 0) {
            sb = new StringBuffer();
            sb.append(newObjectName);
            sb.append('.');
            sb.append(extension);
            newObjectName = sb.toString();
        }
        if (extension != null && extension.length() > 0) {
            sb = new StringBuffer();
            sb.append(newObjectNameToDisplay);
            sb.append('.');
            sb.append(extension);
            newObjectNameToDisplay = sb.toString();
        }
        String relFileName = folderName + "/" + newObjectName;
        if (targetFolder == null) {
            return NbBundle.getMessage(MultiTargetChooserPanel.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        if (!targetFolder.canWrite()) {
            return NbBundle.getMessage(MultiTargetChooserPanel.class, (String)"MSG_fs_is_readonly");
        }
        if (MultiTargetChooserPanel.existFileName(targetFolder, relFileName)) {
            return NbBundle.getMessage(MultiTargetChooserPanel.class, (String)"MSG_file_already_exist", (Object)newObjectNameToDisplay);
        }
        return null;
    }

    private static boolean existFileName(FileObject targetFolder, String relFileName) {
        boolean result = false;
        File fileForTargetFolder = FileUtil.toFile((FileObject)targetFolder);
        result = fileForTargetFolder.exists() ? new File(fileForTargetFolder, relFileName).exists() : targetFolder.getFileObject(relFileName) != null;
        return result;
    }
}

