/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.projects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.favorites.api.Favorites;
import org.netbeans.modules.versioning.util.ProjectUtilities;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.projects.CheckoutCompletedPanel;
import org.netbeans.modules.versioning.util.projects.OpenProjectsPanel;
import org.netbeans.modules.versioning.util.projects.ProjectsView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ProjectOpener
implements ActionListener,
PropertyChangeListener {
    private final ProjectOpenerType type;
    private CheckoutCompletedPanel panel;
    private Dialog dialog;
    private final Map<Project, Set<Project>> checkedOutProjects;
    private final File workingFolder;
    private OpenProjectsPanel projectsPanel;
    private JButton okButton;
    private int numberOfProjects;

    public ProjectOpener(ProjectOpenerType type, Map<Project, Set<Project>> checkedOutProjects, File workingFolder) {
        this.checkedOutProjects = checkedOutProjects;
        this.workingFolder = workingFolder;
        this.type = type;
        this.numberOfProjects = checkedOutProjects.size() - 1;
    }

    public void openProjects() {
        this.panel = new CheckoutCompletedPanel(this.type);
        this.panel.openButton.addActionListener(this);
        this.panel.createButton.addActionListener(this);
        this.panel.closeButton.addActionListener(this);
        this.panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.panel.cbOpenInFavorites.setToolTipText(this.type.getMessage("CheckoutCompletedPanel.cbOpenInFavorites.TT"));
        this.panel.cbOpenInFavorites.getAccessibleContext().setAccessibleDescription(this.type.getMessage("CheckoutCompletedPanel.cbOpenInFavorites.TT"));
        String title = this.type.getMessage("BK3008");
        DialogDescriptor descriptor = new DialogDescriptor((Object)this.panel, title);
        descriptor.setModal(true);
        this.panel.remove(this.panel.openButton);
        this.panel.remove(this.panel.createButton);
        this.panel.remove(this.panel.closeButton);
        Object[] options = null;
        if (this.numberOfProjects > 1) {
            String msg = this.type.getMessage("BK3009", this.numberOfProjects);
            this.panel.jLabel1.setText(msg);
            options = new Object[]{this.panel.openButton, this.panel.closeButton};
        } else if (this.numberOfProjects == 1) {
            Project project = this.checkedOutProjects.get(null).iterator().next();
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
            String projectName = projectInformation.getDisplayName();
            String msg = this.type.getMessage("BK3011", projectName);
            this.panel.jLabel1.setText(msg);
            this.panel.openButton.setText(NbBundle.getMessage(ProjectOpener.class, (String)"BK3012"));
            options = new Object[]{this.panel.openButton, this.panel.closeButton};
        } else {
            String msg = this.type.getMessage("BK3010");
            this.panel.jLabel1.setText(msg);
            options = new Object[]{this.panel.createButton, this.panel.closeButton};
        }
        descriptor.setMessageType(1);
        descriptor.setOptions(options);
        descriptor.setClosingOptions(options);
        this.dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        this.dialog.getAccessibleContext().setAccessibleDescription(this.type.getMessage("ACSD_Completed_Dialog"));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectOpener.this.dialog.setVisible(true);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        this.dialog.setVisible(false);
        if (this.panel.cbOpenInFavorites.isSelected()) {
            Utils.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        Favorites.getDefault().selectWithAddition(FileUtil.toFileObject((File)ProjectOpener.this.workingFolder));
                    }
                    catch (DataObjectNotFoundException ex) {
                        Logger.getLogger(ProjectOpener.class.getName()).log(Level.INFO, null, ex);
                    }
                }
            });
        }
        if (this.panel.openButton.equals(src)) {
            if (this.numberOfProjects > 1) {
                this.selectAndOpenProjects(this.checkedOutProjects);
            } else {
                this.openProject(this.checkedOutProjects.get(null).iterator().next());
            }
        } else if (this.panel.createButton.equals(src) && this.workingFolder.isDirectory()) {
            ProjectUtilities.newProjectWizard(this.workingFolder);
        }
    }

    private void openProject(Project p) {
        Project[] projects = new Project[]{p};
        OpenProjects.getDefault().open(projects, false, true);
        ProjectUtilities.selectAndExpandProject(p);
    }

    private void selectAndOpenProjects(Map<Project, Set<Project>> projects) {
        this.projectsPanel = new OpenProjectsPanel();
        ProjectsView view = new ProjectsView(projects);
        this.projectsPanel.jPanel1.setLayout(new BorderLayout());
        this.projectsPanel.jPanel1.add((Component)view, "Center");
        view.addSelectionChangeListener(this);
        this.okButton = new JButton(NbBundle.getMessage(CheckoutCompletedPanel.class, (String)"LBL_ButtonOpen"));
        this.okButton.setEnabled(false);
        JButton cancelButton = new JButton(NbBundle.getMessage(CheckoutCompletedPanel.class, (String)"LBL_ButtonCancel"));
        DialogDescriptor dd = new DialogDescriptor((Object)this.projectsPanel, NbBundle.getMessage(CheckoutCompletedPanel.class, (String)"LBL_OpenPanelLabel"), true, new Object[]{this.okButton, cancelButton}, (Object)this.okButton, 0, new HelpCtx(this.getClass()), null);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
        dlg.setVisible(true);
        if (dd.getValue() == this.okButton) {
            final Set<Project> selectedProjects = view.getSelectedProjects();
            if (this.projectsPanel.cbOpenRequired.isSelected()) {
                Utils.postParallel(new Runnable(){

                    @Override
                    public void run() {
                        final HashSet<Project> toOpen = new HashSet<Project>();
                        HashMap<Project, Set<? extends Project>> cache = new HashMap<Project, Set<? extends Project>>();
                        toOpen.addAll(selectedProjects);
                        for (Project p : selectedProjects) {
                            ProjectUtilities.addSubprojects(p, toOpen, cache);
                        }
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                for (Project p : toOpen) {
                                    ProjectOpener.this.openProject(p);
                                }
                            }
                        });
                    }
                }, 0);
            } else {
                for (Project p : selectedProjects) {
                    this.openProject(p);
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            Node[] nodes = (Node[])evt.getNewValue();
            if (nodes.length == 0) {
                this.okButton.setEnabled(false);
            } else {
                this.okButton.setEnabled(true);
            }
        }
    }

    public static enum ProjectOpenerType {
        EXPORT("EXPORT_"),
        CHECKOUT("CHECKOUT_"),
        CLONE("CLONE_");

        private final String prefix;

        private ProjectOpenerType(String prefix) {
            this.prefix = prefix;
        }

        public String toString() {
            return this.prefix;
        }

        String getMessage(String key) {
            return NbBundle.getMessage(ProjectOpener.class, (String)(this.prefix + key));
        }

        String getMessage(String key, Object ... params) {
            return NbBundle.getMessage(ProjectOpener.class, (String)(this.prefix + key), (Object[])params);
        }
    }
}

