/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.devmodules.spi;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.common.api.OriginalCMPMapping;
import org.netbeans.modules.j2ee.deployment.common.api.SourceFileMap;
import org.netbeans.modules.j2ee.deployment.common.api.ValidationException;
import org.netbeans.modules.j2ee.deployment.config.ConfigFilesListener;
import org.netbeans.modules.j2ee.deployment.config.ConfigSupportImpl;
import org.netbeans.modules.j2ee.deployment.config.J2eeModuleAccessor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ResourceChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ConfigurationFilesListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.impl.DefaultSourceMap;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerTarget;
import org.netbeans.modules.j2ee.deployment.impl.projects.J2eeModuleProviderAccessor;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.modules.j2ee.deployment.plugins.spi.VerifierSupport;
import org.openide.filesystems.FileObject;

public abstract class J2eeModuleProvider {
    private static final Logger LOGGER = Logger.getLogger(J2eeModuleProvider.class.getName());
    private final Object configSupportImplLock = new Object();
    private ConfigSupportImpl configSupportImpl;
    private final CopyOnWriteArrayList<ConfigurationFilesListener> listeners = new CopyOnWriteArrayList();
    private ConfigFilesListener configFilesListener = null;

    public abstract J2eeModule getJ2eeModule();

    public abstract ModuleChangeReporter getModuleChangeReporter();

    @CheckForNull
    public ResourceChangeReporter getResourceChangeReporter() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ConfigSupport getConfigSupport() {
        ConfigSupportImpl confSupp;
        Object object = this.configSupportImplLock;
        synchronized (object) {
            confSupp = this.configSupportImpl;
        }
        if (confSupp == null) {
            confSupp = new ConfigSupportImpl(this);
            object = this.configSupportImplLock;
            synchronized (object) {
                this.configSupportImpl = confSupp;
            }
        }
        return confSupp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetConfigSupport() {
        Object object = this.configSupportImplLock;
        synchronized (object) {
            this.configSupportImpl = null;
        }
    }

    public final ServerDebugInfo getServerDebugInfo() {
        ServerInstance si = ServerRegistry.getInstance().getServerInstance(this.getServerInstanceID());
        if (si == null) {
            return null;
        }
        StartServer ss = si.getStartServer();
        if (ss == null) {
            return null;
        }
        if (!si.isRunningLastCheck() && ss.needsStartForTargetList()) {
            if (ss.isAlsoTargetServer(null)) {
                return ss.getDebugInfo(null);
            }
            return null;
        }
        Target target = null;
        ServerTarget[] sts = si.getTargets();
        for (int i = 0; i < sts.length; ++i) {
            if (!si.getStartServer().isAlsoTargetServer(sts[i].getTarget())) continue;
            target = sts[i].getTarget();
        }
        if (target == null && sts.length > 0) {
            target = sts[0].getTarget();
        }
        return si.getStartServer().getDebugInfo(target);
    }

    public Set<Datasource> getServerDatasources() throws ConfigurationException {
        ServerInstance si = ServerRegistry.getInstance().getServerInstance(this.getServerInstanceID());
        Set<Datasource> deployedDS = Collections.emptySet();
        if (si != null) {
            deployedDS = si.getDatasources();
        } else {
            Logger.getLogger("global").log(Level.WARNING, "The server data sources cannot be retrieved because the server instance cannot be found.");
        }
        return deployedDS;
    }

    @Deprecated
    public Set<Datasource> getModuleDatasources() throws ConfigurationException {
        Set<Datasource> projectDS = this.getConfigSupport().getDatasources();
        return projectDS;
    }

    public boolean isDatasourceCreationSupported() {
        return this.getConfigSupport().isDatasourceCreationSupported();
    }

    public final Datasource createDatasource(String jndiName, String url, String username, String password, String driver) throws DatasourceAlreadyExistsException, ConfigurationException {
        Set<Datasource> deployedDS = this.getServerDatasources();
        if (deployedDS != null) {
            for (Datasource ds : deployedDS) {
                if (!jndiName.equals(ds.getJndiName())) continue;
                throw new DatasourceAlreadyExistsException(ds);
            }
        }
        Datasource ds = null;
        try {
            ds = this.getConfigSupport().createDatasource(jndiName, url, username, password, driver);
        }
        catch (UnsupportedOperationException oue) {
            Logger.getLogger("global").log(Level.INFO, null, oue);
        }
        return ds;
    }

    @Deprecated
    public void deployDatasources() throws ConfigurationException, DatasourceAlreadyExistsException {
        ServerInstance si = ServerRegistry.getInstance().getServerInstance(this.getServerInstanceID());
        if (si != null) {
            Set<Datasource> moduleDS = this.getModuleDatasources();
            si.deployDatasources(moduleDS);
        } else {
            Logger.getLogger("global").log(Level.WARNING, "The data sources cannot be deployed because the server instance cannot be found.");
        }
    }

    public FileObject[] getSourceRoots() {
        return new FileObject[0];
    }

    public SourceFileMap getSourceFileMap() {
        return new DefaultSourceMap(this);
    }

    public abstract void setServerInstanceID(String var1);

    public abstract String getServerInstanceID();

    public DeployOnSaveSupport getDeployOnSaveSupport() {
        return null;
    }

    public DeployOnSaveClassInterceptor getDeployOnSaveClassInterceptor() {
        return null;
    }

    public File[] getRequiredLibraries() {
        return new File[0];
    }

    public boolean isOnlyCompileOnSaveEnabled() {
        return false;
    }

    public InstanceProperties getInstanceProperties() {
        String serverInstanceID = this.getServerInstanceID();
        if (serverInstanceID == null) {
            return null;
        }
        InstanceProperties props = InstanceProperties.getInstanceProperties(serverInstanceID);
        boolean asserts = false;
        if (!$assertionsDisabled) {
            asserts = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (asserts && props != null) {
            return new WarningInstanceProperties(props);
        }
        return props;
    }

    public abstract String getServerID();

    public String getDeploymentName() {
        return this.getConfigSupportImpl().getDeploymentName();
    }

    public boolean hasVerifierSupport() {
        Server server;
        String serverId = this.getServerID();
        if (serverId != null && (server = ServerRegistry.getInstance().getServer(serverId)) != null) {
            return server.canVerify(this.getJ2eeModule().getType());
        }
        return false;
    }

    public void verify(FileObject target, OutputStream logger) throws ValidationException {
        VerifierSupport verifier = ServerRegistry.getInstance().getServer(this.getServerID()).getVerifierSupport();
        if (verifier == null) {
            throw new ValidationException("Verification not supported by the selected server");
        }
        ModuleType jsrType = J2eeModuleAccessor.getDefault().getJsrModuleType(this.getJ2eeModule().getType());
        if (!verifier.supportsModuleType(jsrType)) {
            throw new ValidationException("Verification not supported for module type " + jsrType);
        }
        ServerRegistry.getInstance().getServer(this.getServerID()).getVerifierSupport().verify(target, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServerChange(String oldServerID, String newServerID) {
        Server oldServer = ServerRegistry.getInstance().getServer(oldServerID);
        Server newServer = ServerRegistry.getInstance().getServer(newServerID);
        if (oldServer == null && newServer != null) {
            ConfigSupportImpl oldConSupp;
            Object object = this.configSupportImplLock;
            synchronized (object) {
                oldConSupp = this.configSupportImpl;
                this.configSupportImpl = null;
            }
            if (oldConSupp != null) {
                this.getConfigSupportImpl().ensureConfigurationReady();
                oldConSupp.dispose();
            }
            return;
        }
        if (oldServer != null && newServer != null && !newServer.equals(oldServer)) {
            if (J2eeModule.Type.WAR.equals(this.getJ2eeModule().getType())) {
                ConfigSupportImpl oldConSupp;
                String oldCtxPath = this.getConfigSupportImpl().getWebContextRoot();
                Object object = this.configSupportImplLock;
                synchronized (object) {
                    oldConSupp = this.configSupportImpl;
                    this.configSupportImpl = null;
                }
                this.getConfigSupportImpl().ensureConfigurationReady();
                if (oldCtxPath == null || oldCtxPath.equals("")) {
                    oldCtxPath = this.getDeploymentName();
                    if (null != oldCtxPath) {
                        char[] c = oldCtxPath.replace(' ', '_').toCharArray();
                        for (int i = 0; i < c.length; ++i) {
                            if (Character.UnicodeBlock.BASIC_LATIN.equals(Character.UnicodeBlock.of(c[i])) && Character.isLetterOrDigit(c[i])) continue;
                            c[i] = 95;
                        }
                        oldCtxPath = "/" + new String(c);
                    } else {
                        LOGGER.log(Level.WARNING, "null deploymentName for " + this.getConfigSupportImpl().toString());
                    }
                }
                this.getConfigSupportImpl().setWebContextRoot(oldCtxPath);
                if (oldConSupp != null) {
                    oldConSupp.dispose();
                }
            } else {
                ConfigSupportImpl oldConSupp;
                Object object = this.configSupportImplLock;
                synchronized (object) {
                    oldConSupp = this.configSupportImpl;
                    this.configSupportImpl = null;
                }
                this.getConfigSupportImpl().ensureConfigurationReady();
                if (oldConSupp != null) {
                    oldConSupp.dispose();
                }
            }
        }
    }

    public final FileObject[] getConfigurationFiles() {
        return this.getConfigurationFiles(false);
    }

    public final FileObject[] getConfigurationFiles(boolean refresh) {
        if (refresh) {
            this.configFilesListener.stopListening();
            this.configFilesListener = null;
        }
        this.addCFL();
        return ConfigSupportImpl.getConfigurationFiles(this);
    }

    public final void addConfigurationFilesListener(ConfigurationFilesListener l) {
        this.listeners.add(l);
    }

    public final void removeConfigurationFilesListener(ConfigurationFilesListener l) {
        this.listeners.remove(l);
    }

    public final void addInstanceListener(InstanceListener l) {
        ServerRegistry.getInstance().addInstanceListener(l);
    }

    public final void removeInstanceListener(InstanceListener l) {
        ServerRegistry.getInstance().removeInstanceListener(l);
    }

    private void addCFL() {
        if (this.configFilesListener != null) {
            return;
        }
        this.configFilesListener = new ConfigFilesListener(this, this.listeners);
    }

    private ConfigSupportImpl getConfigSupportImpl() {
        return (ConfigSupportImpl)this.getConfigSupport();
    }

    static {
        J2eeModuleProviderAccessor.setDefault(new J2eeModuleProviderAccessor(){

            @Override
            public ConfigSupportImpl getConfigSupportImpl(J2eeModuleProvider impl) {
                return impl.getConfigSupportImpl();
            }
        });
    }

    private static class WarningInstanceProperties
    extends InstanceProperties {
        private final InstanceProperties delegate;

        public WarningInstanceProperties(InstanceProperties delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getProperty(String propname) throws IllegalStateException {
            LOGGER.log(Level.WARNING, "Accessing instance property through " + J2eeModuleProvider.class.getName() + " is pointing to a missing API or a bad design of the module");
            return this.delegate.getProperty(propname);
        }

        @Override
        public void setProperty(String propname, String value) throws IllegalStateException {
            LOGGER.log(Level.WARNING, "Accessing instance property through " + J2eeModuleProvider.class.getName() + " is pointing to a missing API or a bad design of the module");
            this.delegate.setProperty(propname, value);
        }

        @Override
        public void setProperties(Properties props) throws IllegalStateException {
            LOGGER.log(Level.WARNING, "Accessing instance property through " + J2eeModuleProvider.class.getName() + " is pointing to a missing API or a bad design of the module");
            this.delegate.setProperties(props);
        }

        @Override
        public void refreshServerInstance() {
            this.delegate.refreshServerInstance();
        }

        @Override
        public Enumeration propertyNames() throws IllegalStateException {
            return this.delegate.propertyNames();
        }

        @Override
        public DeploymentManager getDeploymentManager() {
            return this.delegate.getDeploymentManager();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.delegate.addPropertyChangeListener(listener);
        }
    }

    public static interface DeployOnSaveClassInterceptor {
        public ArtifactListener.Artifact convert(ArtifactListener.Artifact var1);
    }

    public static interface DeployOnSaveSupport {
        public void addArtifactListener(ArtifactListener var1);

        public void removeArtifactListener(ArtifactListener var1);

        public boolean containsIdeArtifacts();
    }

    public static interface ConfigSupport {
        public boolean createInitialConfiguration();

        public boolean ensureConfigurationReady();

        public void setWebContextRoot(String var1) throws ConfigurationException;

        public String getWebContextRoot() throws ConfigurationException;

        public String[] getDeploymentConfigurationFileNames();

        public String getContentRelativePath(String var1);

        public void setCMPMappingInfo(OriginalCMPMapping[] var1) throws ConfigurationException;

        public void setCMPResource(String var1, String var2) throws ConfigurationException;

        public boolean isDatasourceCreationSupported();

        public Set<Datasource> getDatasources() throws ConfigurationException;

        public Datasource createDatasource(String var1, String var2, String var3, String var4, String var5) throws UnsupportedOperationException, DatasourceAlreadyExistsException, ConfigurationException;

        public void bindDatasourceReference(String var1, String var2) throws ConfigurationException;

        public void bindDatasourceReferenceForEjb(String var1, String var2, String var3, String var4) throws ConfigurationException;

        public String findDatasourceJndiName(String var1) throws ConfigurationException;

        public String findDatasourceJndiNameForEjb(String var1, String var2) throws ConfigurationException;

        public Datasource findDatasource(String var1) throws ConfigurationException;

        public void configureLibrary(@NonNull ServerLibraryDependency var1) throws ConfigurationException;

        @NonNull
        public Set<ServerLibraryDependency> getLibraries() throws ConfigurationException;

        public void addLibraryChangeListener(@NonNull ChangeListener var1);

        public void removeLibraryChangeListener(@NonNull ChangeListener var1);

        public boolean isDescriptorRequired();

        public void addDeployOnSaveListener(DeployOnSaveListener var1);

        public void removeDeployOnSaveListener(DeployOnSaveListener var1);

        public Set<MessageDestination> getMessageDestinations() throws ConfigurationException;

        public Set<MessageDestination> getServerMessageDestinations() throws ConfigurationException;

        public boolean supportsCreateMessageDestination();

        public MessageDestination createMessageDestination(String var1, MessageDestination.Type var2) throws UnsupportedOperationException, ConfigurationException;

        public void bindMdbToMessageDestination(String var1, String var2, MessageDestination.Type var3) throws ConfigurationException;

        public String findMessageDestinationName(String var1) throws ConfigurationException;

        public MessageDestination findMessageDestination(String var1) throws ConfigurationException;

        public void bindMessageDestinationReference(String var1, String var2, String var3, MessageDestination.Type var4) throws ConfigurationException;

        public void bindMessageDestinationReferenceForEjb(String var1, String var2, String var3, String var4, String var5, MessageDestination.Type var6) throws ConfigurationException;

        public String findJndiNameForEjb(String var1) throws ConfigurationException;

        public void bindEjbReference(String var1, String var2) throws ConfigurationException;

        public void bindEjbReferenceForEjb(String var1, String var2, String var3, String var4) throws ConfigurationException;

        public static interface DeployOnSaveListener {
            public void deployed(Iterable<ArtifactListener.Artifact> var1);
        }
    }
}

