/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.BCoord;

public final class Coord
implements Comparable<Coord> {
    public int row;
    public int col;

    public Coord() {
        this.row = 0;
        this.col = 0;
    }

    private Coord(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public static Coord make(int row, int col) {
        return new Coord(row, col);
    }

    public Coord(Coord coord) {
        this.row = coord.row;
        this.col = coord.col;
    }

    Coord(BCoord coord, int bias) {
        this.row = coord.row + bias;
        this.col = coord.col;
    }

    BCoord toBCoord(int bias) {
        int new_row = this.row - bias;
        if (new_row < 0) {
            return new BCoord(0, 0);
        }
        return new BCoord(new_row, this.col);
    }

    public void copyFrom(Coord src) {
        this.row = src.row;
        this.col = src.col;
    }

    public Object clone() {
        return new Coord(this.row, this.col);
    }

    public String toString() {
        return "(r=" + this.row + ",c=" + this.col + ")";
    }

    @Override
    public int compareTo(Coord that) throws ClassCastException {
        if (this.row < that.row) {
            return -1;
        }
        if (this.row > that.row) {
            return 1;
        }
        return this.col - that.col;
    }

    void clip(int rows, int cols, int bias) {
        if (this.row < bias) {
            this.row = bias;
        } else if (this.row > bias + rows) {
            this.row = bias + rows;
        }
        if (this.col < 0) {
            this.col = 0;
        } else if (this.col > cols) {
            this.col = cols;
        }
    }
}

