/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.common;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Anchor {
    private static final Set<Character> INVALID_ANCHOR = new HashSet<Character>();
    private final String value;

    public Anchor(String value) {
        Objects.requireNonNull(value, "Anchor must be provided.");
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Empty anchor.");
        }
        for (int i = 0; i < value.length(); ++i) {
            if (!INVALID_ANCHOR.contains(Character.valueOf(value.charAt(i)))) continue;
            throw new IllegalArgumentException("Invalid char in anchor: " + value.charAt(i));
        }
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Anchor anchor1 = (Anchor)o;
        return Objects.equals(this.value, anchor1.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    static {
        INVALID_ANCHOR.add(Character.valueOf('['));
        INVALID_ANCHOR.add(Character.valueOf(']'));
        INVALID_ANCHOR.add(Character.valueOf('{'));
        INVALID_ANCHOR.add(Character.valueOf('}'));
        INVALID_ANCHOR.add(Character.valueOf(','));
        INVALID_ANCHOR.add(Character.valueOf('*'));
        INVALID_ANCHOR.add(Character.valueOf('&'));
    }
}

