/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.webapp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class MultipartRequest
extends HttpServletRequestWrapper {
    private static final Logger logger = Logger.getLogger(MultipartRequest.class.getName());
    private Map<String, List<String>> formParams = new LinkedHashMap<String, List<String>>();
    private Map<String, List<FileItem>> fileParams = new LinkedHashMap<String, List<FileItem>>();
    private Map<String, String[]> parameterMap;

    public MultipartRequest(HttpServletRequest request, ServletFileUpload servletFileUpload) throws IOException {
        super(request);
        this.parseRequest(request, servletFileUpload);
    }

    private void parseRequest(HttpServletRequest request, ServletFileUpload servletFileUpload) throws IOException {
        try {
            List fileItems = servletFileUpload.parseRequest(request);
            for (FileItem item : fileItems) {
                if (item.isFormField()) {
                    this.addFormParam(item);
                    continue;
                }
                this.addFileParam(item);
            }
        }
        catch (FileUploadException e) {
            logger.severe("Error in parsing fileupload request");
            throw new IOException(e.getMessage(), e);
        }
    }

    private void addFileParam(FileItem item) {
        if (this.fileParams.containsKey(item.getFieldName())) {
            this.fileParams.get(item.getFieldName()).add(item);
        } else {
            ArrayList<FileItem> items = new ArrayList<FileItem>();
            items.add(item);
            this.fileParams.put(item.getFieldName(), items);
        }
    }

    private void addFormParam(FileItem item) {
        if (this.formParams.containsKey(item.getFieldName())) {
            this.formParams.get(item.getFieldName()).add(this.getItemString(item));
        } else {
            ArrayList<String> items = new ArrayList<String>();
            items.add(this.getItemString(item));
            this.formParams.put(item.getFieldName(), items);
        }
    }

    private String getItemString(FileItem item) {
        try {
            String characterEncoding = this.getRequest().getCharacterEncoding();
            return characterEncoding == null ? item.getString() : item.getString(characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            logger.severe("Unsupported character encoding " + this.getRequest().getCharacterEncoding());
            return item.getString();
        }
    }

    public String getParameter(String name) {
        if (this.formParams.containsKey(name)) {
            List<String> values = this.formParams.get(name);
            if (values.isEmpty()) {
                return "";
            }
            return values.get(0);
        }
        return super.getParameter(name);
    }

    public Map getParameterMap() {
        if (this.parameterMap == null) {
            LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
            for (String formParam : this.formParams.keySet()) {
                map.put(formParam, this.formParams.get(formParam).toArray(new String[0]));
            }
            map.putAll(super.getParameterMap());
            this.parameterMap = Collections.unmodifiableMap(map);
        }
        return this.parameterMap;
    }

    public Enumeration getParameterNames() {
        LinkedHashSet<String> paramNames = new LinkedHashSet<String>();
        paramNames.addAll(this.formParams.keySet());
        Enumeration original = super.getParameterNames();
        while (original.hasMoreElements()) {
            paramNames.add((String)original.nextElement());
        }
        return Collections.enumeration(paramNames);
    }

    public String[] getParameterValues(String name) {
        if (this.formParams.containsKey(name)) {
            List<String> values = this.formParams.get(name);
            if (values.isEmpty()) {
                return new String[0];
            }
            return values.toArray(new String[values.size()]);
        }
        return super.getParameterValues(name);
    }

    public FileItem getFileItem(String name) {
        if (this.fileParams.containsKey(name)) {
            List<FileItem> items = this.fileParams.get(name);
            return items.get(0);
        }
        return null;
    }
}

