/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.primefaces.component.selectoneradio.SelectOneRadio;
import org.primefaces.util.WidgetBuilder;

public class SelectOneRadioRenderer
extends org.primefaces.component.selectoneradio.SelectOneRadioRenderer {
    protected void encodeScript(FacesContext context, SelectOneRadio radio) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectOneRadio", radio.resolveWidgetVar(), radio.getClientId(context)).finish();
    }

    protected void encodeMarkup(FacesContext context, SelectOneRadio radio) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = radio.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)radio);
        String style = radio.getStyle();
        String styleClass = radio.getStyleClass();
        Converter converter = radio.getConverter();
        writer.startElement("div", (UIComponent)radio);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)style, "styleClass");
        }
        if (selectItems != null && !selectItems.isEmpty()) {
            Object value = radio.getSubmittedValue();
            if (value == null) {
                value = radio.getValue();
            }
            Class type = value == null ? String.class : value.getClass();
            int idx = 0;
            for (SelectItem selectItem : selectItems) {
                boolean disabled = selectItem.isDisabled() || radio.isDisabled();
                String id = clientId + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
                Object coercedItemValue = this.coerceToModelType(context, selectItem.getValue(), type);
                boolean selected = coercedItemValue != null && coercedItemValue.equals(value);
                this.encodeOption(context, radio, selectItem, id, clientId, converter, selected, disabled);
                ++idx;
            }
        }
        writer.endElement("div");
    }

    protected void encodeOption(FacesContext context, SelectOneRadio radio, SelectItem option, String id, String name, Converter converter, boolean selected, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)radio, converter, option.getValue());
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        this.renderOnchange(context, (UIComponent)radio);
        this.renderDynamicPassThruAttributes(context, (UIComponent)radio);
        if (radio.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)radio.getTabindex(), null);
        }
        if (selected) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.startElement("label", null);
        writer.writeAttribute("for", (Object)id, null);
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), null);
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("label");
    }
}

