/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.primefaces.application.PrimeResource;
import org.primefaces.context.RequestContext;
import org.primefaces.model.StreamedContent;
import org.primefaces.util.StringEncrypter;

public class PrimeResourceHandler
extends ResourceHandlerWrapper {
    private static final Logger logger = Logger.getLogger(PrimeResourceHandler.class.getName());
    private ResourceHandler wrapped;

    public PrimeResourceHandler(ResourceHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public Resource createResource(String resourceName, String libraryName) {
        Resource resource = super.createResource(resourceName, libraryName);
        if (resource != null && libraryName != null && libraryName.equalsIgnoreCase("primefaces")) {
            return new PrimeResource(resource);
        }
        return resource;
    }

    public void handleResourceRequest(FacesContext context) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        String library = (String)params.get("ln");
        String dynamicContentId = (String)params.get("pfdrid");
        StringEncrypter strEn = RequestContext.getCurrentInstance().getEncrypter();
        if (dynamicContentId != null && library != null && library.equals("primefaces")) {
            StreamedContent streamedContent = null;
            boolean cache = Boolean.valueOf((String)params.get("pfdrid_c"));
            try {
                String dynamicContentEL = strEn.decrypt(dynamicContentId);
                ExternalContext externalContext = context.getExternalContext();
                if (dynamicContentEL != null) {
                    int length;
                    ELContext eLContext = context.getELContext();
                    ValueExpression ve = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), dynamicContentEL, StreamedContent.class);
                    streamedContent = (StreamedContent)ve.getValue(eLContext);
                    externalContext.setResponseStatus(200);
                    externalContext.setResponseContentType(streamedContent.getContentType());
                    if (cache) {
                        SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                        httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                        Calendar calendar = Calendar.getInstance();
                        calendar.add(1, 1);
                        externalContext.setResponseHeader("Cache-Control", "max-age=29030400");
                        externalContext.setResponseHeader("Expires", httpDateFormat.format(calendar.getTime()));
                    } else {
                        externalContext.setResponseHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                        externalContext.setResponseHeader("Pragma", "no-cache");
                        externalContext.setResponseHeader("Expires", "Mon, 8 Aug 1980 10:00:00 GMT");
                    }
                    if (streamedContent.getContentEncoding() != null) {
                        externalContext.setResponseHeader("Content-Encoding", streamedContent.getContentEncoding());
                    }
                    byte[] buffer = new byte[2048];
                    InputStream inputStream = streamedContent.getStream();
                    while ((length = inputStream.read(buffer)) >= 0) {
                        externalContext.getResponseOutputStream().write(buffer, 0, length);
                    }
                }
                externalContext.responseFlushBuffer();
                context.responseComplete();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in streaming dynamic resource. {0}", new Object[]{e.getMessage()});
                throw new IOException(e);
            }
            finally {
                if (streamedContent != null) {
                    streamedContent.getStream().close();
                }
            }
        } else {
            super.handleResourceRequest(context);
        }
    }
}

