/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.weblogic.common.api;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.weblogic.common.api.DomainConfiguration;
import org.netbeans.modules.weblogic.common.api.Version;
import org.netbeans.modules.weblogic.common.api.WebLogicConfiguration;
import org.openide.filesystems.FileUtil;

public final class WebLogicLayout {
    private static final WeakHashMap<WebLogicConfiguration, ClassLoader> CLASSLOADERS = new WeakHashMap();
    private static final String WEBLOGIC_JAR = "server/lib/weblogic.jar";
    private static final Collection<String> EXPECTED_FILES = new ArrayList<String>();
    private static final Logger LOGGER;
    private final WebLogicConfiguration config;

    WebLogicLayout(WebLogicConfiguration config) {
        this.config = config;
    }

    @CheckForNull
    public File getDomainConfigFile() {
        if (this.config.isRemote()) {
            return null;
        }
        return WebLogicLayout.getDomainConfigFile(this.config.getDomainHome());
    }

    @NonNull
    public static File getDomainConfigFile(File domain) {
        return FileUtil.normalizeFile((File)new File(domain, "config" + File.separator + "config.xml"));
    }

    @CheckForNull
    public File getServerLibDirectory() {
        File serverLib = new File(this.config.getServerHome(), "server" + File.separator + "lib");
        if (serverLib.isDirectory()) {
            return serverLib;
        }
        return null;
    }

    @CheckForNull
    public File getDomainLibDirectory() {
        if (this.config.isRemote()) {
            return null;
        }
        File domainLib = new File(this.config.getDomainHome(), "lib");
        if (domainLib.exists() && domainLib.isDirectory()) {
            return domainLib;
        }
        return null;
    }

    @NonNull
    public File getWeblogicJar() {
        return WebLogicLayout.getWeblogicJar(this.config.getServerHome());
    }

    @NonNull
    public static File getWeblogicJar(@NonNull File serverHome) {
        File weblogicJar = FileUtil.normalizeFile((File)new File(serverHome, WEBLOGIC_JAR));
        return weblogicJar;
    }

    @CheckForNull
    public static DomainConfiguration getDomainConfiguration(String domainPath) {
        DomainConfiguration ret = DomainConfiguration.getInstance(new File(domainPath), false);
        if (ret == null) {
            LOGGER.log(Level.FINE, "Domain config file is not found. Probably server configuration was changed externally");
        }
        return ret;
    }

    public static boolean isSupportedLayout(File candidate) {
        return null != candidate && candidate.canRead() && candidate.isDirectory() && WebLogicLayout.hasRequiredChildren(candidate, EXPECTED_FILES);
    }

    public static boolean isSupportedVersion(Version version) {
        return version != null && (Integer.valueOf(9).equals(version.getMajor()) || Integer.valueOf(10).equals(version.getMajor()) || Integer.valueOf(11).equals(version.getMajor()) || Integer.valueOf(12).equals(version.getMajor()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public File[] getClassPath() {
        File mwHome;
        File weblogicJar = this.getWeblogicJar();
        if (!weblogicJar.exists()) {
            LOGGER.log(Level.INFO, "File {0} does not exist for {1}", new Object[]{weblogicJar.getAbsolutePath(), this.config.getServerHome()});
            return new File[]{weblogicJar};
        }
        String serverModulesJar = null;
        try {
            JarFile jar = new JarFile(weblogicJar);
            try {
                Manifest manifest = jar.getManifest();
                if (manifest != null) {
                    String[] elements;
                    String classpath = manifest.getMainAttributes().getValue("Class-Path");
                    for (String element : elements = classpath.split("\\s+")) {
                        int index;
                        if (!element.contains("weblogic.server.modules")) continue;
                        File ref = new File(weblogicJar.getParentFile(), element);
                        if (!ref.exists()) {
                            LOGGER.log(Level.INFO, "Broken {0} classpath file {1} for {2}", new Object[]{weblogicJar.getAbsolutePath(), ref.getAbsolutePath(), this.config.getServerHome()});
                        }
                        if ((index = (serverModulesJar = element).lastIndexOf("./")) < 0) continue;
                        serverModulesJar = serverModulesJar.substring(index + 1);
                    }
                }
            }
            finally {
                try {
                    jar.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINEST, null, ex);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, null, e);
        }
        if (serverModulesJar != null && (mwHome = WebLogicLayout.getMiddlewareHome(this.config.getServerHome())) != null) {
            File serverModuleFile = FileUtil.normalizeFile((File)new File(mwHome, serverModulesJar.replace("/", File.separator)));
            return new File[]{weblogicJar, serverModuleFile};
        }
        return new File[]{weblogicJar};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ClassLoader getClassLoader() {
        WeakHashMap<WebLogicConfiguration, ClassLoader> weakHashMap = CLASSLOADERS;
        synchronized (weakHashMap) {
            ClassLoader classLoader = CLASSLOADERS.get(this.config);
            if (classLoader != null) {
                return classLoader;
            }
            for (Map.Entry<WebLogicConfiguration, ClassLoader> entry : CLASSLOADERS.entrySet()) {
                String serverRootCached = entry.getKey().getServerHome().getAbsolutePath();
                String serverRootFresh = this.config.getServerHome().getAbsolutePath();
                if (!(serverRootCached == null ? serverRootFresh == null : serverRootCached.equals(serverRootFresh))) continue;
                classLoader = entry.getValue();
                break;
            }
            if (classLoader == null) {
                classLoader = this.createClassLoader();
            }
            CLASSLOADERS.put(this.config, classLoader);
            return classLoader;
        }
    }

    @CheckForNull
    public Version getServerVersion() {
        return WebLogicLayout.getServerVersion(this.config.getServerHome());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public static Version getServerVersion(@NonNull File serverHome) {
        File weblogicJar = WebLogicLayout.getWeblogicJar(serverHome);
        if (!weblogicJar.exists()) {
            return null;
        }
        try {
            JarFile jar = new JarFile(weblogicJar);
            try {
                Manifest manifest = jar.getManifest();
                String implementationVersion = null;
                if (manifest != null) {
                    implementationVersion = manifest.getMainAttributes().getValue("Implementation-Version");
                }
                if (implementationVersion == null) return null;
                implementationVersion = implementationVersion.trim();
                Version version = Version.fromJsr277OrDottedNotationWithFallback(implementationVersion);
                return version;
            }
            finally {
                try {
                    jar.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINEST, null, ex);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, null, e);
        }
        return null;
    }

    @CheckForNull
    public File getMiddlewareHome() {
        return WebLogicLayout.getMiddlewareHome(this.config.getServerHome());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static File getMiddlewareHome(@NonNull File serverHome) {
        Properties ret = new Properties();
        File productProps = new File(serverHome, ".product.properties");
        if (!productProps.exists() || !productProps.canRead()) {
            return WebLogicLayout.getMiddlewareHome(serverHome, null);
        }
        try {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(productProps));){
                ret.load(is);
            }
            return WebLogicLayout.getMiddlewareHome(serverHome, ret.getProperty("MW_HOME"));
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return WebLogicLayout.getMiddlewareHome(serverHome, null);
        }
    }

    @CheckForNull
    private static File getMiddlewareHome(@NonNull File serverHome, @NullAllowed String mwHome) {
        File middleware = null;
        if (mwHome != null) {
            middleware = new File(mwHome);
        }
        if (middleware == null || !middleware.exists() || !middleware.isDirectory()) {
            middleware = serverHome.getParentFile();
        }
        if (middleware != null && middleware.exists() && middleware.isDirectory()) {
            return middleware;
        }
        return null;
    }

    private static boolean hasRequiredChildren(File candidate, Collection<String> requiredChildren) {
        if (null == candidate) {
            return false;
        }
        String[] children = candidate.list();
        if (null == children) {
            return false;
        }
        if (null == requiredChildren) {
            return true;
        }
        for (String next : requiredChildren) {
            File test = new File(candidate.getPath() + File.separator + next);
            if (test.exists()) continue;
            return false;
        }
        return true;
    }

    private WebLogicClassLoader createClassLoader() {
        LOGGER.log(Level.FINE, "Creating classloader for {0}", this.config.getId());
        try {
            File[] classpath = this.getClassPath();
            URL[] urls = new URL[classpath.length];
            for (int i = 0; i < classpath.length; ++i) {
                urls[i] = classpath[i].toURI().toURL();
            }
            WebLogicClassLoader classLoader = new WebLogicClassLoader(urls, WebLogicConfiguration.class.getClassLoader());
            LOGGER.log(Level.FINE, "Classloader for {0} created successfully", this.config.getId());
            return classLoader;
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, null, e);
            return new WebLogicClassLoader(new URL[0], WebLogicConfiguration.class.getClassLoader());
        }
    }

    static {
        EXPECTED_FILES.add("common");
        EXPECTED_FILES.add("server/bin");
        EXPECTED_FILES.add(WEBLOGIC_JAR);
        LOGGER = Logger.getLogger(WebLogicLayout.class.getName());
    }

    private static class ServerDescriptor {
        private final String host;
        private final String port;
        private final String name;

        public ServerDescriptor(String host, String port, String name) {
            this.host = host;
            this.port = port;
            this.name = name;
        }

        public String getHost() {
            return this.host;
        }

        public String getName() {
            return this.name;
        }

        public String getPort() {
            return this.port;
        }
    }

    private static class WebLogicClassLoader
    extends URLClassLoader {
        public WebLogicClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> clazz = super.findClass(name);
            if (LOGGER.isLoggable(Level.FINEST)) {
                String filename = name.replace('.', '/');
                int index = filename.indexOf(36);
                if (index > 0) {
                    filename = filename.substring(0, index);
                }
                filename = filename + ".class";
                URL url = this.getResource(filename);
                LOGGER.log(Level.FINEST, "WebLogic classloader asked for {0}", name);
                if (url != null) {
                    LOGGER.log(Level.FINEST, "WebLogic classloader found {0} at {1}", new Object[]{name, url});
                }
            }
            return clazz;
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            Permissions p = new Permissions();
            p.add(new AllPermission());
            return p;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (name.contains("jndi.properties") || name.contains("i18n_user.properties")) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getResources(name);
        }
    }
}

