/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.util.CommandFormatter;
import org.openide.util.NbBundle;

public class TriggerEvent {
    public static final int INSERT = 1;
    public static final int UPDATE = 2;
    public static final int DELETE = 3;
    private String name;
    private String col;
    private String format;

    public static String getName(int code) {
        switch (code) {
            case 1: {
                return "INSERT";
            }
            case 2: {
                return "UPDATE";
            }
            case 3: {
                return "DELETE";
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aname) {
        this.name = aname;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String fmt) {
        this.format = fmt;
    }

    public String getColumn() {
        return this.col;
    }

    public void setColumn(String column) {
        this.col = column;
    }

    public Map getColumnProperties(AbstractCommand cmd) throws DDLException {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("event.name", cmd.quote(this.name));
        args.put("event.column", cmd.quote(this.col));
        return args;
    }

    public String getCommand(AbstractCommand cmd) throws DDLException {
        if (this.format == null) {
            throw new DDLException(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_NoFormatSpec"));
        }
        try {
            Map cprops = this.getColumnProperties(cmd);
            return CommandFormatter.format(this.format, cprops);
        }
        catch (Exception e) {
            throw new DDLException(e.getMessage());
        }
    }
}

